<?php
// Test Payment API Response
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🧪 Payment API Test</h2>";
echo "<hr>";

// Test data
$mobile = "9876543210";
$user_token = "USER_123_test123";
$amount = 100;
$txn_id = "TXN" . time() . rand(1000, 9999);

echo "<h3>📤 Request Data:</h3>";
echo "<pre>";
echo "Mobile: $mobile\n";
echo "User Token: $user_token\n";
echo "Amount: $amount\n";
echo "Order ID: $txn_id\n";
echo "</pre>";

// API URL
$api_url = "https://worki1.swatantranews2.workers.dev/";

// Payload
$payload = http_build_query([
    "customer_mobile" => $mobile,
    "user_token"      => "2585813402611df7245b2b88da612d4b",
    "amount"          => $amount,
    "order_id"        => $txn_id,
    "redirect_url"    => "https://playvipking.com/successful.php",
    "remark1"         => "",
    "remark2"         => ""
]);

echo "<h3>📡 API Call:</h3>";
echo "<pre>URL: $api_url</pre>";
echo "<pre>Payload:\n$payload</pre>";

// Make API call
$ch = curl_init($api_url);
curl_setopt_array($ch, [
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => $payload,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CONNECTTIMEOUT => 15,
    CURLOPT_TIMEOUT        => 30,
    CURLOPT_HTTPHEADER     => ["Content-Type: application/x-www-form-urlencoded"],
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_VERBOSE        => true
]);

$response = curl_exec($ch);
$curl_error = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_info = curl_getinfo($ch);
curl_close($ch);

echo "<h3>📥 Response:</h3>";
echo "<pre>";
echo "HTTP Code: $http_code\n";
echo "Curl Error: " . ($curl_error ?: "None") . "\n";
echo "\nRaw Response:\n";
echo htmlspecialchars($response);
echo "</pre>";

echo "<h3>🔍 Response Analysis:</h3>";
echo "<pre>";

// Check if it's a URL
if(filter_var($response, FILTER_VALIDATE_URL)) {
    echo "✅ Response is a direct URL\n";
    echo "URL: $response\n";
} else {
    // Try JSON decode
    $json_data = json_decode($response, true);
    
    if(json_last_error() === JSON_ERROR_NONE) {
        echo "✅ Response is valid JSON\n\n";
        echo "Parsed JSON:\n";
        print_r($json_data);
        
        // Check for payment URL in different keys
        if(isset($json_data['payment_url'])) {
            echo "\n✅ Found payment_url: " . $json_data['payment_url'] . "\n";
        } elseif(isset($json_data['url'])) {
            echo "\n✅ Found url: " . $json_data['url'] . "\n";
        } elseif(isset($json_data['data']['payment_url'])) {
            echo "\n✅ Found data.payment_url: " . $json_data['data']['payment_url'] . "\n";
        } elseif(isset($json_data['data']['url'])) {
            echo "\n✅ Found data.url: " . $json_data['data']['url'] . "\n";
        } else {
            echo "\n❌ No payment URL found in response\n";
            echo "Available keys: " . implode(", ", array_keys($json_data)) . "\n";
        }
    } else {
        echo "❌ Response is NOT valid JSON\n";
        echo "JSON Error: " . json_last_error_msg() . "\n";
        
        // Check if it's HTML
        if(strpos($response, '<html') !== false || strpos($response, '<!DOCTYPE') !== false) {
            echo "\n⚠️ Response appears to be HTML\n";
        }
        
        // Show first 500 characters
        echo "\nFirst 500 characters:\n";
        echo htmlspecialchars(substr($response, 0, 500));
    }
}

echo "</pre>";

echo "<h3>🔧 Curl Info:</h3>";
echo "<pre>";
print_r($curl_info);
echo "</pre>";

echo "<hr>";
echo "<p><a href='user/recharge.php'>← Back to Recharge</a></p>";
?>
