<?php
include("../config/db.php");
include("../config/session_user.php");

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$user_id = (int)$_SESSION['user_id'];
$user = mysqli_fetch_assoc(mysqli_query($conn,"SELECT id, name, email, wallet FROM users WHERE id=$user_id"));
if(!$user) {
    $user = ['name' => 'User', 'wallet' => 0];
}
?>
<!DOCTYPE html>
<html>
<head>
<title><?= $page_title ?? 'User Panel' ?> - Color Prediction</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
    min-height: 100vh;
    color: #fff;
    overflow-x: hidden;
}

/* ANIMATED BACKGROUND */
body::before {
    content: '';
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: 
        radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.3) 0%, transparent 50%),
        radial-gradient(circle at 40% 40%, rgba(120, 219, 255, 0.2) 0%, transparent 50%);
    z-index: -1;
    animation: backgroundShift 20s ease-in-out infinite;
}

@keyframes backgroundShift {
    0%, 100% { transform: translateX(0) translateY(0); }
    25% { transform: translateX(-20px) translateY(-10px); }
    50% { transform: translateX(10px) translateY(-20px); }
    75% { transform: translateX(-10px) translateY(10px); }
}

/* HEADER */
.header {
    background: rgba(15, 52, 96, 0.8);
    backdrop-filter: blur(30px);
    border-bottom: 2px solid rgba(255, 215, 0, 0.2);
    padding: 18px 30px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
    position: sticky;
    top: 0;
    z-index: 100;
    min-height: 70px;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 20px;
    flex: 1;
}

.page-title {
    font-size: 24px;
    font-weight: 800;
    color: #ffd700;
    letter-spacing: 0.5px;
    text-shadow: 0 0 20px rgba(255, 215, 0, 0.2);
}

.header-right {
    display: flex;
    align-items: center;
    gap: 30px;
    flex: 1;
    justify-content: flex-end;
}

.user-info {
    text-align: right;
    display: flex;
    flex-direction: column;
    gap: 4px;
}

.user-name {
    font-size: 16px;
    font-weight: 600;
    color: #fff;
    letter-spacing: 0.3px;
}

.user-balance {
    font-size: 22px;
    font-weight: 800;
    color: #ffd700;
    text-shadow: 0 0 15px rgba(255, 215, 0, 0.3);
}

/* MAIN CONTAINER */
.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 25px;
    overflow-x: hidden;
}

.content-box {
    background: linear-gradient(135deg, rgba(15, 52, 96, 0.6), rgba(22, 33, 62, 0.6));
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 30px;
    border: 2px solid rgba(255, 215, 0, 0.15);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
    margin-bottom: 25px;
    overflow-x: hidden;
}

.section-title {
    font-size: 28px;
    font-weight: 700;
    color: #ffd700;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
    letter-spacing: 1px;
    text-shadow: 0 0 20px rgba(255, 215, 0, 0.2);
}
}

/* CARDS */
.card {
    background: rgba(255, 255, 255, 0.15);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 20px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: all 0.3s ease;
    margin-bottom: 15px;
    font-size: 16px;
    line-height: 1.6;
}

.card:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
    border-color: rgba(255, 255, 255, 0.4);
}

.card h3 {
    font-size: 18px;
}

.card p {
    font-size: 16px;
}

/* BUTTONS */
.btn {
    background: linear-gradient(135deg, #ffd700, #ffb700);
    color: #000;
    border: none;
    padding: 14px 28px;
    border-radius: 12px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-size: 16px;
    letter-spacing: 0.5px;
    box-shadow: 0 8px 20px rgba(255, 215, 0, 0.3);
}

.btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 12px 30px rgba(255, 215, 0, 0.5);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.15);
    color: #ffd700;
    font-size: 15px;
    padding: 12px 20px;
    border: 2px solid rgba(255, 215, 0, 0.3);
    font-weight: 600;
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.25);
    border-color: rgba(255, 215, 0, 0.6);
}

/* TABLE */
.table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

.table th,
.table td {
    padding: 15px;
    text-align: left;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    font-size: 14px;
}

.table th {
    background: rgba(255, 215, 0, 0.1);
    font-weight: 700;
    color: #ffd700;
    font-size: 13px;
}

.table tr:hover {
    background: rgba(255, 255, 255, 0.05);
}

.game-history-table {
    width: 100%;
    border-collapse: collapse;
}

.game-history-table th,
.game-history-table td {
    padding: 14px;
    text-align: left;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    font-size: 14px;
    white-space: nowrap;
}

.game-history-table th {
    background: rgba(255, 215, 0, 0.1);
    font-weight: 700;
    color: #ffd700;
    font-size: 13px;
}

.game-history-table tbody tr:hover {
    background: rgba(255, 255, 255, 0.05);
}

@media (max-width: 768px) {
    .game-history-table th,
    .game-history-table td {
        padding: 12px 8px;
        font-size: 12px;
    }
    
    .game-history-table th {
        font-size: 11px;
    }
}

@media (max-width: 480px) {
    .game-history-table {
        font-size: 11px;
        overflow-x: auto;
        display: block;
    }
    
    .game-history-table th,
    .game-history-table td {
        padding: 10px 6px;
        font-size: 11px;
        white-space: normal;
    }
    
    .game-history-table th {
        font-size: 10px;
    }
}

.result-history-table {
    width: 100%;
    border-collapse: collapse;
    table-layout: auto;
}

.result-history-table th,
.result-history-table td {
    padding: 14px;
    text-align: left;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    font-size: 14px;
}

.result-history-table th {
    background: rgba(255, 215, 0, 0.1);
    font-weight: 700;
    color: #ffd700;
    font-size: 13px;
}

.result-history-table tbody tr:hover {
    background: rgba(255, 255, 255, 0.05);
}

@media (max-width: 768px) {
    .result-history-table th,
    .result-history-table td {
        padding: 12px 10px;
        font-size: 13px;
    }
    
    .result-history-table th {
        font-size: 12px;
    }
}

@media (max-width: 480px) {
    .result-history-table th,
    .result-history-table td {
        padding: 11px 8px;
        font-size: 12px;
    }
    
    .result-history-table th {
        font-size: 11px;
    }
}

.recharge-history-wrapper {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    max-width: 100%;
    border-radius: 10px;
}

.recharge-history-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

.recharge-history-table th {
    background: rgba(255, 255, 255, 0.15);
    font-weight: 700;
    color: #ffd700;
    font-size: 16px;
    padding: 18px;
    text-align: left;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.recharge-history-table td {
    padding: 18px;
    font-size: 16px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    text-align: left;
}

.recharge-history-table tbody tr {
    transition: all 0.3s ease;
}

.recharge-history-table tbody tr:hover {
    background: rgba(255, 255, 255, 0.08);
}

/* STATUS BADGES */
.status {
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
    display: inline-block;
}

.status.approved {
    background: rgba(39, 174, 96, 0.3);
    color: #27ae60;
    border: 1px solid #27ae60;
}

.status.pending {
    background: rgba(231, 76, 60, 0.3);
    color: #e74c3c;
    border: 1px solid #e74c3c;
}

.status.completed {
    background: rgba(39, 174, 96, 0.3);
    color: #27ae60;
    border: 1px solid #27ae60;
}

.status.failed {
    background: rgba(231, 76, 60, 0.3);
    color: #e74c3c;
    border: 1px solid #e74c3c;
}

.status.win {
    background: rgba(39, 174, 96, 0.3);
    color: #27ae60;
    border: 1px solid #27ae60;
}

.status.loss {
    background: rgba(231, 76, 60, 0.3);
    color: #e74c3c;
    border: 1px solid #e74c3c;
}

/* MOBILE RESPONSIVE */
@media (max-width: 768px) {
    .header {
        padding: 14px 15px;
        min-height: 60px;
    }
    
    .header-left {
        gap: 12px;
    }
    
    .page-title {
        font-size: 18px;
    }
    
    .header-right {
        gap: 15px;
    }
    
    .user-name {
        font-size: 14px;
    }
    
    .user-balance {
        font-size: 18px;
    }
    
    .container {
        padding: 15px;
    }
    
    .content-box {
        padding: 20px;
    }
    
    .section-title {
        font-size: 22px;
    }
}

@media (max-width: 480px) {
    .header {
        padding: 12px 12px;
        min-height: 55px;
    }
    
    .header-left {
        gap: 8px;
    }
    
    .page-title {
        font-size: 16px;
    }
    
    .header-right {
        gap: 12px;
    }
    
    .user-name {
        font-size: 12px;
    }
    
    .user-balance {
        font-size: 16px;
    }
    
    .container {
        padding: 12px;
    }
    
    .content-box {
        padding: 16px;
    }
    
    .section-title {
        font-size: 18px;
    }
}

/* Touch-friendly improvements */
@media (max-width: 768px) {
    .card {
        min-height: 80px;
        touch-action: manipulation;
        -webkit-tap-highlight-color: rgba(255, 255, 255, 0.1);
    }
    
    .btn {
        min-height: 44px;
        touch-action: manipulation;
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0.1);
    }
    
    /* Prevent zoom on form inputs */
    input, select, textarea {
        font-size: 16px;
    }
    
    /* Better scrolling on mobile */
    .content-box {
        -webkit-overflow-scrolling: touch;
    }
}

/* FORM STYLES */
.form-group {
    margin-bottom: 20px;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #fff;
    font-size: 16px;
    letter-spacing: 0.5px;
}

.form-input {
    width: 100%;
    padding: 14px 16px;
    border: 2px solid rgba(255, 215, 0, 0.2);
    border-radius: 12px;
    background: rgba(255, 255, 255, 0.08);
    color: #fff;
    font-size: 16px;
    backdrop-filter: blur(10px);
    transition: all 0.3s ease;
    font-weight: 500;
}

.form-input:focus {
    outline: none;
    border-color: #ffd700;
    box-shadow: 0 0 0 3px rgba(255, 215, 0, 0.2);
    background: rgba(255, 255, 255, 0.12);
}

.form-input::placeholder {
    color: rgba(255, 255, 255, 0.5);
}

select.form-input {
    background: rgba(255, 255, 255, 0.08);
    color: #fff;
    cursor: pointer;
}

select.form-input option {
    background: #1a1a2e;
    color: #fff;
    padding: 10px;
}

@media (max-width: 480px) {
    .form-input {
        padding: 12px 14px;
        font-size: 14px;
    }
}

/* EMPTY STATE */
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: rgba(255, 255, 255, 0.7);
}

.empty-state-icon {
    font-size: 64px;
    margin-bottom: 20px;
    opacity: 0.5;
}

.empty-state-title {
    font-size: 28px;
    font-weight: 600;
    margin-bottom: 10px;
    color: #fff;
}

.empty-state-text {
    font-size: 18px;
    margin-bottom: 30px;
}
</style>
</head>
<body>

<div class="header">
    <div class="header-left">
        <h1 class="page-title"><?= $page_title ?? 'User Panel' ?></h1>
    </div>
    
    <div class="header-right">
        <div class="user-info">
            <div class="user-name">👤 <?= htmlspecialchars($user['name']) ?></div>
            <div class="user-balance">💰 ₹<?= number_format($user['wallet'], 2) ?></div>
        </div>
    </div>
</div>