<script>
// Common JavaScript functions
function goBack() {
    window.history.back();
}

function goHome() {
    window.location.href = 'dashboard.php';
}

// Format currency
function formatCurrency(amount) {
    return '₹' + parseFloat(amount).toLocaleString('en-IN', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });
}

// Format date
function formatDate(dateString) {
    const date = new Date(dateString);
    return date.toLocaleDateString('en-IN', {
        year: 'numeric',
        month: 'short',
        day: 'numeric',
        hour: '2-digit',
        minute: '2-digit'
    });
}

// Show loading state
function showLoading(element) {
    element.innerHTML = '<div style="text-align:center;padding:20px;"><div class="loading"></div><p>Loading...</p></div>';
}

// Add loading animation CSS
const style = document.createElement('style');
style.textContent = `
.loading {
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255,255,255,0.3);
    border-radius: 50%;
    border-top-color: #fff;
    animation: spin 1s ease-in-out infinite;
    margin-bottom: 10px;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
`;
document.head.appendChild(style);
</script>

</body>
</html>