<?php
include("../config/db.php");
header('Content-Type: application/json');

// Function to calculate time ago
function time_elapsed_string($datetime) {
    $time = time() - strtotime($datetime);
    
    if ($time < 60) return 'Just now';
    if ($time < 3600) return floor($time/60) . 'm ago';
    if ($time < 86400) return floor($time/3600) . 'h ago';
    if ($time < 2592000) return floor($time/86400) . 'd ago';
    
    return date('M j', strtotime($datetime));
}

// Debug: Check database connection
if(!$conn) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

// Get the latest completed game result
$latest_result = mysqli_query($conn, "
    SELECT winning_color, completed_at 
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL AND winning_color != ''
    ORDER BY completed_at DESC 
    LIMIT 1
");

$response = [];

if($latest_result && mysqli_num_rows($latest_result) > 0) {
    $result = mysqli_fetch_assoc($latest_result);
    $response['latest_result'] = trim($result['winning_color']);
    $response['completed_at'] = $result['completed_at'];
    $response['time_ago'] = time_elapsed_string($result['completed_at']);
} else {
    $response['latest_result'] = null;
}

// Get all recent results for full update if needed
$all_results = mysqli_query($conn, "
    SELECT winning_color, completed_at 
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL AND winning_color != ''
    ORDER BY completed_at DESC 
    LIMIT 10
");

$all_colors = [];
if($all_results) {
    while($row = mysqli_fetch_assoc($all_results)) {
        $color = trim($row['winning_color']);
        if(!empty($color)) {
            $all_colors[] = [
                'color' => $color,
                'completed_at' => $row['completed_at'],
                'time_ago' => time_elapsed_string($row['completed_at'])
            ];
        }
    }
}

$response['all_results'] = $all_colors;
$response['count'] = count($all_colors);

// Debug info
$response['debug'] = [
    'total_games' => mysqli_num_rows(mysqli_query($conn, "SELECT id FROM games")),
    'completed_games' => mysqli_num_rows(mysqli_query($conn, "SELECT id FROM games WHERE status='completed'")),
    'with_winner' => mysqli_num_rows(mysqli_query($conn, "SELECT id FROM games WHERE status='completed' AND winning_color IS NOT NULL AND winning_color != ''")),
    'timestamp' => date('Y-m-d H:i:s')
];

echo json_encode($response);
?>