<?php
include("../config/db.php");
include("../config/session_user.php");

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

// Language handling
if(isset($_GET['lang'])) {
    $_SESSION['language'] = $_GET['lang'];
}
$lang = $_SESSION['language'] ?? 'en';

// Translations
$t = [
    'en' => [
        'user_id' => 'User ID',
        'welcome' => 'Welcome to Color Prediction Game',
        'tagline' => 'Pick your color and win big!',
        'play' => 'Play Game',
        'recharge' => 'Recharge',
        'withdraw' => 'Withdraw',
        'profile' => 'Profile',
        'notice' => 'Notice',
        'history' => 'Game History',
        'results' => 'Result History',
        'wallet' => 'Wallet History',
        'help' => 'WhatsApp Support',
        'latest' => 'Latest Results',
        'logout' => 'Logout',
        'loading' => 'Loading results...',
        'whatsapp' => 'WhatsApp Support',
        'english' => 'English',
        'hindi' => 'हिंदी',
    ],
    'hi' => [
        'user_id' => 'यूजर आईडी',
        'welcome' => 'रंग भविष्यवाणी गेम में आपका स्वागत है',
        'tagline' => 'अपना रंग चुनें और बड़ा जीतें!',
        'play' => 'गेम खेलें',
        'recharge' => 'रीचार्ज',
        'withdraw' => 'निकालें',
        'profile' => 'प्रोफाइल',
        'notice' => 'सूचना',
        'history' => 'गेम इतिहास',
        'results' => 'परिणाम इतिहास',
        'wallet' => 'वॉलेट इतिहास',
        'help' => 'व्हाट्सएप सपोर्ट',
        'latest' => 'नवीनतम परिणाम',
        'logout' => 'लॉगआउट',
        'loading' => 'परिणाम लोड हो रहे हैं...',
        'whatsapp' => 'व्हाट्सएप सपोर्ट',
        'english' => 'English',
        'hindi' => 'हिंदी',
    ]
];

function trans($key) {
    global $lang, $t;
    return $t[$lang][$key] ?? $key;
}

$user_id = (int)$_SESSION['user_id'];
$user = mysqli_fetch_assoc(mysqli_query($conn,"SELECT wallet FROM users WHERE id=$user_id"));

// Get latest 10 results
$recent_results = mysqli_query($conn, "
    SELECT winning_color, completed_at, id,
           TIMESTAMPDIFF(MINUTE, completed_at, NOW()) as minutes_diff,
           TIMESTAMPDIFF(SECOND, completed_at, NOW()) as seconds_diff
    FROM games 
    WHERE status='completed' 
      AND winning_color IS NOT NULL 
      AND winning_color != ''
    ORDER BY completed_at DESC 
    LIMIT 10
");

$history_results = [];
if($recent_results && mysqli_num_rows($recent_results) > 0){
    while($result = mysqli_fetch_assoc($recent_results)){
        $color = trim($result['winning_color']);
        if(!empty($color)){
            $minutes = (int)$result['minutes_diff'];
            $seconds = (int)$result['seconds_diff'];
            
            if($seconds < 60) {
                $time_ago = 'Just now';
            } else if($minutes < 60) {
                $time_ago = $minutes . 'm ago';
            } else if($minutes < 1440) {
                $hours = floor($minutes / 60);
                $remaining_mins = $minutes % 60;
                if($remaining_mins > 0) {
                    $time_ago = $hours . 'h ' . $remaining_mins . 'm ago';
                } else {
                    $time_ago = $hours . 'h ago';
                }
            } else {
                $days = floor($minutes / 1440);
                $time_ago = $days . 'd ago';
            }
            
            $history_results[] = [
                'id' => $result['id'],
                'color' => $color,
                'time' => $result['completed_at'],
                'time_ago' => $time_ago,
                'minutes_diff' => $minutes,
                'seconds_diff' => $seconds
            ];
        }
    }
}

// Get latest popup result
$latest_popup_result = null;
if(!empty($history_results)) {
    $latest = $history_results[0];
    $time_diff = time() - strtotime($latest['time']);
    if($time_diff <= 300) {
        $latest_popup_result = $latest;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Dashboard - Color Prediction</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
    min-height: 100vh;
    color: #fff;
    overflow-x: hidden;
}

body::before {
    content: '';
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: 
        radial-gradient(circle at 20% 80%, rgba(255, 107, 107, 0.15) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(102, 126, 234, 0.15) 0%, transparent 50%),
        radial-gradient(circle at 40% 40%, rgba(255, 215, 0, 0.1) 0%, transparent 50%);
    z-index: -1;
    animation: backgroundShift 15s ease-in-out infinite;
}

@keyframes backgroundShift {
    0%, 100% { transform: translateX(0) translateY(0); }
    50% { transform: translateX(30px) translateY(-30px); }
}

.topbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 18px 30px;
    background: rgba(15, 52, 96, 0.8);
    backdrop-filter: blur(30px);
    border-bottom: 2px solid rgba(255, 215, 0, 0.2);
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
    position: sticky;
    top: 0;
    z-index: 100;
}

.uid {
    font-size: 15px;
    opacity: 0.9;
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: 500;
    letter-spacing: 0.5px;
}

.lang-switcher {
    display: flex;
    gap: 8px;
    align-items: center;
}

.lang-btn {
    padding: 6px 12px;
    border-radius: 6px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    text-decoration: none;
    font-size: 12px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.lang-btn:hover {
    background: rgba(255, 255, 255, 0.2);
}

.lang-btn.active {
    background: #ffd700;
    color: #000;
    border-color: #ffd700;
}

.balance {
    font-size: 28px;
    font-weight: 800;
    color: #ffd700;
    text-shadow: 0 0 20px rgba(255, 215, 0, 0.4);
    display: flex;
    align-items: center;
    gap: 8px;
}

.welcome-section {
    text-align: center;
    padding: 30px 25px 20px;
    background: linear-gradient(135deg, rgba(255, 215, 0, 0.1), rgba(102, 126, 234, 0.1));
    margin: 20px 25px;
    border-radius: 20px;
    border: 2px solid rgba(255, 215, 0, 0.15);
    backdrop-filter: blur(20px);
}

.welcome-title {
    font-size: 28px;
    font-weight: 800;
    color: #ffd700;
    margin-bottom: 10px;
    letter-spacing: 1px;
    text-shadow: 0 0 20px rgba(255, 215, 0, 0.3);
}

.welcome-text {
    font-size: 16px;
    color: rgba(255, 255, 255, 0.8);
    font-weight: 500;
    letter-spacing: 0.5px;
}

.menu {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(130px, 1fr));
    gap: 16px;
    padding: 30px 25px;
    max-width: 1200px;
    margin: 0 auto;
}

.card {
    background: linear-gradient(135deg, rgba(255, 215, 0, 0.1), rgba(102, 126, 234, 0.1));
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 24px 16px;
    text-align: center;
    cursor: pointer;
    transition: all 0.5s cubic-bezier(0.34, 1.56, 0.64, 1);
    border: 2px solid rgba(255, 215, 0, 0.2);
    position: relative;
    overflow: hidden;
}

.card:hover {
    transform: translateY(-12px) scale(1.05);
    box-shadow: 0 25px 50px rgba(255, 215, 0, 0.2);
    border-color: rgba(255, 215, 0, 0.5);
    background: linear-gradient(135deg, rgba(255, 215, 0, 0.2), rgba(102, 126, 234, 0.2));
}

.card span {
    font-size: 48px;
    display: block;
    margin-bottom: 12px;
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.3));
    transition: transform 0.3s ease;
}

.card:hover span {
    transform: scale(1.15) rotate(5deg);
}

.card p {
    margin: 0;
    font-size: 14px;
    font-weight: 700;
    opacity: 0.95;
    letter-spacing: 0.5px;
    text-transform: uppercase;
    color: #ffd700;
}

.section {
    margin: 30px 25px;
    background: linear-gradient(135deg, rgba(15, 52, 96, 0.6), rgba(22, 33, 62, 0.6));
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 28px;
    border: 2px solid rgba(255, 215, 0, 0.15);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
}

.section h3 {
    margin: 0 0 25px;
    color: #ffd700;
    font-size: 22px;
    font-weight: 800;
    display: flex;
    align-items: center;
    gap: 12px;
    letter-spacing: 1px;
    text-transform: uppercase;
}

.results {
    display: flex;
    gap: 14px;
    flex-wrap: wrap;
    align-items: center;
}

.result-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    padding: 16px;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 16px;
    backdrop-filter: blur(10px);
    border: 2px solid rgba(255, 215, 0, 0.15);
    transition: all 0.4s ease;
    min-width: 95px;
}

.result-item:hover {
    transform: translateY(-5px) scale(1.08);
    box-shadow: 0 15px 35px rgba(255, 215, 0, 0.2);
    border-color: rgba(255, 215, 0, 0.4);
}

.ball {
    width: 56px;
    height: 56px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 800;
    font-size: 13px;
    text-transform: uppercase;
    color: #fff;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.4);
    animation: pulse 2.5s ease-in-out infinite;
    letter-spacing: 0.5px;
}

.time-info {
    font-size: 12px;
    opacity: 0.85;
    text-align: center;
    color: #ffd700;
    font-weight: 600;
    letter-spacing: 0.3px;
}

.red { background: linear-gradient(135deg, #ff6b6b, #ee5a52); box-shadow: 0 6px 20px rgba(255, 107, 107, 0.4); }
.green { background: linear-gradient(135deg, #51cf66, #40c057); box-shadow: 0 6px 20px rgba(81, 207, 102, 0.4); }
.yellow { background: linear-gradient(135deg, #ffd43b, #fab005); color: #000; box-shadow: 0 6px 20px rgba(255, 212, 59, 0.4); }
.blue { background: linear-gradient(135deg, #339af0, #228be6); box-shadow: 0 6px 20px rgba(51, 154, 240, 0.4); }
.purple { background: linear-gradient(135deg, #b197fc, #9775fa); box-shadow: 0 6px 20px rgba(177, 151, 252, 0.4); }
.orange { background: linear-gradient(135deg, #ff922b, #fd7e14); box-shadow: 0 6px 20px rgba(255, 146, 43, 0.4); }
.pink { background: linear-gradient(135deg, #f783ac, #e64980); box-shadow: 0 6px 20px rgba(247, 131, 172, 0.4); }
.cyan { background: linear-gradient(135deg, #3bc9db, #22b8cf); box-shadow: 0 6px 20px rgba(59, 201, 219, 0.4); }

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.08); }
}

.logout {
    display: block;
    margin: 30px 25px;
    padding: 18px;
    text-align: center;
    background: linear-gradient(135deg, #ff6b6b, #ee5a52);
    color: #fff;
    border-radius: 16px;
    text-decoration: none;
    font-weight: 800;
    font-size: 16px;
    transition: all 0.4s ease;
    border: 2px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
    letter-spacing: 0.5px;
    text-transform: uppercase;
    box-shadow: 0 10px 30px rgba(255, 107, 107, 0.3);
}

.logout:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(255, 107, 107, 0.5);
    border-color: rgba(255, 255, 255, 0.4);
}

.no-results {
    text-align: center;
    padding: 40px 20px;
    color: rgba(255, 255, 255, 0.6);
    font-size: 16px;
    font-weight: 500;
}

.loading {
    display: inline-block;
    width: 24px;
    height: 24px;
    border: 3px solid rgba(255, 215, 0, 0.3);
    border-radius: 50%;
    border-top-color: #ffd700;
    animation: spin 1s ease-in-out infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

@media (max-width: 768px) {
    .topbar {
        padding: 12px 15px;
    }
    
    .uid {
        font-size: 13px;
    }
    
    .lang-switcher {
        gap: 6px;
    }
    
    .lang-btn {
        padding: 5px 10px;
        font-size: 11px;
    }
    
    .balance {
        font-size: 20px;
    }
    
    .welcome-section {
        margin: 15px 20px;
        padding: 20px;
    }
    
    .welcome-title {
        font-size: 22px;
    }
    
    .welcome-text {
        font-size: 14px;
    }
    
    .menu {
        grid-template-columns: repeat(2, 1fr);
        gap: 14px;
        padding: 20px;
    }
    
    .card {
        padding: 20px 14px;
    }
    
    .card span {
        font-size: 40px;
    }
    
    .card p {
        font-size: 13px;
    }
    
    .section {
        margin: 20px;
        padding: 20px;
    }
    
    .section h3 {
        font-size: 18px;
    }
    
    .results {
        gap: 12px;
    }
    
    .result-item {
        min-width: 85px;
        padding: 14px;
    }
    
    .ball {
        width: 48px;
        height: 48px;
        font-size: 11px;
    }
}

@media (max-width: 480px) {
    .topbar {
        padding: 12px 15px;
    }
    
    .uid {
        font-size: 13px;
    }
    
    .balance {
        font-size: 20px;
    }
    
    .welcome-section {
        margin: 12px 15px;
        padding: 18px;
    }
    
    .welcome-title {
        font-size: 18px;
        margin-bottom: 8px;
    }
    
    .welcome-text {
        font-size: 13px;
    }
    
    .menu {
        grid-template-columns: 1fr 1fr;
        gap: 12px;
        padding: 15px;
    }
    
    .card {
        padding: 18px 12px;
    }
    
    .card span {
        font-size: 36px;
        margin-bottom: 8px;
    }
    
    .card p {
        font-size: 12px;
    }
    
    .section {
        margin: 15px;
        padding: 18px;
    }
    
    .section h3 {
        font-size: 16px;
        margin-bottom: 18px;
    }
    
    .results {
        gap: 10px;
    }
    
    .result-item {
        min-width: 75px;
        padding: 12px;
    }
    
    .ball {
        width: 44px;
        height: 44px;
        font-size: 10px;
    }
    
    .time-info {
        font-size: 11px;
    }
    
    .logout {
        margin: 20px 15px;
        padding: 16px;
        font-size: 15px;
    }
}
</style>
</head>

<body>

<!-- TOP BAR -->
<div class="topbar">
 <div class="uid">👤 <?= trans('user_id') ?>: <?= $user_id ?></div>
 <div class="lang-switcher">
  <a href="?lang=en" class="lang-btn <?= $lang === 'en' ? 'active' : '' ?>">EN</a>
  <a href="?lang=hi" class="lang-btn <?= $lang === 'hi' ? 'active' : '' ?>">HI</a>
 </div>
 <div class="balance">₹<?= number_format($user['wallet'], 2) ?></div>
</div>

<!-- WELCOME SECTION -->
<div class="welcome-section">
    <h2 class="welcome-title"><?= trans('welcome') ?></h2>
    <p class="welcome-text"><?= trans('tagline') ?></p>
</div>

<!-- MENU -->
<div class="menu">
 <div class="card" onclick="go('game.php')">
  <span>🎮</span>
  <p><?= trans('play') ?></p>
 </div>

 <div class="card" onclick="go('recharge.php')">
  <span>💳</span>
  <p><?= trans('recharge') ?></p>
 </div>

 <div class="card" onclick="go('withdraw.php')">
  <span>🏧</span>
  <p><?= trans('withdraw') ?></p>
 </div>

 <div class="card" onclick="go('profile.php')">
  <span>👤</span>
  <p><?= trans('profile') ?></p>
 </div>

 <div class="card" onclick="go('notice.php')">
  <span>📢</span>
  <p><?= trans('notice') ?></p>
 </div>

 <div class="card" onclick="go('game_history.php')">
  <span>📊</span>
  <p><?= trans('history') ?></p>
 </div>

 <div class="card" onclick="go('result_history.php')">
  <span>🏆</span>
  <p><?= trans('results') ?></p>
 </div>

 <div class="card" onclick="go('wallet_history.php')">
  <span>💼</span>
  <p><?= trans('wallet') ?></p>
 </div>

 <div class="card" onclick="openWhatsAppHelp()">
  <span>💬</span>
  <p><?= trans('help') ?></p>
 </div>
</div>

<!-- LATEST RESULTS -->
<div class="section">
  <h3>🎯 <?= trans('latest') ?></h3>
  
  <div class="results" id="resultsContainer">
    <?php if(!empty($history_results)): ?>
      <?php foreach($history_results as $result): ?>
        <div class="result-item" data-time="<?= $result['time'] ?>" data-id="<?= $result['id'] ?>">
          <div class="ball <?= strtolower($result['color']) ?>">
            <?= strtoupper($result['color']) ?>
          </div>
          <div class="time-info">
            <?= $result['time_ago'] ?>
          </div>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <div class="no-results">
        <div class="loading"></div>
        <p><?= trans('loading') ?></p>
      </div>
    <?php endif; ?>
  </div>
</div>

<!-- LOGOUT -->
<a href="logout.php" class="logout">🚪 <?= trans('logout') ?></a>

<script>
function go(url){
 window.location.href = url;
}

function openWhatsAppHelp() {
    const phoneNumber = "919170254327";
    const message = "Hello! I need help with the app.";
    
    try {
        if (typeof Android !== 'undefined') {
            if (Android.isWhatsAppInstalled && Android.isWhatsAppInstalled()) {
                if (Android.openWhatsAppWithMessage) {
                    Android.openWhatsAppWithMessage(phoneNumber, message);
                } else if (Android.openWhatsAppChat) {
                    Android.openWhatsAppChat(phoneNumber);
                }
                return;
            }
        }
        
        const whatsappUrl = `https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`;
        window.location.href = whatsappUrl;
        
        setTimeout(() => {
            window.open(whatsappUrl, '_blank');
        }, 1000);
        
    } catch (error) {
        console.log('WhatsApp open error:', error);
        const fallbackUrl = `https://wa.me/${phoneNumber}`;
        window.open(fallbackUrl, '_blank');
    }
}

document.addEventListener('DOMContentLoaded', function() {
 console.log('Dashboard loaded');
});
</script>

</body>
</html>
