<?php
include("config/db.php");

echo "<h2>🔄 Updating User Winning Amounts</h2>";

// Add winning_amount column if not exists
$add_column = mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");

if($add_column) {
    echo "<p>✅ Added winning_amount column to users table</p>";
} else {
    echo "<p>ℹ️ winning_amount column already exists</p>";
}

// Get all users
$users = mysqli_query($conn, "SELECT id, name, wallet FROM users");

echo "<h3>Calculating winning amounts for each user:</h3>";

while($user = mysqli_fetch_assoc($users)) {
    $user_id = $user['id'];
    
    // Calculate total winnings from bets
    $winnings = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(win_amount), 0) as total_winnings 
        FROM bets 
        WHERE user_id = $user_id AND status = 'win'
    "));
    
    $total_winnings = $winnings['total_winnings'];
    
    // Update user's winning amount
    mysqli_query($conn, "UPDATE users SET winning_amount = $total_winnings WHERE id = $user_id");
    
    echo "<p>👤 <strong>{$user['name']}</strong> (ID: $user_id) - Winning Amount: ₹" . number_format($total_winnings, 2) . "</p>";
}

echo "<br><h3>✅ All user winning amounts updated successfully!</h3>";

// Show summary
$summary = mysqli_query($conn, "
    SELECT 
        COUNT(*) as total_users,
        SUM(wallet) as total_wallet,
        SUM(winning_amount) as total_winnings
    FROM users
");

$stats = mysqli_fetch_assoc($summary);

echo "<div style='background:#f8f9fa;padding:20px;border-radius:10px;margin:20px 0;'>";
echo "<h3>📊 Summary:</h3>";
echo "<p><strong>Total Users:</strong> " . $stats['total_users'] . "</p>";
echo "<p><strong>Total Wallet Amount:</strong> ₹" . number_format($stats['total_wallet'], 2) . "</p>";
echo "<p><strong>Total Winning Amount:</strong> ₹" . number_format($stats['total_winnings'], 2) . "</p>";
echo "</div>";

echo "<br><a href='user/withdraw.php' target='_blank' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>🏧 Test Withdrawal Page</a>";
?>