<?php
echo "<h2>🧪 Time Function Test</h2>";

// Test the time function
function time_elapsed_string($datetime) {
    $time = time() - strtotime($datetime);
    
    echo "Debug: datetime='$datetime', current_time=" . time() . ", past_time=" . strtotime($datetime) . ", diff=$time seconds<br>";
    
    if ($time < 60) return 'Just now';
    if ($time < 3600) return floor($time/60) . 'm ago';
    if ($time < 86400) return floor($time/3600) . 'h ago';
    if ($time < 2592000) return floor($time/86400) . 'd ago';
    
    return date('M j', strtotime($datetime));
}

echo "<h3>Testing different times:</h3>";

// Test with different times
$test_times = [
    date('Y-m-d H:i:s', time() - 300),    // 5 minutes ago
    date('Y-m-d H:i:s', time() - 900),    // 15 minutes ago
    date('Y-m-d H:i:s', time() - 1800),   // 30 minutes ago
    date('Y-m-d H:i:s', time() - 3600),   // 1 hour ago
    date('Y-m-d H:i:s', time() - 7200),   // 2 hours ago
];

foreach($test_times as $test_time) {
    $result = time_elapsed_string($test_time);
    echo "Time: $test_time → Result: <strong>$result</strong><br>";
}

echo "<hr>";

// Test with database connection
include("config/db.php");

echo "<h3>Database Results Test:</h3>";

$results = mysqli_query($conn, "
    SELECT id, winning_color, completed_at,
           UNIX_TIMESTAMP(completed_at) as completed_timestamp,
           UNIX_TIMESTAMP(NOW()) as current_timestamp
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 5
");

if($results) {
    while($row = mysqli_fetch_assoc($results)) {
        $time_diff = $row['current_timestamp'] - $row['completed_timestamp'];
        $calculated = time_elapsed_string($row['completed_at']);
        
        echo "Game {$row['id']}: {$row['winning_color']}<br>";
        echo "  - Completed: {$row['completed_at']}<br>";
        echo "  - Time diff: $time_diff seconds<br>";
        echo "  - Calculated: <strong>$calculated</strong><br><br>";
    }
} else {
    echo "No results found or query failed: " . mysqli_error($conn);
}
?>