<?php
// Simple test file to check game logic
include("config/db.php");

echo "<h2>🧪 Game Logic Test</h2>";

// Test colors array
$colors = ['red','green','yellow','blue','purple','orange','pink','cyan'];
echo "<p><strong>Available Colors:</strong> " . implode(', ', $colors) . "</p>";

// Test random winner selection
echo "<h3>Random Winner Tests:</h3>";
for($i = 1; $i <= 10; $i++){
    $winner = $colors[array_rand($colors)];
    echo "<span style='padding:5px 10px; margin:2px; background:#333; color:white; border-radius:5px;'>$winner</span> ";
}

// Test database connection
echo "<h3>Database Test:</h3>";
$test_query = mysqli_query($conn, "SHOW TABLES");
if($test_query){
    echo "<p>✅ Database connection successful</p>";
    echo "<p><strong>Tables:</strong></p><ul>";
    while($table = mysqli_fetch_array($test_query)){
        echo "<li>" . $table[0] . "</li>";
    }
    echo "</ul>";
} else {
    echo "<p>❌ Database connection failed</p>";
}

// Check if required tables exist
$required_tables = ['users', 'games', 'bets'];
foreach($required_tables as $table){
    $check = mysqli_query($conn, "SHOW TABLES LIKE '$table'");
    if(mysqli_num_rows($check) > 0){
        echo "<p>✅ Table '$table' exists</p>";
        
        // Show table structure
        $structure = mysqli_query($conn, "DESCRIBE $table");
        echo "<details><summary>View $table structure</summary><ul>";
        while($col = mysqli_fetch_assoc($structure)){
            echo "<li>{$col['Field']} - {$col['Type']}</li>";
        }
        echo "</ul></details>";
    } else {
        echo "<p>❌ Table '$table' missing</p>";
    }
}

echo "<hr>";
echo "<p><a href='user/dashboard.php'>🎮 Go to Game</a></p>";
?>