<?php
include("config/db.php");

echo "<h2>API Test</h2>";

// Test the API directly
echo "<h3>Direct API Call:</h3>";
$url = "http://localhost/user/get_latest_results.php";
$response = file_get_contents($url);
echo "<pre>$response</pre>";

// Test database directly
echo "<h3>Direct Database Query:</h3>";
$results = mysqli_query($conn, "
    SELECT winning_color, completed_at 
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL AND winning_color != ''
    ORDER BY completed_at DESC 
    LIMIT 10
");

if($results) {
    echo "Found " . mysqli_num_rows($results) . " results:<br>";
    while($row = mysqli_fetch_assoc($results)) {
        echo "Color: '" . $row['winning_color'] . "' (type: " . gettype($row['winning_color']) . "), Time: " . $row['completed_at'] . "<br>";
    }
} else {
    echo "Query failed: " . mysqli_error($conn);
}

// Check if we have any games at all
echo "<h3>Database Status:</h3>";
$total = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM games"));
echo "Total games: " . $total['count'] . "<br>";

$completed = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM games WHERE status='completed'"));
echo "Completed games: " . $completed['count'] . "<br>";

$with_winner = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM games WHERE status='completed' AND winning_color IS NOT NULL AND winning_color != ''"));
echo "Games with winner: " . $with_winner['count'] . "<br>";
?>