<?php
include("config/db.php");

if(!isset($_SESSION['user_id'])){
    die("Please login first");
}

$user_id = $_SESSION['user_id'];

echo "<h2>🎯 Simple Winning Test</h2>";

// Manual bet placement and result test
if(isset($_POST['test_bet'])){
    $color = $_POST['color'];
    $amount = (int)$_POST['amount'];
    $force_winner = $_POST['force_winner'];
    
    echo "<h3>Testing Bet: $color - ₹$amount</h3>";
    
    // Get or create running game
    $game = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM games WHERE status='running' ORDER BY id DESC LIMIT 1"));
    if(!$game){
        mysqli_query($conn, "INSERT INTO games (status, created_at) VALUES ('running', NOW())");
        $game_id = mysqli_insert_id($conn);
        echo "<p>✅ Created new game #$game_id</p>";
    } else {
        $game_id = $game['id'];
        echo "<p>✅ Using existing game #$game_id</p>";
    }
    
    // Get user wallet
    $user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT wallet FROM users WHERE id=$user_id"));
    echo "<p><strong>Current Wallet:</strong> ₹{$user['wallet']}</p>";
    
    if($user['wallet'] >= $amount){
        // Deduct bet amount
        mysqli_query($conn, "UPDATE users SET wallet = wallet - $amount WHERE id = $user_id");
        
        // Place bet
        mysqli_query($conn, "INSERT INTO bets (user_id, game_id, color, amount, status, win_amount, created_at) VALUES ($user_id, $game_id, '$color', $amount, 'pending', 0, NOW())");
        $bet_id = mysqli_insert_id($conn);
        
        echo "<p>✅ Bet placed - ID: $bet_id</p>";
        
        // Process result
        $winner = $force_winner;
        echo "<p><strong>Winner Color:</strong> $winner</p>";
        
        $winAmount = 0;
        if(strtolower($color) === strtolower($winner)){
            // WIN
            $winPayout = $amount * 2;
            $winAmount = $winPayout;
            
            // Add to wallet
            mysqli_query($conn, "UPDATE users SET wallet = wallet + $winPayout WHERE id = $user_id");
            
            // Update bet
            mysqli_query($conn, "UPDATE bets SET status='win', win_amount=$winPayout WHERE id=$bet_id");
            
            echo "<p>🎉 <strong>YOU WON!</strong> ₹$winPayout</p>";
        } else {
            // LOSS
            mysqli_query($conn, "UPDATE bets SET status='loss', win_amount=0 WHERE id=$bet_id");
            echo "<p>😔 <strong>YOU LOST!</strong> ₹0</p>";
        }
        
        // Get updated wallet
        $updated_user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT wallet FROM users WHERE id=$user_id"));
        echo "<p><strong>Updated Wallet:</strong> ₹{$updated_user['wallet']}</p>";
        
        // Mark game as completed
        mysqli_query($conn, "UPDATE games SET status='completed', winning_color='$winner', completed_at=NOW() WHERE id=$game_id");
        
        echo "<hr>";
        echo "<h4>📊 Summary:</h4>";
        echo "<p>Bet Color: <span style='background:$color;color:white;padding:2px 8px'>$color</span></p>";
        echo "<p>Winner: <span style='background:$winner;color:white;padding:2px 8px'>$winner</span></p>";
        echo "<p>Bet Amount: ₹$amount</p>";
        echo "<p>Win Amount: ₹$winAmount</p>";
        echo "<p>Result: " . ($winAmount > 0 ? "WIN" : "LOSS") . "</p>";
        
    } else {
        echo "<p>❌ Insufficient balance</p>";
    }
}
?>

<form method="post">
    <h3>🧪 Test Bet</h3>
    
    <p><label>Select Color:</label></p>
    <select name="color" required>
        <option value="red">Red</option>
        <option value="green">Green</option>
        <option value="blue">Blue</option>
        <option value="yellow">Yellow</option>
        <option value="purple">Purple</option>
        <option value="orange">Orange</option>
        <option value="pink">Pink</option>
        <option value="cyan">Cyan</option>
    </select>
    
    <p><label>Bet Amount:</label></p>
    <select name="amount" required>
        <option value="10">₹10</option>
        <option value="50">₹50</option>
        <option value="100">₹100</option>
    </select>
    
    <p><label>Force Winner (for testing):</label></p>
    <select name="force_winner" required>
        <option value="red">Red</option>
        <option value="green">Green</option>
        <option value="blue">Blue</option>
        <option value="yellow">Yellow</option>
        <option value="purple">Purple</option>
        <option value="orange">Orange</option>
        <option value="pink">Pink</option>
        <option value="cyan">Cyan</option>
    </select>
    
    <p><button type="submit" name="test_bet">🎯 Test Bet</button></p>
</form>

<hr>
<p><a href="user/dashboard.php">🎮 Back to Game</a></p>
<p><a href="debug_bets.php">🔍 Debug Bets</a></p>