<?php
include("config/db.php");

if(!isset($_SESSION['user_id'])){
    die("Please login first");
}

$user_id = $_SESSION['user_id'];

// Real-time debugging
if(isset($_GET['action']) && $_GET['action'] == 'check_bets'){
    header('Content-Type: application/json');
    
    $game_id = (int)($_GET['game_id'] ?? 0);
    if(!$game_id){
        echo json_encode(['error' => 'No game ID']);
        exit;
    }
    
    // Get all bets for this game and user
    $bets = mysqli_query($conn, "SELECT * FROM bets WHERE game_id=$game_id AND user_id=$user_id ORDER BY created_at DESC");
    $bet_data = [];
    
    while($bet = mysqli_fetch_assoc($bets)){
        $bet_data[] = [
            'id' => $bet['id'],
            'color' => $bet['color'],
            'amount' => $bet['amount'],
            'status' => $bet['status'],
            'win_amount' => $bet['win_amount'],
            'created_at' => $bet['created_at']
        ];
    }
    
    echo json_encode([
        'game_id' => $game_id,
        'user_id' => $user_id,
        'bets' => $bet_data,
        'bet_count' => count($bet_data)
    ]);
    exit;
}

// Get current game
$current_game = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM games WHERE status='running' ORDER BY id DESC LIMIT 1"));
?>

<!DOCTYPE html>
<html>
<head>
    <title>Live Debug</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        .debug-box { background: #f0f0f0; padding: 15px; margin: 10px 0; border-radius: 5px; }
        button { padding: 10px 15px; margin: 5px; background: #007bff; color: white; border: none; border-radius: 3px; cursor: pointer; }
        .bet-item { background: white; padding: 10px; margin: 5px 0; border-left: 4px solid #007bff; }
    </style>
</head>
<body>

<h2>🔴 Live Debug - User <?= $user_id ?></h2>

<?php if($current_game): ?>
<div class="debug-box">
    <h3>Current Game: #<?= $current_game['id'] ?></h3>
    <p>Status: <?= $current_game['status'] ?></p>
    <p>Created: <?= $current_game['created_at'] ?></p>
    
    <button onclick="checkBets(<?= $current_game['id'] ?>)">Check My Bets</button>
    <button onclick="simulateResult('<?= $current_game['id'] ?>', 'purple')">Test Purple Win</button>
    <button onclick="simulateResult('<?= $current_game['id'] ?>', 'red')">Test Red Win</button>
</div>

<div id="betResults" class="debug-box" style="display:none;">
    <h4>Bet Results:</h4>
    <div id="betList"></div>
</div>

<div id="simulationResults" class="debug-box" style="display:none;">
    <h4>Simulation Results:</h4>
    <div id="simList"></div>
</div>

<script>
function checkBets(gameId) {
    fetch(`live_debug.php?action=check_bets&game_id=${gameId}`)
    .then(r => r.json())
    .then(d => {
        document.getElementById('betResults').style.display = 'block';
        let html = `<p><strong>Game:</strong> #${d.game_id} | <strong>Bets:</strong> ${d.bet_count}</p>`;
        
        d.bets.forEach(bet => {
            html += `<div class="bet-item">
                <strong>Color:</strong> ${bet.color} | 
                <strong>Amount:</strong> ₹${bet.amount} | 
                <strong>Status:</strong> ${bet.status} | 
                <strong>Win:</strong> ₹${bet.win_amount}
            </div>`;
        });
        
        document.getElementById('betList').innerHTML = html;
    });
}

function simulateResult(gameId, winner) {
    // First check current bets
    fetch(`live_debug.php?action=check_bets&game_id=${gameId}`)
    .then(r => r.json())
    .then(d => {
        let totalBet = 0;
        let totalWin = 0;
        let results = [];
        
        d.bets.forEach(bet => {
            if(bet.status === 'pending') {
                totalBet += parseInt(bet.amount);
                if(bet.color.toLowerCase() === winner.toLowerCase()) {
                    let win = parseInt(bet.amount) * 2;
                    totalWin += win;
                    results.push(`✅ ${bet.color} ₹${bet.amount} → WIN ₹${win}`);
                } else {
                    results.push(`❌ ${bet.color} ₹${bet.amount} → LOSS`);
                }
            }
        });
        
        document.getElementById('simulationResults').style.display = 'block';
        document.getElementById('simList').innerHTML = `
            <p><strong>Winner:</strong> ${winner.toUpperCase()}</p>
            <p><strong>Total Bet:</strong> ₹${totalBet}</p>
            <p><strong>Total Win:</strong> ₹${totalWin}</p>
            <p><strong>Net:</strong> ₹${totalWin - totalBet}</p>
            <div>${results.join('<br>')}</div>
        `;
    });
}
</script>

<?php else: ?>
<div class="debug-box">
    <h3>❌ No Running Game Found</h3>
    <p>Please start a new game from dashboard</p>
</div>
<?php endif; ?>

<hr>
<p><a href="user/dashboard.php">🎮 Back to Game</a></p>

</body>
</html>