<?php
include("config/db.php");

echo "<h2>🔄 Initializing Separate Amount Tracking</h2>";

// Add columns if not exist
$add_recharge = mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");
$add_winning = mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");

if($add_recharge) {
    echo "<p>✅ Added recharge_amount column to users table</p>";
} else {
    echo "<p>ℹ️ recharge_amount column already exists</p>";
}

if($add_winning) {
    echo "<p>✅ Added winning_amount column to users table</p>";
} else {
    echo "<p>ℹ️ winning_amount column already exists</p>";
}

// Get all users
$users = mysqli_query($conn, "SELECT id, name, wallet FROM users");

echo "<h3>Initializing amounts for each user:</h3>";

while($user = mysqli_fetch_assoc($users)) {
    $user_id = $user['id'];
    
    // Calculate total winnings from bets
    $winnings = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(win_amount), 0) as total_winnings 
        FROM bets 
        WHERE user_id = $user_id AND status = 'win'
    "));
    
    $total_winnings = $winnings['total_winnings'];
    $total_wallet = $user['wallet'];
    
    // Calculate recharge amount (wallet - winnings)
    $recharge_amount = max(0, $total_wallet - $total_winnings);
    
    // Update user's separate amounts
    mysqli_query($conn, "
        UPDATE users 
        SET recharge_amount = $recharge_amount, 
            winning_amount = $total_winnings 
        WHERE id = $user_id
    ");
    
    echo "<div style='background:#f8f9fa;padding:15px;margin:10px 0;border-radius:8px;border-left:4px solid #007bff;'>";
    echo "<p><strong>👤 {$user['name']}</strong> (ID: $user_id)</p>";
    echo "<p>💰 Total Wallet: ₹" . number_format($total_wallet, 2) . "</p>";
    echo "<p>🎯 Winning Amount: ₹" . number_format($total_winnings, 2) . "</p>";
    echo "<p>💳 Recharge Amount: ₹" . number_format($recharge_amount, 2) . "</p>";
    echo "</div>";
}

echo "<br><h3>✅ All user amounts initialized successfully!</h3>";

// Show summary
$summary = mysqli_query($conn, "
    SELECT 
        COUNT(*) as total_users,
        SUM(wallet) as total_wallet,
        SUM(winning_amount) as total_winnings,
        SUM(recharge_amount) as total_recharge
    FROM users
");

$stats = mysqli_fetch_assoc($summary);

echo "<div style='background:#e8f5e8;padding:20px;border-radius:10px;margin:20px 0;border:2px solid #28a745;'>";
echo "<h3>📊 Summary:</h3>";
echo "<p><strong>Total Users:</strong> " . $stats['total_users'] . "</p>";
echo "<p><strong>Total Wallet Amount:</strong> ₹" . number_format($stats['total_wallet'], 2) . "</p>";
echo "<p><strong>Total Winning Amount:</strong> ₹" . number_format($stats['total_winnings'], 2) . "</p>";
echo "<p><strong>Total Recharge Amount:</strong> ₹" . number_format($stats['total_recharge'], 2) . "</p>";
echo "<p><strong>Verification:</strong> " . ($stats['total_wallet'] == ($stats['total_winnings'] + $stats['total_recharge']) ? "✅ Balanced" : "❌ Imbalanced") . "</p>";
echo "</div>";

echo "<div style='background:#fff3cd;padding:15px;border-radius:8px;border:1px solid #ffeaa7;margin:20px 0;'>";
echo "<h4>🎯 Smart Deduction System Active:</h4>";
echo "<ul>";
echo "<li>✅ Recharge money will be used first for betting</li>";
echo "<li>✅ Winning money will be used only after recharge money is exhausted</li>";
echo "<li>✅ Only winning money can be withdrawn</li>";
echo "<li>✅ Minimum ₹100 winning amount required for withdrawal</li>";
echo "</ul>";
echo "</div>";

echo "<br><a href='user/game.php' target='_blank' style='background:#007bff;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;margin-right:10px;'>🎮 Test Game</a>";
echo "<a href='user/withdraw.php' target='_blank' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>🏧 Test Withdrawal</a>";
?>