<?php
include("config/db.php");

echo "<h2>🔧 Fixing Withdrawal Flow</h2>";

// Add columns if not exist
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");

echo "<h3>Current Withdrawal Flow:</h3>";
echo "<div style='background:#d1ecf1;padding:15px;border-radius:8px;border:1px solid #bee5eb;margin:20px 0;'>";
echo "<p><strong>✅ Correct Flow:</strong></p>";
echo "<ol>";
echo "<li>User submits withdrawal → Money deducted immediately (shows as pending)</li>";
echo "<li>Admin approves → Money stays deducted (withdrawal completed)</li>";
echo "<li>Admin rejects → Money returned to user</li>";
echo "</ol>";
echo "</div>";

// Check for pending withdrawals that might need adjustment
$pending_withdrawals = mysqli_query($conn, "
    SELECT w.*, u.name, u.wallet, u.winning_amount, u.recharge_amount
    FROM withdrawal_requests w
    JOIN users u ON u.id = w.user_id
    WHERE w.status = 'pending'
    ORDER BY w.created_at DESC
");

echo "<h3>Current Pending Withdrawals:</h3>";

if(mysqli_num_rows($pending_withdrawals) > 0) {
    while($withdrawal = mysqli_fetch_assoc($pending_withdrawals)) {
        echo "<div style='background:#fff3cd;padding:15px;margin:10px 0;border-radius:8px;border-left:4px solid #ffc107;'>";
        echo "<h4>🏧 Withdrawal ID: {$withdrawal['id']}</h4>";
        echo "<p><strong>User:</strong> {$withdrawal['name']}</p>";
        echo "<p><strong>Amount:</strong> ₹" . number_format($withdrawal['amount'], 2) . "</p>";
        echo "<p><strong>Date:</strong> " . date('M j, Y H:i', strtotime($withdrawal['created_at'])) . "</p>";
        echo "<p><strong>Current User Balance:</strong></p>";
        echo "<p>💰 Wallet: ₹" . number_format($withdrawal['wallet'], 2) . "</p>";
        echo "<p>🎯 Winning: ₹" . number_format($withdrawal['winning_amount'], 2) . "</p>";
        echo "<p>💳 Recharge: ₹" . number_format($withdrawal['recharge_amount'], 2) . "</p>";
        echo "<p style='color:#007bff;'><strong>Status:</strong> Pending (Money should already be deducted)</p>";
        echo "</div>";
    }
} else {
    echo "<p>No pending withdrawals found.</p>";
}

// Fix user balances to ensure consistency
echo "<h3>Ensuring Balance Consistency:</h3>";

$users = mysqli_query($conn, "SELECT * FROM users");

while($user = mysqli_fetch_assoc($users)) {
    $user_id = $user['id'];
    
    // Calculate what the balances should be based on transactions
    
    // 1. Total winnings from bets
    $winnings = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(win_amount), 0) as total_winnings 
        FROM bets 
        WHERE user_id = $user_id AND status = 'win'
    "));
    $total_winnings = $winnings['total_winnings'];
    
    // 2. Total approved recharges
    $recharges = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(amount), 0) as total_recharges 
        FROM recharge_requests 
        WHERE user_id = $user_id AND status = 'approved'
    "));
    $total_recharges = $recharges['total_recharges'];
    
    // 3. Total pending + approved withdrawals (both should be deducted)
    $withdrawals = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(amount), 0) as total_withdrawals 
        FROM withdrawal_requests 
        WHERE user_id = $user_id AND status IN ('pending', 'approved')
    "));
    $total_withdrawals = $withdrawals['total_withdrawals'];
    
    // 4. Calculate correct balances
    $correct_winning_amount = max(0, $total_winnings - $total_withdrawals);
    $correct_recharge_amount = $total_recharges;
    $correct_wallet = $correct_recharge_amount + $correct_winning_amount;
    
    // Check if update is needed
    $needs_update = (
        abs($user['wallet'] - $correct_wallet) > 0.01 ||
        abs($user['winning_amount'] - $correct_winning_amount) > 0.01 ||
        abs($user['recharge_amount'] - $correct_recharge_amount) > 0.01
    );
    
    if($needs_update) {
        echo "<div style='background:#f8d7da;padding:15px;margin:10px 0;border-radius:8px;border-left:4px solid #dc3545;'>";
        echo "<h4>👤 {$user['name']} (ID: $user_id) - NEEDS FIX</h4>";
        
        echo "<p><strong>Current Values:</strong></p>";
        echo "<p>💰 Wallet: ₹" . number_format($user['wallet'], 2) . "</p>";
        echo "<p>🎯 Winning: ₹" . number_format($user['winning_amount'], 2) . "</p>";
        echo "<p>💳 Recharge: ₹" . number_format($user['recharge_amount'], 2) . "</p>";
        
        echo "<p><strong>Should Be (including pending withdrawals):</strong></p>";
        echo "<p>💰 Wallet: ₹" . number_format($correct_wallet, 2) . "</p>";
        echo "<p>🎯 Winning: ₹" . number_format($correct_winning_amount, 2) . "</p>";
        echo "<p>💳 Recharge: ₹" . number_format($correct_recharge_amount, 2) . "</p>";
        
        // Update with correct values
        mysqli_query($conn, "
            UPDATE users 
            SET wallet = $correct_wallet,
                winning_amount = $correct_winning_amount,
                recharge_amount = $correct_recharge_amount
            WHERE id = $user_id
        ");
        
        echo "<p style='color:#28a745;'><strong>✅ FIXED!</strong></p>";
        echo "</div>";
    } else {
        echo "<p>✅ {$user['name']} - Already correct</p>";
    }
}

echo "<br><h3>✅ Withdrawal flow has been fixed!</h3>";

echo "<div style='background:#d4edda;padding:15px;border-radius:8px;border:1px solid #c3e6cb;margin:20px 0;'>";
echo "<h4>📋 Summary of Changes:</h4>";
echo "<ul>";
echo "<li>✅ User withdrawal requests now deduct money immediately</li>";
echo "<li>✅ Admin approval keeps money deducted (no double deduction)</li>";
echo "<li>✅ Admin rejection returns money to user</li>";
echo "<li>✅ All balances recalculated to include pending withdrawals</li>";
echo "</ul>";
echo "</div>";

echo "<br><a href='user/withdraw.php' target='_blank' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;margin-right:10px;'>🏧 Test Withdrawal</a>";
echo "<a href='admin/withdrawal_requests.php' target='_blank' style='background:#007bff;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>👨‍💼 Admin Panel</a>";
?>