<?php
include("config/db.php");

echo "<h2>Ensuring Test Data Exists</h2>";

// Check current completed games
$check = mysqli_query($conn, "SELECT COUNT(*) as count FROM games WHERE status='completed' AND winning_color IS NOT NULL");
$current_count = mysqli_fetch_assoc($check)['count'];

echo "<p>Current completed games with winners: $current_count</p>";

if($current_count < 10) {
    echo "<p>Adding test data to reach 10 results...</p>";
    
    $colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];
    $needed = 10 - $current_count;
    
    for($i = 0; $i < $needed; $i++) {
        $winner = $colors[array_rand($colors)];
        $minutes_ago = ($i + 1) * 15; // 15, 30, 45... minutes ago
        
        $result = mysqli_query($conn, "
            INSERT INTO games (status, winning_color, created_at, completed_at) 
            VALUES (
                'completed', 
                '$winner', 
                NOW() - INTERVAL $minutes_ago MINUTE, 
                NOW() - INTERVAL " . ($minutes_ago - 5) . " MINUTE
            )
        ");
        
        if($result) {
            echo "✅ Added game: $winner (" . $minutes_ago . "m ago)<br>";
        } else {
            echo "❌ Failed to add game: " . mysqli_error($conn) . "<br>";
        }
    }
}

echo "<h3>Current Results:</h3>";
$results = mysqli_query($conn, "
    SELECT id, winning_color, completed_at 
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 10
");

$count = 0;
while($row = mysqli_fetch_assoc($results)) {
    $count++;
    $time_ago = floor((time() - strtotime($row['completed_at'])) / 60);
    echo "$count. Game {$row['id']}: {$row['winning_color']} ({$time_ago}m ago)<br>";
}

echo "<br><a href='user/dashboard.php'>Go to Dashboard</a>";
?>