<?php
include("config/db.php");

echo "<h2>🕐 Timer Debug</h2>";

// Get current running game
$running_game = mysqli_query($conn, "
    SELECT id, created_at, UNIX_TIMESTAMP(created_at) as created_timestamp
    FROM games 
    WHERE status='running' 
    ORDER BY id DESC 
    LIMIT 1
");

if($running_game && mysqli_num_rows($running_game) > 0) {
    $game = mysqli_fetch_assoc($running_game);
    $game_id = $game['id'];
    $created_time = $game['created_timestamp'];
    $current_time = time();
    $elapsed_seconds = $current_time - $created_time;
    $remaining_seconds = max(0, 30 - $elapsed_seconds);
    
    echo "<h3>Current Game Status:</h3>";
    echo "<p><strong>Game ID:</strong> $game_id</p>";
    echo "<p><strong>Created At:</strong> " . $game['created_at'] . "</p>";
    echo "<p><strong>Created Timestamp:</strong> $created_time</p>";
    echo "<p><strong>Current Timestamp:</strong> $current_time</p>";
    echo "<p><strong>Elapsed Seconds:</strong> $elapsed_seconds</p>";
    echo "<p><strong>Remaining Seconds:</strong> $remaining_seconds</p>";
    
    if($elapsed_seconds >= 30) {
        echo "<p style='color:red;'><strong>⚠️ Game should be completed!</strong></p>";
    } else {
        echo "<p style='color:green;'><strong>✅ Game is running normally</strong></p>";
    }
    
} else {
    echo "<p>❌ No running game found</p>";
}

echo "<hr>";
echo "<h3>Actions:</h3>";
echo "<p><a href='game_cron.php' target='_blank'>🔄 Test Game Cron</a></p>";
echo "<p><a href='user/game.php' target='_blank'>🎮 Open Game</a></p>";
echo "<p><a href='game_manager.php' target='_blank'>🎛️ Open Game Manager</a></p>";

// Auto refresh every 5 seconds
echo "<script>setTimeout(() => window.location.reload(), 5000);</script>";
?>