<?php
include("config/db.php");

echo "<h2>🕐 Creating Results with Proper Timing</h2>";

// Clear existing completed games first
mysqli_query($conn, "DELETE FROM games WHERE status='completed'");
echo "<p>✅ Cleared existing completed games</p>";

$colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];

echo "<h3>Creating 10 results with varied timing:</h3>";

// Create results with specific time intervals
$time_intervals = [
    5,    // 5 minutes ago
    12,   // 12 minutes ago  
    25,   // 25 minutes ago
    38,   // 38 minutes ago
    55,   // 55 minutes ago
    72,   // 1h 12m ago
    95,   // 1h 35m ago
    125,  // 2h 5m ago
    180,  // 3h ago
    240   // 4h ago
];

for($i = 0; $i < 10; $i++) {
    $winner = $colors[array_rand($colors)];
    $minutes_ago = $time_intervals[$i];
    
    $result = mysqli_query($conn, "
        INSERT INTO games (status, winning_color, created_at, completed_at) 
        VALUES (
            'completed', 
            '$winner', 
            NOW() - INTERVAL $minutes_ago MINUTE, 
            NOW() - INTERVAL $minutes_ago MINUTE
        )
    ");
    
    if($result) {
        $game_id = mysqli_insert_id($conn);
        
        // Calculate display time
        if($minutes_ago < 60) {
            $display_time = $minutes_ago . "m ago";
        } else {
            $hours = floor($minutes_ago / 60);
            $remaining_mins = $minutes_ago % 60;
            if($remaining_mins > 0) {
                $display_time = $hours . "h " . $remaining_mins . "m ago";
            } else {
                $display_time = $hours . "h ago";
            }
        }
        
        echo "✅ Game $game_id: <strong>$winner</strong> - $display_time<br>";
    } else {
        echo "❌ Failed to create game with $winner<br>";
    }
}

echo "<h3>Verification - Current Results:</h3>";

// Verify the results
$verify = mysqli_query($conn, "
    SELECT id, winning_color, completed_at,
           TIMESTAMPDIFF(MINUTE, completed_at, NOW()) as minutes_ago
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 10
");

function format_time_display($minutes) {
    if($minutes < 1) return 'Just now';
    if($minutes < 60) return $minutes . 'm ago';
    
    $hours = floor($minutes / 60);
    $remaining_mins = $minutes % 60;
    
    if($remaining_mins > 0) {
        return $hours . 'h ' . $remaining_mins . 'm ago';
    } else {
        return $hours . 'h ago';
    }
}

while($row = mysqli_fetch_assoc($verify)) {
    $time_display = format_time_display($row['minutes_ago']);
    echo "🎯 <strong>{$row['winning_color']}</strong> - {$time_display}<br>";
}

echo "<br><strong>✅ Results created successfully!</strong>";
echo "<br><br><a href='user/dashboard.php' target='_blank'>📊 View Dashboard</a>";
echo "<br><a href='user/get_latest_results.php' target='_blank'>🔗 Test API</a>";
?>