<?php
// ✅ ADMIN SESSION - 15 MINUTES TIMEOUT
ini_set('session.gc_maxlifetime', 900); // 15 minutes
ini_set('session.cookie_lifetime', 0); // browser close = logout

session_name("ADMINSESSID"); // Separate cookie for admin
session_set_cookie_params([
    'lifetime' => 0, // Session cookie (expires on browser close)
    'path' => '/color_prediction/admin', // ✅ CORRECT PATH
    'secure' => false, // Set to true if using HTTPS
    'httponly' => true, // Prevent JavaScript access
    'samesite' => 'Strict' // CSRF protection
]);

session_start();

/* ⏰ Auto logout after 15 minutes of inactivity */
if(isset($_SESSION['LAST_ACTIVITY'])){
    $inactive_time = time() - $_SESSION['LAST_ACTIVITY'];
    
    if($inactive_time > 900){ // 900 seconds = 15 minutes
        session_unset();
        session_destroy();
        header("Location: login.php?timeout=1");
        exit;
    }
}

// Update last activity time
$_SESSION['LAST_ACTIVITY'] = time();

/* 🔒 Cache control - prevent back button after logout */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
?>
