<?php
include("config/db.php");

if(!isset($_SESSION['user_id'])){
    die("Please login first");
}

$user_id = $_SESSION['user_id'];

echo "<h2>🔍 Game State Check</h2>";

// Check current running game
$running_game = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM games WHERE status='running' ORDER BY id DESC LIMIT 1"));

if($running_game){
    echo "<h3>✅ Current Running Game: #{$running_game['id']}</h3>";
    echo "<p>Created: {$running_game['created_at']}</p>";
    
    // Check user's pending bets
    $pending_bets = mysqli_query($conn, "SELECT * FROM bets WHERE game_id={$running_game['id']} AND user_id=$user_id AND status='pending'");
    $bet_count = mysqli_num_rows($pending_bets);
    
    echo "<h4>Your Pending Bets: $bet_count</h4>";
    
    if($bet_count > 0){
        echo "<table border='1' style='border-collapse:collapse'>";
        echo "<tr><th>Color</th><th>Amount</th><th>Status</th></tr>";
        
        while($bet = mysqli_fetch_assoc($pending_bets)){
            echo "<tr>";
            echo "<td style='background:{$bet['color']};color:white;padding:5px'>{$bet['color']}</td>";
            echo "<td>₹{$bet['amount']}</td>";
            echo "<td>{$bet['status']}</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Manual result test
        echo "<h4>🎲 Manual Result Test</h4>";
        echo "<form method='post'>";
        echo "<input type='hidden' name='game_id' value='{$running_game['id']}'>";
        echo "<select name='winner_color'>";
        $colors = ['red','green','yellow','blue','purple','orange','pink','cyan'];
        foreach($colors as $color){
            echo "<option value='$color'>$color</option>";
        }
        echo "</select>";
        echo "<button type='submit' name='manual_result'>Generate Result</button>";
        echo "</form>";
    } else {
        echo "<p>❌ No pending bets found</p>";
    }
} else {
    echo "<h3>❌ No running game found</h3>";
    echo "<p>Creating new game...</p>";
    mysqli_query($conn, "INSERT INTO games (status, created_at) VALUES ('running', NOW())");
    echo "<p>✅ New game created. <a href=''>Refresh</a></p>";
}

// Manual result processing
if(isset($_POST['manual_result'])){
    $game_id = (int)$_POST['game_id'];
    $winner = $_POST['winner_color'];
    
    echo "<hr><h3>🎯 Processing Manual Result</h3>";
    echo "<p><strong>Game ID:</strong> $game_id</p>";
    echo "<p><strong>Winner Color:</strong> $winner</p>";
    
    // Get user's bets
    $bets = mysqli_query($conn, "SELECT * FROM bets WHERE game_id=$game_id AND user_id=$user_id AND status='pending'");
    $winAmount = 0;
    $totalBet = 0;
    
    echo "<h4>Processing Bets:</h4>";
    while($bet = mysqli_fetch_assoc($bets)){
        $totalBet += $bet['amount'];
        $isWin = (strtolower($bet['color']) === strtolower($winner));
        
        if($isWin){
            $win = $bet['amount'] * 2;
            $winAmount += $win;
            mysqli_query($conn, "UPDATE users SET wallet=wallet+$win WHERE id=$user_id");
            mysqli_query($conn, "UPDATE bets SET status='win', win_amount=$win WHERE id={$bet['id']}");
            echo "<p>✅ {$bet['color']} ₹{$bet['amount']} → WIN ₹$win</p>";
        } else {
            mysqli_query($conn, "UPDATE bets SET status='loss', win_amount=0 WHERE id={$bet['id']}");
            echo "<p>❌ {$bet['color']} ₹{$bet['amount']} → LOSS</p>";
        }
    }
    
    // Complete game
    mysqli_query($conn, "UPDATE games SET status='completed', winning_color='$winner', completed_at=NOW() WHERE id=$game_id");
    
    // Create new game
    mysqli_query($conn, "INSERT INTO games (status, created_at) VALUES ('running', NOW())");
    
    echo "<h4>📊 Result Summary:</h4>";
    echo "<p><strong>Total Bet:</strong> ₹$totalBet</p>";
    echo "<p><strong>Total Win:</strong> ₹$winAmount</p>";
    echo "<p><strong>Net Result:</strong> ₹" . ($winAmount - $totalBet) . "</p>";
    
    // Get updated wallet
    $user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT wallet FROM users WHERE id=$user_id"));
    echo "<p><strong>Updated Wallet:</strong> ₹{$user['wallet']}</p>";
}

echo "<hr>";
echo "<p><a href='user/dashboard.php'>🎮 Back to Game</a></p>";
echo "<p><a href='debug_bets.php'>🔍 Debug Bets</a></p>";
?>