<?php
include("config/db.php");

echo "<h2>🔍 Current Results Check</h2>";

// Check current completed games
$results = mysqli_query($conn, "
    SELECT id, winning_color, completed_at,
           TIMESTAMPDIFF(MINUTE, completed_at, NOW()) as minutes_ago,
           TIMESTAMPDIFF(SECOND, completed_at, NOW()) as seconds_ago
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 10
");

if($results && mysqli_num_rows($results) > 0) {
    echo "<h3>Current Database Results:</h3>";
    
    while($row = mysqli_fetch_assoc($results)) {
        $minutes = $row['minutes_ago'];
        $seconds = $row['seconds_ago'];
        
        // Calculate display
        if($seconds < 60) {
            $display = "Just now ($seconds seconds ago)";
        } else if($minutes < 60) {
            $display = $minutes . "m ago";
        } else {
            $hours = floor($minutes / 60);
            $remaining_mins = $minutes % 60;
            if($remaining_mins > 0) {
                $display = $hours . "h " . $remaining_mins . "m ago";
            } else {
                $display = $hours . "h ago";
            }
        }
        
        echo "🎯 Game {$row['id']}: <strong>{$row['winning_color']}</strong> - {$display} ({$row['completed_at']})<br>";
    }
    
    echo "<hr>";
    echo "<h3>Problem Analysis:</h3>";
    
    if($row['minutes_ago'] < 1) {
        echo "❌ <strong>Problem Found:</strong> All results are very recent (less than 1 minute old)<br>";
        echo "💡 <strong>Solution:</strong> Need to create results with varied timing<br>";
        echo "<br><a href='create_timed_results.php' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>🔧 Fix Timing Now</a>";
    } else {
        echo "✅ Results have proper timing - check PHP time calculation function<br>";
    }
    
} else {
    echo "❌ No completed games found in database<br>";
    echo "<br><a href='create_timed_results.php' style='background:#007bff;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>➕ Create Test Results</a>";
}

echo "<br><br><a href='user/dashboard.php'>📊 View Dashboard</a>";
?>