<?php
include("../config/db.php");
include("../config/session_admin.php");


// ❌ session_start() yahan mat likho (db.php me already hai)

// 🔐 Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

/* ================= DATE LOGIC (TODAY DEFAULT) ================= */
if(isset($_GET['date']) && $_GET['date'] != ""){
    $date = mysqli_real_escape_string($conn, $_GET['date']);
}else{
    $date = date("Y-m-d"); // default today
}

/* ================= APPROVE / REJECT ACTION ================= */
if(isset($_GET['action'], $_GET['id'])){
    $id = (int)$_GET['id'];
    $action = $_GET['action'];

    // sirf pending withdrawal uthao
    $reqRes = mysqli_query($conn,"
        SELECT * FROM withdrawal_requests 
        WHERE id=$id AND status='pending'
    ");

    if($reqRes && mysqli_num_rows($reqRes) == 1){
        $req = mysqli_fetch_assoc($reqRes);

        if($action == 'approve'){
            // Money already deducted when user submitted request
            // Just mark as approved - no need to deduct again
            mysqli_query($conn,"
                UPDATE withdrawal_requests 
                SET status='approved'
                WHERE id=$id
            ");
        }

        if($action == 'reject'){
            // Return money to user since request is rejected
            mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");
            
            mysqli_query($conn,"
                UPDATE users 
                SET wallet = wallet + {$req['amount']},
                    winning_amount = winning_amount + {$req['amount']}
                WHERE id = {$req['user_id']}
            ");

            mysqli_query($conn,"
                UPDATE withdrawal_requests 
                SET status='rejected'
                WHERE id=$id
            ");
        }
    }

    header("Location: withdrawal_requests.php?date=".$date);
    exit;
}

/* ================= PENDING COUNT ================= */
$pending_count = 0;
$pc = mysqli_query($conn,"
    SELECT COUNT(*) AS total 
    FROM withdrawal_requests 
    WHERE status='pending'
");
if($pc){
    $pending_count = mysqli_fetch_assoc($pc)['total'];
}

/* ================= FETCH REQUESTS (DATE WISE) ================= */
$requests = mysqli_query($conn,"
    SELECT w.*, u.email
    FROM withdrawal_requests w
    JOIN users u ON u.id = w.user_id
    WHERE w.created_at BETWEEN '$date 00:00:00' AND '$date 23:59:59'
    ORDER BY w.id DESC
");

if(!$requests){
    die("SQL ERROR: ".mysqli_error($conn));
}
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Withdrawal Requests</title>
<style>
body{font-family:Arial;background:#f4f6f8}
.box{
    width:1200px;
    margin:30px auto;
    background:#fff;
    padding:20px;
    border-radius:8px;
    box-shadow:0 2px 6px rgba(0,0,0,.2);
}
table{
    width:100%;
    border-collapse:collapse;
    margin-top:15px;
}
th,td{
    border:1px solid #ccc;
    padding:8px;
    text-align:center;
    vertical-align:top;
}
th{background:#eee;font-weight:600;}
.badge{
    background:red;
    color:#fff;
    padding:3px 8px;
    border-radius:12px;
    font-size:12px;
}
.approve{color:green;font-weight:bold}
.reject{color:red;font-weight:bold}
a.btn{
    padding:5px 10px;
    text-decoration:none;
    border-radius:4px;
    color:#fff;
    font-size:12px;
    margin:2px;
    display:inline-block;
}
.btn-approve{background:#28a745}
.btn-reject{background:#dc3545}
.top{
    display:flex;
    justify-content:space-between;
    align-items:center;
}
.method-badge{
    background:#e3f2fd;
    color:#1976d2;
    padding:4px 8px;
    border-radius:12px;
    font-size:12px;
    font-weight:600;
}
.account-details{
    background:#f8f9fa;
    padding:8px;
    border-radius:6px;
    font-size:12px;
    line-height:1.4;
    text-align:left;
    max-width:250px;
    word-wrap:break-word;
}
</style>
</head>
<body>

<div class="box">

<div class="top">
    <h2>
        🏧 Withdrawal Requests
        <?php if($pending_count > 0){ ?>
            <span class="badge">🔔 <?php echo $pending_count; ?></span>
        <?php } ?>
    </h2>

    <!-- DATE FILTER -->
    <form method="get">
        <input type="date" name="date" value="<?php echo $date; ?>">
        <button type="submit">Search</button>
    </form>
</div>

<table class="withdrawal-table">
<tr>
    <th>ID</th>
    <th>User (Email)</th>
    <th>Amount</th>
    <th>Method</th>
    <th>Account Details</th>
    <th>Status</th>
    <th>Date & Time</th>
    <th>Action</th>
</tr>

<?php if(mysqli_num_rows($requests) == 0){ ?>
<tr>
    <td colspan="8">No withdrawal requests found</td>
</tr>
<?php } ?>

<?php while($r = mysqli_fetch_assoc($requests)){ ?>
<tr>
    <td><?php echo $r['id']; ?></td>
    <td><?php echo $r['email']; ?></td>
    <td>₹ <?php echo number_format($r['amount'], 2); ?></td>
    <td>
        <span style="background:#e3f2fd;color:#1976d2;padding:4px 8px;border-radius:12px;font-size:12px;font-weight:600;">
            <?php 
            switch($r['method']) {
                case 'bank_transfer': echo '🏦 Bank Transfer'; break;
                case 'upi': echo '📱 UPI'; break;
                case 'paytm': echo '💳 Paytm'; break;
                case 'phonepe': echo '📞 PhonePe'; break;
                default: echo ucfirst(str_replace('_', ' ', $r['method']));
            }
            ?>
        </span>
    </td>
    <td style="max-width:200px;">
        <?php if($r['account_details']): ?>
            <div style="background:#f8f9fa;padding:8px;border-radius:6px;font-size:12px;line-height:1.4;">
                <?php 
                // Format account details for better display
                $details = htmlspecialchars($r['account_details']);
                
                // If it's bank transfer, format nicely
                if($r['method'] == 'bank_transfer' && strpos($details, 'Account Holder:') !== false) {
                    $details = str_replace([
                        'Account Holder:', 
                        'Account Number:', 
                        'IFSC Code:', 
                        'Bank Name:', 
                        'Branch:'
                    ], [
                        '<strong>Holder:</strong>', 
                        '<br><strong>Account:</strong>', 
                        '<br><strong>IFSC:</strong>', 
                        '<br><strong>Bank:</strong>', 
                        '<br><strong>Branch:</strong>'
                    ], $details);
                    echo $details;
                } else {
                    // For UPI, mobile numbers, etc.
                    echo nl2br($details);
                }
                ?>
            </div>
        <?php else: ?>
            <span style="color:#999;font-style:italic;">No details</span>
        <?php endif; ?>
    </td>
    <td>
        <?php
        if($r['status']=='pending') echo "<span class='badge'>Pending</span>";
        if($r['status']=='approved') echo "<span class='approve'>Approved</span>";
        if($r['status']=='rejected') echo "<span class='reject'>Rejected</span>";
        ?>
    </td>
    <td><?php echo date("d-m-Y h:i A", strtotime($r['created_at'])); ?></td>
    <td>
        <?php if($r['status']=='pending'){ ?>
            <a class="btn btn-approve"
               href="?action=approve&id=<?php echo $r['id']; ?>&date=<?php echo $date; ?>"
               onclick="return confirm('Approve withdrawal of ₹<?php echo $r['amount']; ?> to <?php echo $r['email']; ?>?')">
               Approve
            </a>
            <a class="btn btn-reject"
               href="?action=reject&id=<?php echo $r['id']; ?>&date=<?php echo $date; ?>"
               onclick="return confirm('Reject withdrawal of ₹<?php echo $r['amount']; ?> for <?php echo $r['email']; ?>?')">
               Reject
            </a>
        <?php }else{ echo "-"; } ?>
    </td>
</tr>
<?php } ?>
</table>

<br>
<a href="dashboard.php?date=<?php echo $date; ?>">⬅ Back to Dashboard</a>

</div>

</body>
</html>
