<?php
include("../config/db.php");
include("../config/session_admin.php");



$dateQS = isset($_GET['date']) && $_GET['date'] != ""
    ? "?date=".$_GET['date']
    : "";


if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

$history = [];
$mobile = "";
$total_withdrawal = 0;

if(isset($_POST['search'])){
    $mobile = mysqli_real_escape_string($conn, $_POST['mobile']);

    // Debug info
    echo "<p style='color:blue;'>🔍 Searching for Mobile: <b>$mobile</b></p>";

    // user find by mobile (stored in email column)
    $u = mysqli_query($conn,"
        SELECT id, email 
        FROM users 
        WHERE email='$mobile'
    ");
    $user = mysqli_fetch_assoc($u);

    if($user){
        $uid = $user['id'];
        echo "<p style='color:green;'>✅ User found! ID: <b>$uid</b></p>";

        // withdrawal history from withdrawal_requests table
        $q = mysqli_query($conn,"
            SELECT amount, method, account_details, status, created_at, processed_at
            FROM withdrawal_requests 
            WHERE user_id=$uid 
            ORDER BY id DESC
        ");

        $total_records = mysqli_num_rows($q);
        echo "<p style='color:blue;'>💸 Total withdrawal records found: <b>$total_records</b></p>";

        while($row = mysqli_fetch_assoc($q)){
            $history[] = $row;
            if($row['status'] == 'approved' || $row['status'] == 'completed'){
                $total_withdrawal += (float)$row['amount'];
            }
        }
    } else {
        $error_msg = "No user found with mobile number: $mobile";
        
        // Show sample users for reference
        $sample_users = mysqli_query($conn, "SELECT id, email FROM users LIMIT 5");
        echo "<p style='color:orange;'>📋 Sample users in database:</p><ul>";
        while($sample = mysqli_fetch_assoc($sample_users)){
            echo "<li>ID: {$sample['id']}, Mobile: {$sample['email']}</li>";
        }
        echo "</ul>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Withdrawal History</title>
<style>
body{font-family:Arial;background:#f4f6f8}
.box{
    width:1200px;
    background:#fff;
    padding:20px;
    margin:30px auto;
    border-radius:8px;
    box-shadow:0 2px 6px rgba(0,0,0,.2);
}
input,button{
    padding:8px;
}
table{
    width:100%;
    border-collapse:collapse;
    margin-top:15px;
}
table th, table td{
    border:1px solid #ccc;
    padding:8px;
    text-align:center;
}
th{background:#eee}
.total{
    margin-top:15px;
    font-size:18px;
    font-weight:bold;
    text-align:right;
}
.back{margin-top:10px;display:inline-block}

/* Mobile Responsive */
@media (max-width: 1300px) {
    .box { width: 95%; }
}

@media (max-width: 768px) {
    table { font-size: 11px; }
    table th, table td { padding: 5px; }
    .box { padding: 15px; }
}
</style>
</head>
<body>

<div class="box">
    <h2>💸 Withdrawal History (Mobile Search)</h2>

    <!-- 🔍 SEARCH FORM -->
    <form method="post">
        <label>User Mobile Number :</label>
        <input type="text" name="mobile" required placeholder="Enter mobile number" maxlength="15">
        <button type="submit" name="search">Search</button>
    </form>

    <?php if(isset($error_msg)){ ?>
        <p style="color:red;"><b><?php echo $error_msg; ?></b></p>
    <?php } ?>

    <?php if(isset($_POST['search'])){ ?>

        <?php if(empty($history)){ ?>
            <p><b>No withdrawal history found.</b></p>
        <?php }else{ ?>

        <table>
            <tr>
                <th>#</th>
                <th>Amount</th>
                <th>Method</th>
                <th>Account Details</th>
                <th>Status</th>
                <th>Request Date</th>
                <th>Processed Date</th>
            </tr>

            <?php 
            $i = 1; 
            $pending_amount = 0;
            $approved_amount = 0;
            $rejected_amount = 0;
            
            foreach($history as $h){ 
                if($h['status'] == 'pending') $pending_amount += (float)$h['amount'];
                elseif($h['status'] == 'approved' || $h['status'] == 'completed') $approved_amount += (float)$h['amount'];
                elseif($h['status'] == 'rejected') $rejected_amount += (float)$h['amount'];
            ?>
            <tr>
                <td><?php echo $i++; ?></td>
                <td style="font-weight:bold;color:#e74c3c;">₹<?php echo number_format($h['amount'], 2); ?></td>
                <td><?php echo ucfirst(str_replace('_', ' ', $h['method'])); ?></td>
                <td style="font-size:12px;max-width:200px;word-wrap:break-word;">
                    <?php 
                    $details = $h['account_details'];
                    echo (strlen($details) > 50) ? substr($details, 0, 50) . '...' : $details;
                    ?>
                </td>
                <td>
                    <?php 
                    $status = $h['status'];
                    $status_color = '';
                    $status_bg = '';
                    if($status == 'approved' || $status == 'completed') {
                        $status_color = 'color:white;';
                        $status_bg = 'background:#27ae60;';
                    } elseif($status == 'rejected') {
                        $status_color = 'color:white;';
                        $status_bg = 'background:#e74c3c;';
                    } else {
                        $status_color = 'color:white;';
                        $status_bg = 'background:#f39c12;';
                    }
                    echo "<span style='padding:4px 8px;border-radius:4px;font-size:12px;font-weight:bold;{$status_color}{$status_bg}'>" . ucfirst($status) . "</span>";
                    ?>
                </td>
                <td><?php echo date("d-m-Y h:i A", strtotime($h['created_at'])); ?></td>
                <td>
                    <?php 
                    echo $h['processed_at'] ? date("d-m-Y h:i A", strtotime($h['processed_at'])) : '-';
                    ?>
                </td>
            </tr>
            <?php } ?>

        </table>

        <!-- ✅ WITHDRAWAL SUMMARY -->
        <div style="margin-top:20px;padding:20px;background:linear-gradient(135deg,#3498db,#2980b9);color:white;border-radius:10px;">
            <h3 style="margin:0 0 15px 0;text-align:center;">💸 Withdrawal Summary</h3>
            <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(180px,1fr));gap:15px;text-align:center;">
                <div>
                    <div style="font-size:24px;font-weight:bold;"><?php echo count($history); ?></div>
                    <div style="opacity:0.9;">Total Requests</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">₹<?php echo number_format($pending_amount, 2); ?></div>
                    <div style="opacity:0.9;">Pending Amount</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">₹<?php echo number_format($approved_amount, 2); ?></div>
                    <div style="opacity:0.9;">Approved Amount</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">₹<?php echo number_format($rejected_amount, 2); ?></div>
                    <div style="opacity:0.9;">Rejected Amount</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">₹<?php echo number_format($total_withdrawal, 2); ?></div>
                    <div style="opacity:0.9;">Total Paid</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">📱 <?php echo $mobile; ?></div>
                    <div style="opacity:0.9;">Mobile Number</div>
                </div>
            </div>
        </div>

        <?php } ?>
    <?php } ?>

    <!-- <a class="back" href="dashboard.php">⬅ Back to Dashboard</a> -->

    <a href="dashboard.php<?php echo $dateQS; ?>">
⬅ Back to Dashboard
</a>

</div>

</body>
</html>
