<?php
include("../config/db.php");
include("../config/session_admin.php");




$dateQS = isset($_GET['date']) && $_GET['date'] != ""
    ? "?date=".$_GET['date']
    : "";



if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

$history = [];
$mobile = "";

if(isset($_POST['search'])){
    $mobile = mysqli_real_escape_string($conn, $_POST['mobile']);

    // Debug info
    echo "<p style='color:blue;'>🔍 Searching for Mobile: <b>$mobile</b></p>";

    // 1️⃣ user find by mobile (stored in email column)
    $u = mysqli_query($conn,"
        SELECT id, email 
        FROM users 
        WHERE email='$mobile'
    ");

    if($u){
        $user = mysqli_fetch_assoc($u);

        if($user){
            $uid = (int)$user['id'];
            echo "<p style='color:green;'>✅ User found! ID: <b>$uid</b></p>";

            // 2️⃣ WINNING HISTORY (win_amount based) with game details
            $q = mysqli_query($conn,"
                SELECT b.color, b.amount, b.win_amount, b.created_at, 
                       g.winning_color, g.id as game_id, g.completed_at
                FROM bets b
                LEFT JOIN games g ON b.game_id = g.id
                WHERE b.user_id=$uid 
                  AND b.win_amount > 0
                ORDER BY b.created_at DESC
            ");

            $total_records = mysqli_num_rows($q);
            echo "<p style='color:blue;'>🏆 Total winning records found: <b>$total_records</b></p>";

            if($q){
                while($row = mysqli_fetch_assoc($q)){
                    $history[] = $row;
                }
            }
        } else {
            $error_msg = "No user found with mobile number: $mobile";
        }
    } else {
        $error_msg = "Database query failed";
    }
    
    // Show sample users if no user found
    if(isset($error_msg)) {
        $sample_users = mysqli_query($conn, "SELECT id, email FROM users LIMIT 5");
        echo "<p style='color:orange;'>📋 Sample users in database:</p><ul>";
        while($sample = mysqli_fetch_assoc($sample_users)){
            echo "<li>ID: {$sample['id']}, Mobile: {$sample['email']}</li>";
        }
        echo "</ul>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Winning History</title>
<style>
body{font-family:Arial;background:#f4f6f8}
.box{
    width:1100px;
    background:#fff;
    padding:20px;
    margin:30px auto;
    border-radius:8px;
    box-shadow:0 2px 6px rgba(0,0,0,.2);
}
input,button{padding:8px;}
table{
    width:100%;
    border-collapse:collapse;
    margin-top:15px;
}
table th, table td{
    border:1px solid #ccc;
    padding:8px;
    text-align:center;
}
th{background:#eee}
.back{margin-top:10px;display:inline-block}

/* Mobile Responsive */
@media (max-width: 1200px) {
    .box { width: 95%; }
}

@media (max-width: 768px) {
    table { font-size: 12px; }
    table th, table td { padding: 6px; }
    .box { padding: 15px; }
}
</style>
</head>
<body>

<div class="box">
    <h2>🏆 User Winning History (Mobile Search)</h2>

    <!-- 🔍 SEARCH FORM -->
    <form method="post">
        <label>User Mobile Number :</label>
        <input type="text" name="mobile" required placeholder="Enter mobile number" maxlength="15">
        <button type="submit" name="search">Search</button>
    </form>

    <?php if(isset($error_msg)){ ?>
        <p style="color:red;"><b><?php echo $error_msg; ?></b></p>
    <?php } ?>

    <?php if(isset($_POST['search'])){ ?>

        <?php if(empty($history)){ ?>
            <p><b>No winning history found.</b></p>
        <?php }else{ ?>

        <table>
            <tr>
                <th>#</th>
                <th>Game ID</th>
                <th>Bet Color</th>
                <th>Bet Amount</th>
                <th>Result Color</th>
                <th>Win Amount</th>
                <th>Multiplier</th>
                <th>Date & Time</th>
            </tr>

            <?php 
            $i = 1; 
            $total_bet_amount = 0;
            $total_win_amount = 0;
            foreach($history as $h){ 
                $total_bet_amount += (float)$h['amount'];
                $total_win_amount += (float)$h['win_amount'];
                $multiplier = ($h['amount'] > 0) ? round($h['win_amount'] / $h['amount'], 1) : 0;
            ?>
            <tr>
                <td><?php echo $i++; ?></td>
                <td style="font-family:monospace;">#<?php echo $h['game_id'] ?? 'N/A'; ?></td>
                <td>
                    <span style="padding:4px 8px;border-radius:4px;color:white;background:<?php 
                        $color = strtolower($h['color']);
                        echo ($color == 'red') ? '#e74c3c' : 
                             (($color == 'green') ? '#27ae60' : 
                             (($color == 'blue') ? '#3498db' : 
                             (($color == 'yellow') ? '#f39c12' : 
                             (($color == 'purple') ? '#9b59b6' : 
                             (($color == 'orange') ? '#e67e22' : 
                             (($color == 'pink') ? '#e91e63' : '#17a2b8'))))));
                    ?>;">
                        <?php echo ucfirst($h['color']); ?>
                    </span>
                </td>
                <td style="font-weight:bold;color:#e74c3c;">₹<?php echo number_format($h['amount'], 2); ?></td>
                <td>
                    <?php if($h['winning_color']): ?>
                        <span style="padding:4px 8px;border-radius:4px;color:white;background:<?php 
                            $win_color = strtolower($h['winning_color']);
                            echo ($win_color == 'red') ? '#e74c3c' : 
                                 (($win_color == 'green') ? '#27ae60' : 
                                 (($win_color == 'blue') ? '#3498db' : 
                                 (($win_color == 'yellow') ? '#f39c12' : 
                                 (($win_color == 'purple') ? '#9b59b6' : 
                                 (($win_color == 'orange') ? '#e67e22' : 
                                 (($win_color == 'pink') ? '#e91e63' : '#17a2b8'))))));
                        ?>;">
                            <?php echo ucfirst($h['winning_color']); ?>
                        </span>
                    <?php else: ?>
                        <span style="color:#999;">N/A</span>
                    <?php endif; ?>
                </td>
                <td style="font-weight:bold;color:#27ae60;font-size:16px;">₹<?php echo number_format($h['win_amount'], 2); ?></td>
                <td style="font-weight:bold;color:#f39c12;"><?php echo $multiplier; ?>x</td>
                <td><?php echo date("d-m-Y h:i A", strtotime($h['created_at'])); ?></td>
            </tr>
            <?php } ?>

        </table>

        <!-- ✅ WINNING SUMMARY -->
        <div style="margin-top:20px;padding:20px;background:linear-gradient(135deg,#27ae60,#2ecc71);color:white;border-radius:10px;">
            <h3 style="margin:0 0 15px 0;text-align:center;">🏆 Winning Summary</h3>
            <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:15px;text-align:center;">
                <div>
                    <div style="font-size:24px;font-weight:bold;"><?php echo count($history); ?></div>
                    <div style="opacity:0.9;">Total Wins</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">₹<?php echo number_format($total_bet_amount, 2); ?></div>
                    <div style="opacity:0.9;">Total Bet Amount</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">₹<?php echo number_format($total_win_amount, 2); ?></div>
                    <div style="opacity:0.9;">Total Win Amount</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">₹<?php echo number_format($total_win_amount - $total_bet_amount, 2); ?></div>
                    <div style="opacity:0.9;">Net Profit</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;"><?php echo ($total_bet_amount > 0) ? round(($total_win_amount / $total_bet_amount), 1) : 0; ?>x</div>
                    <div style="opacity:0.9;">Average Multiplier</div>
                </div>
                <div>
                    <div style="font-size:24px;font-weight:bold;">📱 <?php echo $mobile; ?></div>
                    <div style="opacity:0.9;">Mobile Number</div>
                </div>
            </div>
        </div>

        <?php } ?>
    <?php } ?>

    <!-- <a class="back" href="dashboard.php">⬅ Back to Dashboard</a> -->


    <a href="dashboard.php<?php echo $dateQS; ?>">
⬅ Back to Dashboard
</a>

</div>

</body>
</html>
