<?php
include("../config/db.php");
include("../config/session_admin.php");


$dateQS = isset($_GET['date']) && $_GET['date'] != ""
    ? "?date=".$_GET['date']
    : "";

// Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

// Wallet update with complete error handling
$update_message = "";
$message_type = "";

if(isset($_POST['update_wallet'])){
    $user_id = (int)$_POST['user_id'];
    $new_wallet = (float)$_POST['wallet'];
    
    // Validate input
    if($user_id <= 0) {
        $update_message = "❌ Invalid User ID";
        $message_type = "error";
    } elseif($new_wallet < 0) {
        $update_message = "❌ Wallet amount cannot be negative";
        $message_type = "error";
    } else {
        // Check if user exists and get current data
        $user_check = mysqli_query($conn, "SELECT id, name, wallet, recharge_amount, winning_amount FROM users WHERE id=$user_id");
        
        if(!$user_check) {
            $update_message = "❌ Database Error: " . mysqli_error($conn);
            $message_type = "error";
        } elseif(mysqli_num_rows($user_check) == 0) {
            $update_message = "❌ User with ID $user_id not found";
            $message_type = "error";
        } else {
            $current_user = mysqli_fetch_assoc($user_check);
            $old_wallet = $current_user['wallet'];
            $user_name = $current_user['name'];
            
            // Update wallet
            $update_query = "UPDATE users SET wallet = $new_wallet WHERE id = $user_id";
            $update_result = mysqli_query($conn, $update_query);
            
            if(!$update_result) {
                $update_message = "❌ Update Failed: " . mysqli_error($conn);
                $message_type = "error";
            } else {
                $affected_rows = mysqli_affected_rows($conn);
                if($affected_rows > 0) {
                    $update_message = "✅ Success! Updated wallet for '$user_name' from ₹" . number_format($old_wallet, 2) . " to ₹" . number_format($new_wallet, 2);
                    $message_type = "success";
                } else {
                    $update_message = "⚠️ No changes made - Same wallet amount";
                    $message_type = "warning";
                }
            }
        }
    }
}

// Add missing columns if they don't exist (auto-fix)
$add_columns = [];
$columns_check = mysqli_query($conn, "SHOW COLUMNS FROM users");
$existing_columns = [];

if($columns_check) {
    while($col = mysqli_fetch_assoc($columns_check)) {
        $existing_columns[] = $col['Field'];
    }
    
    // Add recharge_amount if missing
    if(!in_array('recharge_amount', $existing_columns)) {
        mysqli_query($conn, "ALTER TABLE users ADD COLUMN recharge_amount DECIMAL(10,2) DEFAULT 0.00 AFTER wallet");
        $add_columns[] = "recharge_amount";
    }
    
    // Add winning_amount if missing
    if(!in_array('winning_amount', $existing_columns)) {
        mysqli_query($conn, "ALTER TABLE users ADD COLUMN winning_amount DECIMAL(10,2) DEFAULT 0.00 AFTER recharge_amount");
        $add_columns[] = "winning_amount";
    }
}

// Fetch users with all available columns
$users = mysqli_query($conn, "SELECT * FROM users ORDER BY id DESC");

if(!$users) {
    $update_message = "❌ Error fetching users: " . mysqli_error($conn);
    $message_type = "error";
}
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Manage Users - Admin Panel</title>
<style>
body{
    font-family:'Segoe UI',Arial,sans-serif;
    background:#f4f6f8;
    margin:0;
    padding:0;
}

.header{
    background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);
    color:#fff;
    padding:20px;
    box-shadow:0 2px 10px rgba(0,0,0,0.1);
}

.header h2{
    margin:0;
    font-size:28px;
    font-weight:700;
}

.message{
    margin:15px 20px;
    padding:15px;
    border-radius:8px;
    font-weight:600;
    border-left:4px solid;
}

.message.success{
    background:#d4edda;
    color:#155724;
    border-color:#28a745;
}

.message.error{
    background:#f8d7da;
    color:#721c24;
    border-color:#dc3545;
}

.message.warning{
    background:#fff3cd;
    color:#856404;
    border-color:#ffc107;
}

.message.info{
    background:#d1ecf1;
    color:#0c5460;
    border-color:#17a2b8;
}

.container{
    padding:20px;
    max-width:1400px;
    margin:0 auto;
}

.back-link{
    display:inline-block;
    margin-bottom:20px;
    padding:10px 20px;
    background:#007bff;
    color:#fff;
    text-decoration:none;
    border-radius:5px;
    font-weight:600;
    transition:all 0.3s ease;
}

.back-link:hover{
    background:#0056b3;
    transform:translateY(-1px);
}

.users-table{
    width:100%;
    border-collapse:collapse;
    background:#fff;
    border-radius:10px;
    overflow:hidden;
    box-shadow:0 4px 15px rgba(0,0,0,0.1);
}

.users-table th{
    background:linear-gradient(135deg,#007bff,#0056b3);
    color:#fff;
    padding:15px 10px;
    text-align:center;
    font-weight:600;
    font-size:14px;
}

.users-table td{
    padding:12px 10px;
    border-bottom:1px solid #eee;
    text-align:center;
    vertical-align:middle;
}

.users-table tr:hover{
    background:#f8f9fa;
}

.users-table tr:last-child td{
    border-bottom:none;
}

.wallet-input{
    width:100px;
    padding:8px;
    border:2px solid #ddd;
    border-radius:5px;
    text-align:center;
    font-weight:600;
    transition:border-color 0.3s ease;
}

.wallet-input:focus{
    outline:none;
    border-color:#007bff;
    box-shadow:0 0 0 3px rgba(0,123,255,0.25);
}

.update-btn{
    padding:8px 15px;
    background:linear-gradient(135deg,#28a745,#20c997);
    color:#fff;
    border:none;
    border-radius:5px;
    font-weight:600;
    cursor:pointer;
    transition:all 0.3s ease;
    margin-left:5px;
}

.update-btn:hover{
    background:linear-gradient(135deg,#218838,#1e7e34);
    transform:translateY(-1px);
    box-shadow:0 4px 10px rgba(40,167,69,0.3);
}

.user-id{
    font-weight:700;
    color:#007bff;
}

.user-name{
    font-weight:600;
    color:#333;
}

.user-email{
    color:#666;
    font-size:13px;
}

.wallet-amount{
    font-weight:700;
    color:#28a745;
    font-size:16px;
}

.date-info{
    color:#666;
    font-size:12px;
}

.stats-row{
    background:#e3f2fd;
    font-weight:600;
}

.stats-row td{
    color:#1976d2;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .container{
        padding:10px;
    }
    
    .users-table{
        font-size:12px;
    }
    
    .users-table th,
    .users-table td{
        padding:8px 5px;
    }
    
    .wallet-input{
        width:80px;
        padding:6px;
        font-size:12px;
    }
    
    .update-btn{
        padding:6px 10px;
        font-size:12px;
    }
    
    .header h2{
        font-size:24px;
    }
}

@media (max-width: 480px) {
    .users-table{
        font-size:11px;
    }
    
    .users-table th,
    .users-table td{
        padding:6px 3px;
    }
    
    .wallet-input{
        width:70px;
        padding:4px;
    }
    
    .update-btn{
        padding:4px 8px;
        font-size:11px;
    }
}

.no-users{
    text-align:center;
    padding:60px 20px;
    color:#666;
}

.no-users h3{
    color:#999;
    margin-bottom:10px;
}
</style>
</head>
<body>

<div class="header">
    <h2>👥 Manage Users</h2>
</div>

<div class="container">
    <!-- Back Link -->
    <a href="dashboard.php<?php echo $dateQS; ?>" class="back-link">
        ⬅ Back to Dashboard
    </a>

    <!-- Messages -->
    <?php if(!empty($update_message)): ?>
        <div class="message <?php echo $message_type; ?>">
            <?php echo $update_message; ?>
        </div>
    <?php endif; ?>

    <?php if(!empty($add_columns)): ?>
        <div class="message info">
            ℹ️ Auto-added missing columns: <?php echo implode(', ', $add_columns); ?>
        </div>
    <?php endif; ?>

    <!-- Users Table -->
    <?php if($users && mysqli_num_rows($users) > 0): ?>
        <table class="users-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email/Mobile</th>
                    <th>Total Wallet</th>
                    <?php if(in_array('recharge_amount', $existing_columns)): ?>
                        <th>Recharge Amount</th>
                    <?php endif; ?>
                    <?php if(in_array('winning_amount', $existing_columns)): ?>
                        <th>Winning Amount</th>
                    <?php endif; ?>
                    <th>Member Since</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $total_users = 0;
                $total_wallet = 0;
                $total_recharge = 0;
                $total_winning = 0;
                
                while($row = mysqli_fetch_assoc($users)): 
                    $total_users++;
                    $total_wallet += $row['wallet'];
                    if(isset($row['recharge_amount'])) $total_recharge += $row['recharge_amount'];
                    if(isset($row['winning_amount'])) $total_winning += $row['winning_amount'];
                ?>
                <tr>
                    <td class="user-id"><?php echo $row['id']; ?></td>
                    <td class="user-name"><?php echo htmlspecialchars($row['name'] ?? 'N/A'); ?></td>
                    <td class="user-email"><?php echo htmlspecialchars($row['email'] ?? 'N/A'); ?></td>
                    <td class="wallet-amount">₹<?php echo number_format($row['wallet'] ?? 0, 2); ?></td>
                    
                    <?php if(in_array('recharge_amount', $existing_columns)): ?>
                        <td>₹<?php echo number_format($row['recharge_amount'] ?? 0, 2); ?></td>
                    <?php endif; ?>
                    
                    <?php if(in_array('winning_amount', $existing_columns)): ?>
                        <td>₹<?php echo number_format($row['winning_amount'] ?? 0, 2); ?></td>
                    <?php endif; ?>
                    
                    <td class="date-info">
                        <?php echo date('M j, Y', strtotime($row['created_at'] ?? 'now')); ?>
                        <br>
                        <small><?php echo date('H:i', strtotime($row['created_at'] ?? 'now')); ?></small>
                    </td>
                    <td>
                        <form method="post" style="display:inline;" 
                              onsubmit="return confirm('Are you sure you want to update wallet for <?php echo htmlspecialchars($row['name'] ?? 'this user'); ?>?\n\nCurrent: ₹<?php echo number_format($row['wallet'] ?? 0, 2); ?>\nNew: ₹' + this.wallet.value);">
                            <input type="hidden" name="user_id" value="<?php echo $row['id']; ?>">
                            <input type="number" 
                                   name="wallet" 
                                   value="<?php echo $row['wallet'] ?? 0; ?>" 
                                   min="0" 
                                   step="0.01" 
                                   class="wallet-input"
                                   title="Enter new wallet amount">
                            <button name="update_wallet" type="submit" class="update-btn">
                                💰 Update
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endwhile; ?>
                
                <!-- Summary Row -->
                <tr class="stats-row">
                    <td><strong><?php echo $total_users; ?></strong></td>
                    <td colspan="2"><strong>TOTALS</strong></td>
                    <td><strong>₹<?php echo number_format($total_wallet, 2); ?></strong></td>
                    <?php if(in_array('recharge_amount', $existing_columns)): ?>
                        <td><strong>₹<?php echo number_format($total_recharge, 2); ?></strong></td>
                    <?php endif; ?>
                    <?php if(in_array('winning_amount', $existing_columns)): ?>
                        <td><strong>₹<?php echo number_format($total_winning, 2); ?></strong></td>
                    <?php endif; ?>
                    <td colspan="2"><strong>Total Users: <?php echo $total_users; ?></strong></td>
                </tr>
            </tbody>
        </table>
    <?php else: ?>
        <div class="no-users">
            <h3>👥 No Users Found</h3>
            <p>No users are registered in the system yet.</p>
            <?php if(!$users): ?>
                <p style="color:#dc3545;">Database Error: <?php echo mysqli_error($conn); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<script>
// Auto-refresh page after successful update (optional)
<?php if($message_type === 'success'): ?>
setTimeout(function() {
    // Remove success message after 5 seconds
    const successMsg = document.querySelector('.message.success');
    if(successMsg) {
        successMsg.style.opacity = '0';
        setTimeout(() => successMsg.remove(), 500);
    }
}, 5000);
<?php endif; ?>

// Format wallet input on change
document.addEventListener('DOMContentLoaded', function() {
    const walletInputs = document.querySelectorAll('.wallet-input');
    walletInputs.forEach(input => {
        input.addEventListener('blur', function() {
            const value = parseFloat(this.value);
            if(!isNaN(value)) {
                this.value = value.toFixed(2);
            }
        });
    });
});
</script>

</body>
</html>