<?php
session_start();
include("../config/db.php");
include("../config/session_admin.php");


/* ADMIN LOGIN CHECK */
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

/* DATE FILTER (DEFAULT = TODAY) */
$date = isset($_GET['date']) && $_GET['date'] != ""
    ? $_GET['date']
    : date('Y-m-d');

/* FETCH APPROVED RECHARGES */
$recharges = mysqli_query($conn,"
    SELECT r.*, u.username
    FROM recharge_requests r
    JOIN users u ON u.id = r.user_id
    WHERE r.status='approved'
      AND DATE(r.created_at) = '$date'
    ORDER BY r.id DESC
");
?>
<!DOCTYPE html>
<html>
<head>
<title>Approved Recharge History</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{
    font-family:Arial;
    background:#0f172a;
    color:#fff;
}
h2{text-align:center;margin-top:20px;}
table{
    width:95%;
    margin:20px auto;
    border-collapse:collapse;
}
th,td{
    padding:10px;
    border:1px solid #334155;
    text-align:center;
}
th{
    background:#020617;
}
.date-box{
    text-align:center;
    margin:15px;
}
input[type=date]{
    padding:8px;
    border-radius:6px;
}
.total{
    text-align:center;
    margin-top:10px;
    font-size:16px;
    color:#22c55e;
}
</style>
</head>

<body>

<h2>✅ Approved Recharge History</h2>

<!-- DATE SELECT -->
<div class="date-box">
    <form method="get">
        <input type="date"
               name="date"
               value="<?php echo $date; ?>"
               onchange="this.form.submit()">
    </form>
</div>

<table>
<tr>
    <th>ID</th>
    <th>User</th>
    <th>Amount</th>
    <th>Method</th>
    <th>Txn ID</th>
    <th>Date</th>
</tr>

<?php
$total = 0;
if(mysqli_num_rows($recharges)==0){
    echo "<tr><td colspan='6'>No approved recharge found</td></tr>";
}
?>

<?php while($r=mysqli_fetch_assoc($recharges)){
    $total += $r['amount'];
?>
<tr>
    <td><?php echo $r['id']; ?></td>
    <td><?php echo $r['username']; ?></td>
    <td>₹<?php echo $r['amount']; ?></td>
    <td><?php echo $r['method']; ?></td>
    <td><?php echo $r['txn_id']; ?></td>
    <td><?php echo date("d-m-Y H:i", strtotime($r['created_at'])); ?></td>
</tr>
<?php } ?>

</table>

<div class="total">
    Total Approved Amount (<?php echo $date; ?>) : ₹<?php echo $total; ?>
</div>

</body>
</html>
