<?php
include("../config/db.php");
include("../config/session_admin.php");

// Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

$msg = "";

// Handle manual result upload
if(isset($_POST['upload_result'])) {
    $winning_color = mysqli_real_escape_string($conn, $_POST['winning_color']);
    $game_id = (int)$_POST['game_id'];
    
    if(empty($winning_color)) {
        $msg = "❌ Please select a winning color";
    } else {
        // Check if game exists and is running
        $game_check = mysqli_query($conn, "
            SELECT * FROM games 
            WHERE id = $game_id AND status = 'running'
        ");
        
        if($game_check && mysqli_num_rows($game_check) > 0) {
            // Process the result manually (same logic as automatic system)
            
            // Get all pending bets for this game
            $bets_result = mysqli_query($conn, "
                SELECT * FROM bets 
                WHERE game_id = $game_id AND status = 'pending'
            ");
            
            $total_winnings = 0;
            $total_bets = 0;
            $winning_bets = [];
            
            if($bets_result) {
                while($bet = mysqli_fetch_assoc($bets_result)) {
                    $total_bets++;
                    
                    if(strtolower(trim($bet['color'])) === strtolower(trim($winning_color))) {
                        // WIN - 7x payout (Business Algorithm)
                        $win_amount = $bet['amount'] * 7;
                        $total_winnings += $win_amount;
                        
                        // Add to wallet and winning amount
                        mysqli_query($conn, "
                            UPDATE users 
                            SET wallet = wallet + $win_amount, 
                                winning_amount = winning_amount + $win_amount 
                            WHERE id = {$bet['user_id']}
                        ");
                        
                        // Update bet to win
                        mysqli_query($conn, "
                            UPDATE bets 
                            SET status = 'win', win_amount = $win_amount 
                            WHERE id = {$bet['id']}
                        ");
                        
                        $winning_bets[] = [
                            'user_id' => $bet['user_id'],
                            'color' => $bet['color'],
                            'bet_amount' => $bet['amount'],
                            'win_amount' => $win_amount
                        ];
                    } else {
                        // LOSS
                        mysqli_query($conn, "
                            UPDATE bets 
                            SET status = 'loss', win_amount = 0 
                            WHERE id = {$bet['id']}
                        ");
                    }
                }
            }
            
            // Mark game as completed with winning color
            mysqli_query($conn, "
                UPDATE games 
                SET status = 'completed', 
                    winning_color = '$winning_color', 
                    completed_at = NOW() 
                WHERE id = $game_id
            ");
            
            // Create new running game
            mysqli_query($conn, "
                INSERT INTO games (status, created_at) 
                VALUES ('running', NOW())
            ");
            
            $msg = "✅ Result uploaded successfully! Color: " . strtoupper($winning_color) . 
                   " | Total Bets: $total_bets | Winners: " . count($winning_bets) . 
                   " | Total Winnings: ₹" . number_format($total_winnings, 2);
                   
        } else {
            $msg = "❌ No running game found with ID: $game_id";
        }
    }
}

// Handle force new game creation
if(isset($_POST['force_new_game'])) {
    // Mark any running games as completed without result
    mysqli_query($conn, "
        UPDATE games 
        SET status = 'completed', 
            winning_color = 'no_result', 
            completed_at = NOW() 
        WHERE status = 'running'
    ");
    
    // Mark all pending bets as cancelled
    mysqli_query($conn, "
        UPDATE bets 
        SET status = 'cancelled' 
        WHERE status = 'pending'
    ");
    
    // Create new running game
    mysqli_query($conn, "
        INSERT INTO games (status, created_at) 
        VALUES ('running', NOW())
    ");
    
    $msg = "✅ New game created! All previous pending bets cancelled.";
}

// Get current running game
$running_game = mysqli_query($conn, "
    SELECT * FROM games 
    WHERE status = 'running' 
    ORDER BY id DESC 
    LIMIT 1
");

$current_game = null;
if($running_game && mysqli_num_rows($running_game) > 0) {
    $current_game = mysqli_fetch_assoc($running_game);
}

// Get pending bets for current game
$pending_bets = [];
$total_bet_amount = 0;
if($current_game) {
    $bets_query = mysqli_query($conn, "
        SELECT b.*, u.name, u.email 
        FROM bets b
        JOIN users u ON u.id = b.user_id
        WHERE b.game_id = {$current_game['id']} AND b.status = 'pending'
        ORDER BY b.created_at DESC
    ");
    
    if($bets_query) {
        while($bet = mysqli_fetch_assoc($bets_query)) {
            $pending_bets[] = $bet;
            $total_bet_amount += $bet['amount'];
        }
    }
}

// Get recent completed games
$recent_games = mysqli_query($conn, "
    SELECT * FROM games 
    WHERE status = 'completed' 
    ORDER BY completed_at DESC 
    LIMIT 10
");
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Manage Game Results</title>
<style>
body{font-family:Arial;background:#f4f6f8;margin:0;padding:20px}
.container{max-width:1200px;margin:0 auto}
.box{
    background:#fff;
    padding:25px;
    border-radius:10px;
    box-shadow:0 2px 10px rgba(0,0,0,.1);
    margin-bottom:25px;
}
.box h2{margin-top:0;color:#333;border-bottom:2px solid #007bff;padding-bottom:10px}
.form-group{margin-bottom:20px}
.form-label{display:block;margin-bottom:8px;font-weight:600;color:#333}
.form-input{
    width:100%;
    padding:12px;
    border:1px solid #ddd;
    border-radius:8px;
    font-size:14px;
    box-sizing:border-box;
}
.form-input:focus{outline:none;border-color:#007bff;box-shadow:0 0 0 3px rgba(0,123,255,.1)}
.btn{
    padding:12px 20px;
    border:none;
    border-radius:6px;
    cursor:pointer;
    font-weight:600;
    text-decoration:none;
    display:inline-block;
    margin-right:10px;
    margin-bottom:10px;
}
.btn-primary{background:#007bff;color:#fff}
.btn-success{background:#28a745;color:#fff}
.btn-danger{background:#dc3545;color:#fff}
.btn-warning{background:#ffc107;color:#000}
.btn:hover{opacity:0.9;transform:translateY(-1px)}
.alert{padding:15px;border-radius:8px;margin-bottom:20px;font-weight:600}
.alert-success{background:#d4edda;color:#155724;border:1px solid #c3e6cb}
.alert-error{background:#f8d7da;color:#721c24;border:1px solid #f5c6cb}
.color-grid{
    display:grid;
    grid-template-columns:repeat(4,1fr);
    gap:15px;
    margin:20px 0;
}
.color-option{
    padding:20px;
    border-radius:10px;
    text-align:center;
    cursor:pointer;
    font-weight:700;
    color:#fff;
    text-shadow:0 1px 3px rgba(0,0,0,0.5);
    transition:all 0.3s ease;
    border:3px solid transparent;
}
.color-option:hover{transform:translateY(-3px);box-shadow:0 8px 25px rgba(0,0,0,0.3)}
.color-option.selected{border-color:#ffd700;box-shadow:0 0 20px rgba(255,215,0,0.5)}
.red{background:linear-gradient(135deg,#e74c3c,#c0392b)}
.green{background:linear-gradient(135deg,#27ae60,#229954)}
.yellow{background:linear-gradient(135deg,#f39c12,#e67e22);color:#000;text-shadow:0 1px 3px rgba(0,0,0,0.3)}
.blue{background:linear-gradient(135deg,#3498db,#2980b9)}
.purple{background:linear-gradient(135deg,#9b59b6,#8e44ad)}
.orange{background:linear-gradient(135deg,#e67e22,#d35400)}
.pink{background:linear-gradient(135deg,#e91e63,#c2185b)}
.cyan{background:linear-gradient(135deg,#1abc9c,#16a085)}
table{width:100%;border-collapse:collapse;margin-top:15px}
th,td{padding:12px;text-align:left;border-bottom:1px solid #ddd}
th{background:#f8f9fa;font-weight:600}
tr:hover{background:#f8f9fa}
.status-badge{padding:4px 8px;border-radius:12px;font-size:12px;font-weight:600}
.status-running{background:#fff3cd;color:#856404}
.status-completed{background:#d4edda;color:#155724}
.back-link{color:#007bff;text-decoration:none;font-weight:600}
.back-link:hover{text-decoration:underline}
.game-info{
    background:#e3f2fd;
    padding:20px;
    border-radius:10px;
    border-left:4px solid #2196f3;
    margin:20px 0;
}
</style>
</head>
<body>

<div class="container">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:30px;">
        <h1>🎮 Manage Game Results</h1>
        <a href="dashboard.php" class="back-link">⬅ Back to Dashboard</a>
    </div>

    <?php if($msg): ?>
        <div class="alert <?= strpos($msg, '✅') !== false ? 'alert-success' : 'alert-error' ?>">
            <?= $msg ?>
        </div>
    <?php endif; ?>

    <!-- Current Game Status -->
    <div class="box">
        <h2>🎯 Current Game Status</h2>
        
        <?php if($current_game): ?>
            <div class="game-info">
                <h3 style="margin:0 0 15px;color:#1976d2;">🎮 Game ID: <?= $current_game['id'] ?></h3>
                <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:15px;">
                    <div>
                        <strong>Status:</strong> 
                        <span class="status-badge status-running">Running</span>
                    </div>
                    <div>
                        <strong>Started:</strong> 
                        <?= date('M j, Y H:i:s', strtotime($current_game['created_at'])) ?>
                    </div>
                    <div>
                        <strong>Pending Bets:</strong> 
                        <?= count($pending_bets) ?>
                    </div>
                    <div>
                        <strong>Total Bet Amount:</strong> 
                        ₹<?= number_format($total_bet_amount, 2) ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div style="text-align:center;padding:40px;color:#666;">
                <h3>🎮 No Running Game</h3>
                <p>There is no active game currently running.</p>
                <form method="POST" style="display:inline;">
                    <button type="submit" name="force_new_game" class="btn btn-success">🚀 Start New Game</button>
                </form>
            </div>
        <?php endif; ?>
    </div>

    <!-- Manual Result Upload -->
    <?php if($current_game): ?>
    <div class="box">
        <h2>📤 Upload Manual Result</h2>
        
        <form method="POST" id="resultForm">
            <input type="hidden" name="game_id" value="<?= $current_game['id'] ?>">
            
            <div class="form-group">
                <label class="form-label">Select Winning Color</label>
                <div class="color-grid">
                    <div class="color-option red" onclick="selectColor('red')">RED</div>
                    <div class="color-option green" onclick="selectColor('green')">GREEN</div>
                    <div class="color-option yellow" onclick="selectColor('yellow')">YELLOW</div>
                    <div class="color-option blue" onclick="selectColor('blue')">BLUE</div>
                    <div class="color-option purple" onclick="selectColor('purple')">PURPLE</div>
                    <div class="color-option orange" onclick="selectColor('orange')">ORANGE</div>
                    <div class="color-option pink" onclick="selectColor('pink')">PINK</div>
                    <div class="color-option cyan" onclick="selectColor('cyan')">CYAN</div>
                </div>
                <input type="hidden" name="winning_color" id="winning_color" required>
            </div>
            
            <div style="background:#fff3cd;padding:15px;border-radius:8px;border:1px solid #ffeaa7;margin:20px 0;">
                <h4 style="color:#856404;margin:0 0 10px;">⚠️ Result Upload Summary:</h4>
                <p style="margin:0;color:#856404;">
                    <strong>Game ID:</strong> <?= $current_game['id'] ?><br>
                    <strong>Pending Bets:</strong> <?= count($pending_bets) ?><br>
                    <strong>Total Bet Amount:</strong> ₹<?= number_format($total_bet_amount, 2) ?><br>
                    <strong>Action:</strong> Process all bets and declare result
                </p>
            </div>
            
            <button type="submit" name="upload_result" class="btn btn-success" onclick="return confirm('Are you sure you want to upload this result? This action cannot be undone.')">
                📤 Upload Result
            </button>
            
            <button type="button" onclick="resetSelection()" class="btn btn-warning">🔄 Reset Selection</button>
        </form>
    </div>
    <?php endif; ?>

    <!-- Pending Bets -->
    <?php if(!empty($pending_bets)): ?>
    <div class="box">
        <h2>⏳ Pending Bets (Game ID: <?= $current_game['id'] ?>)</h2>
        
        <table>
            <thead>
                <tr>
                    <th>User</th>
                    <th>Color</th>
                    <th>Amount</th>
                    <th>Time</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($pending_bets as $bet): ?>
                    <tr>
                        <td>
                            <strong><?= htmlspecialchars($bet['name']) ?></strong><br>
                            <small style="color:#666;"><?= htmlspecialchars($bet['email']) ?></small>
                        </td>
                        <td>
                            <span style="background:<?= $bet['color'] ?>;color:#fff;padding:4px 8px;border-radius:12px;font-size:12px;font-weight:600;">
                                <?= strtoupper($bet['color']) ?>
                            </span>
                        </td>
                        <td style="font-weight:700;">₹<?= number_format($bet['amount'], 2) ?></td>
                        <td><?= date('H:i:s', strtotime($bet['created_at'])) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>

    <!-- Recent Games -->
    <div class="box">
        <h2>📋 Recent Completed Games</h2>
        
        <?php if($recent_games && mysqli_num_rows($recent_games) > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>Game ID</th>
                        <th>Winning Color</th>
                        <th>Completed At</th>
                        <th>Duration</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($game = mysqli_fetch_assoc($recent_games)): ?>
                        <tr>
                            <td>#<?= $game['id'] ?></td>
                            <td>
                                <?php if($game['winning_color'] && $game['winning_color'] != 'no_result'): ?>
                                    <span style="background:<?= $game['winning_color'] ?>;color:#fff;padding:4px 8px;border-radius:12px;font-size:12px;font-weight:600;">
                                        <?= strtoupper($game['winning_color']) ?>
                                    </span>
                                <?php else: ?>
                                    <span style="color:#999;">No Result</span>
                                <?php endif; ?>
                            </td>
                            <td><?= date('M j, Y H:i:s', strtotime($game['completed_at'])) ?></td>
                            <td>
                                <?php
                                $duration = strtotime($game['completed_at']) - strtotime($game['created_at']);
                                echo gmdate('i:s', $duration) . ' min';
                                ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div style="text-align:center;padding:40px;color:#666;">
                <h3>🎮 No Completed Games</h3>
                <p>Recent completed games will appear here.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Emergency Actions -->
    <div class="box">
        <h2>🚨 Emergency Actions</h2>
        
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(300px,1fr));gap:20px;">
            <div style="padding:20px;background:#fff3cd;border-radius:10px;border:1px solid #ffeaa7;">
                <h3 style="color:#856404;margin-bottom:15px;">🔄 Force New Game</h3>
                <p style="margin-bottom:15px;color:#856404;">Cancel current game and start fresh. All pending bets will be cancelled.</p>
                <form method="POST" style="display:inline;">
                    <button type="submit" name="force_new_game" class="btn btn-warning" 
                            onclick="return confirm('This will cancel all pending bets and start a new game. Are you sure?')">
                        🔄 Force New Game
                    </button>
                </form>
            </div>
            
            <div style="padding:20px;background:#f8d7da;border-radius:10px;border:1px solid #f5c6cb;">
                <h3 style="color:#721c24;margin-bottom:15px;">⚠️ Important Notes</h3>
                <ul style="color:#721c24;line-height:1.6;">
                    <li>Manual results override automatic system</li>
                    <li>All pending bets will be processed</li>
                    <li>Winners get 2x their bet amount</li>
                    <li>Action cannot be undone</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
let selectedColor = '';

function selectColor(color) {
    // Remove previous selection
    document.querySelectorAll('.color-option').forEach(el => {
        el.classList.remove('selected');
    });
    
    // Add selection to clicked color
    document.querySelector('.color-option.' + color).classList.add('selected');
    
    // Set hidden input value
    document.getElementById('winning_color').value = color;
    selectedColor = color;
}

function resetSelection() {
    document.querySelectorAll('.color-option').forEach(el => {
        el.classList.remove('selected');
    });
    document.getElementById('winning_color').value = '';
    selectedColor = '';
}

// Form validation
document.getElementById('resultForm').addEventListener('submit', function(e) {
    if(!selectedColor) {
        e.preventDefault();
        alert('Please select a winning color before uploading result.');
        return false;
    }
});
</script>

</body>
</html>