<?php
include("../config/db.php");
include("../config/session_admin.php");



$dateQS = isset($_GET['date']) && $_GET['date'] != ""
    ? "?date=".$_GET['date']
    : "";


// Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

// Fetch game history with user info
$history = mysqli_query($conn,
"SELECT gh.*, u.name, u.email 
 FROM game_history gh 
 JOIN users u ON gh.user_id = u.id 
 ORDER BY gh.id DESC"
);
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
    <title>Game History</title>
    <style>
        body{font-family:Arial;background:#f4f6f8;}
        .header{background:#222;color:#fff;padding:15px;}
        table{
            width:100%;
            border-collapse:collapse;
            background:#fff;
            margin-top:20px;
        }
        th,td{
            padding:10px;
            border:1px solid #ddd;
            text-align:center;
            font-size:14px;
        }
        th{background:#6c757d;color:#fff;}
        .win{color:green;font-weight:bold;}
        .lose{color:red;font-weight:bold;}
        a{
            display:inline-block;
            margin:15px;
            text-decoration:none;
            color:#007bff;
        }
    </style>
</head>
<body>

<div class="header">
    <h2>📜 Game History</h2>
</div>

<!-- <a href="dashboard.php">← Back to Dashboard</a> -->

<a href="dashboard.php<?php echo $dateQS; ?>">
⬅ Back to Dashboard
</a>


<table>
    <tr>
        <th>ID</th>
        <th>User</th>
        <th>Email</th>
        <th>Bet</th>
        <th>User Colour</th>
        <th>Result Colour</th>
        <th>Result</th>
        <th>Date</th>
    </tr>

    <?php while($row = mysqli_fetch_assoc($history)){ ?>
    <tr>
        <td><?php echo $row['id']; ?></td>
        <td><?php echo $row['name']; ?></td>
        <td><?php echo $row['email']; ?></td>
        <td>₹ <?php echo $row['bet_amount']; ?></td>
        <td><?php echo $row['user_color']; ?></td>
        <td><?php echo $row['result_color']; ?></td>
        <td class="<?php echo strtolower($row['result']); ?>">
            <?php echo $row['result']; ?>
        </td>
        <td><?php echo $row['bet_time']; ?></td>
    </tr>
    <?php } ?>

</table>

</body>
</html>
