<?php
include("config/db.php");

echo "<h2>Adding Test Results</h2>";

$colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];

// Add 6 test completed games
for($i = 0; $i < 6; $i++) {
    $winner = $colors[array_rand($colors)];
    $minutes_ago = ($i + 1) * 5; // 5, 10, 15, 20, 25, 30 minutes ago
    
    $result = mysqli_query($conn, "
        INSERT INTO games (status, winning_color, created_at, completed_at) 
        VALUES (
            'completed', 
            '$winner', 
            NOW() - INTERVAL $minutes_ago MINUTE, 
            NOW() - INTERVAL " . ($minutes_ago - 2) . " MINUTE
        )
    ");
    
    if($result) {
        echo "✅ Added test game $i: Winner = $winner<br>";
    } else {
        echo "❌ Failed to add test game $i: " . mysqli_error($conn) . "<br>";
    }
}

echo "<h3>Current Results:</h3>";
$check = mysqli_query($conn, "
    SELECT id, winning_color, completed_at 
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 10
");

while($row = mysqli_fetch_assoc($check)) {
    echo "Game {$row['id']}: {$row['winning_color']} at {$row['completed_at']}<br>";
}

echo "<br><a href='user/dashboard.php'>Go to Dashboard</a>";
echo "<br><a href='test_results.php'>Test Results API</a>";
?>