<?php
$page_title = "Withdraw Money";
include("includes/header.php");

// Add winning_amount column if not exists
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");

// Get fresh user data with separate amounts
$user_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id = $user_id"));

// If amounts are not set, calculate them from wallet and bet history
if($user_data['winning_amount'] == 0 && $user_data['recharge_amount'] == 0 && $user_data['wallet'] > 0) {
    // Calculate total winnings from bets
    $total_winnings = mysqli_fetch_assoc(mysqli_query($conn, "
        SELECT COALESCE(SUM(win_amount), 0) as total_winnings 
        FROM bets 
        WHERE user_id = $user_id AND status = 'win'
    "));
    
    $winning_amt = $total_winnings['total_winnings'];
    $recharge_amt = max(0, $user_data['wallet'] - $winning_amt);
    
    // Update the separate amounts
    mysqli_query($conn, "
        UPDATE users 
        SET recharge_amount = $recharge_amt, winning_amount = $winning_amt 
        WHERE id = $user_id
    ");
    
    // Refresh user data
    $user_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id = $user_id"));
}

// Check if wallet calculation is correct, if not fix it
$calculated_wallet = $user_data['recharge_amount'] + $user_data['winning_amount'];
if(abs($user_data['wallet'] - $calculated_wallet) > 0.01) {
    // Fix wallet to match the sum of recharge + winning amounts
    mysqli_query($conn, "
        UPDATE users 
        SET wallet = recharge_amount + winning_amount 
        WHERE id = $user_id
    ");
    
    // Refresh user data after fix
    $user_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id = $user_id"));
}

// Handle withdrawal request
if(isset($_POST['withdraw_request'])) {
    $amount = (float)$_POST['amount'];
    $method = mysqli_real_escape_string($conn, $_POST['method']);
    
    // Get fresh user data before processing
    $fresh_user_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id = $user_id"));
    
    // Get bank details if bank transfer is selected
    $account_details = '';
    if($method == 'bank_transfer') {
        $account_holder = mysqli_real_escape_string($conn, $_POST['account_holder']);
        $account_number = mysqli_real_escape_string($conn, $_POST['account_number']);
        $ifsc_code = mysqli_real_escape_string($conn, $_POST['ifsc_code']);
        $bank_name = mysqli_real_escape_string($conn, $_POST['bank_name']);
        $branch_name = mysqli_real_escape_string($conn, $_POST['branch_name']);
        
        $account_details = "Account Holder: $account_holder\nAccount Number: $account_number\nIFSC Code: $ifsc_code\nBank Name: $bank_name\nBranch: $branch_name";
    } else {
        $account_details = mysqli_real_escape_string($conn, $_POST['account_details']);
    }
    
    // Check if user has minimum winning amount of ₹100
    if($fresh_user_data['winning_amount'] < 100) {
        $error_msg = "You need minimum ₹100 winning amount to withdraw. Current winning amount: ₹" . number_format($fresh_user_data['winning_amount'], 2);
    } else if($amount < 100) {
        $error_msg = "Minimum withdrawal amount is ₹100";
    } else if($amount > $fresh_user_data['winning_amount']) {
        $error_msg = "You can only withdraw from your winning amount. Available: ₹" . number_format($fresh_user_data['winning_amount'], 2);
    } else {
        // Insert withdrawal request
        $insert = mysqli_query($conn, "
            INSERT INTO withdrawal_requests (user_id, amount, method, account_details, status, created_at) 
            VALUES ($user_id, $amount, '$method', '$account_details', 'pending', NOW())
        ");
        
        if($insert) {
            // Deduct money immediately when withdrawal request is submitted
            $update_result = mysqli_query($conn, "
                UPDATE users 
                SET winning_amount = winning_amount - $amount, 
                    wallet = wallet - $amount 
                WHERE id = $user_id
            ");
            
            if($update_result) {
                $success_msg = "Withdrawal request submitted! Amount: ₹$amount has been deducted from your balance. Please wait for admin approval.";
                
                // Get completely fresh user data after successful withdrawal
                $user_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id = $user_id"));
                $user = $user_data; // Update the main user variable too
            } else {
                $error_msg = "Failed to update wallet balance!";
            }
        } else {
            $error_msg = "Failed to submit withdrawal request!";
        }
    }
}

// Create withdrawal_requests table if not exists
mysqli_query($conn, "
    CREATE TABLE IF NOT EXISTS withdrawal_requests (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        amount DECIMAL(10,2) NOT NULL,
        method VARCHAR(50) NOT NULL,
        account_details TEXT NOT NULL,
        status ENUM('pending','completed','rejected') DEFAULT 'pending',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        processed_at TIMESTAMP NULL,
        FOREIGN KEY (user_id) REFERENCES users(id)
    )
");
?>

<div class="container">
    <?php if(isset($success_msg)): ?>
        <div class="card" style="background:rgba(39,174,96,0.2);border-color:#27ae60;">
            <p style="color:#27ae60;font-weight:600;">✅ <?= $success_msg ?></p>
        </div>
    <?php endif; ?>
    
    <?php if(isset($error_msg)): ?>
        <div class="card" style="background:rgba(231,76,60,0.2);border-color:#e74c3c;">
            <p style="color:#e74c3c;font-weight:600;">❌ <?= $error_msg ?></p>
        </div>
    <?php endif; ?>

    <!-- Current Balance -->
    <div class="content-box">
        <h2 class="section-title">💰 Withdrawal Balance</h2>
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:20px;text-align:center;">
            <div style="padding:20px;background:rgba(39,174,96,0.2);border-radius:15px;border:1px solid #27ae60;">
                <div style="font-size:32px;font-weight:700;color:#27ae60;">
                    ₹<?= number_format($user_data['winning_amount'], 2) ?>
                </div>
                <p style="color:#27ae60;font-weight:600;margin-top:5px;">Winning Amount</p>
                <small style="opacity:0.8;">Available for withdrawal</small>
            </div>
            <div style="padding:20px;background:rgba(52,152,219,0.2);border-radius:15px;border:1px solid #3498db;">
                <div style="font-size:32px;font-weight:700;color:#3498db;">
                    ₹<?= number_format($user_data['wallet'], 2) ?>
                </div>
                <p style="color:#3498db;font-weight:600;margin-top:5px;">Total Wallet</p>
                <small style="opacity:0.8;">Total available balance</small>
            </div>
        </div>
        
        <!-- Debug Info (remove in production) -->
        <div style="margin-top:15px;padding:10px;background:rgba(0,0,0,0.1);border-radius:8px;font-size:12px;opacity:0.8;">
            <strong>Debug:</strong> 
            Wallet (<?= $user_data['wallet'] ?>) = 
            Recharge (<?= $user_data['recharge_amount'] ?>) + 
            Winning (<?= $user_data['winning_amount'] ?>) = 
            <?= $user_data['recharge_amount'] + $user_data['winning_amount'] ?>
            <?php if(abs($user_data['wallet'] - ($user_data['recharge_amount'] + $user_data['winning_amount'])) > 0.01): ?>
                <span style="color:#e74c3c;"> ❌ MISMATCH!</span>
            <?php else: ?>
                <span style="color:#27ae60;"> ✅ BALANCED</span>
            <?php endif; ?>
        </div>
        
        <?php if($user_data['winning_amount'] < 100): ?>
            <div style="margin-top:20px;padding:15px;background:rgba(231,76,60,0.2);border-radius:10px;border:1px solid #e74c3c;">
                <p style="color:#e74c3c;font-weight:600;text-align:center;">
                    ⚠️ You need minimum ₹100 winning amount to withdraw
                </p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Withdrawal Form -->
    <div class="content-box">
        <h2 class="section-title">🏧 Withdraw Money</h2>
        
        <?php if($user_data['winning_amount'] >= 100): ?>
        <form method="POST" id="withdrawForm">
            <div class="form-group">
                <label class="form-label">Withdrawal Amount</label>
                <input type="number" name="amount" class="form-input" placeholder="Enter amount (Min: ₹100)" min="100" max="<?= $user_data['winning_amount'] ?>" step="0.01" required>
                <small style="color:rgba(255,255,255,0.7);">Minimum: ₹100 | Maximum: ₹<?= number_format($user_data['winning_amount'], 2) ?> (Winning Amount Only)</small>
            </div>
            
            <div class="form-group">
                <label class="form-label">Withdrawal Method</label>
                <select name="method" class="form-input" required onchange="updateAccountFields(this.value)">
                    <option value="">Select Withdrawal Method</option>
                    <option value="bank_transfer">Bank Transfer</option>
                    <option value="upi">UPI</option>
                    <option value="paytm">Paytm</option>
                    <option value="phonepe">PhonePe</option>
                </select>
            </div>
            
            <!-- Bank Transfer Fields (Hidden by default) -->
            <div id="bankFields" style="display:none;">
                <div class="form-group">
                    <label class="form-label">Account Holder Name</label>
                    <input type="text" name="account_holder" class="form-input" placeholder="Enter account holder name">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Account Number</label>
                    <input type="text" name="account_number" class="form-input" placeholder="Enter account number">
                </div>
                
                <div class="form-group">
                    <label class="form-label">IFSC Code</label>
                    <input type="text" name="ifsc_code" class="form-input" placeholder="Enter IFSC code" style="text-transform:uppercase;">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Bank Name</label>
                    <input type="text" name="bank_name" class="form-input" placeholder="Enter bank name">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Branch Name</label>
                    <input type="text" name="branch_name" class="form-input" placeholder="Enter branch name">
                </div>
            </div>
            
            <!-- Other Payment Methods Field -->
            <div class="form-group" id="otherAccountField" style="display:none;">
                <label class="form-label" id="account_label">Account Details</label>
                <textarea name="account_details" class="form-input" id="account_details" placeholder="Enter your account details" rows="3"></textarea>
                <small style="color:rgba(255,255,255,0.7);" id="account_help">Please provide complete account information</small>
            </div>
            
            <button type="submit" name="withdraw_request" class="btn" style="width:100%;justify-content:center;">
                🏧 Submit Withdrawal Request
            </button>
        </form>
        <?php else: ?>
            <div style="text-align:center;padding:40px;">
                <div style="font-size:64px;opacity:0.5;margin-bottom:20px;">🏧</div>
                <h3 style="color:#e74c3c;margin-bottom:15px;">Withdrawal Not Available</h3>
                <p style="opacity:0.8;margin-bottom:20px;">You need minimum ₹100 winning amount to make a withdrawal.</p>
                <p style="color:#ffd700;font-weight:600;">Current Winning Amount: ₹<?= number_format($user_data['winning_amount'], 2) ?></p>
                <a href="game.php" class="btn" style="margin-top:20px;">🎮 Play Game to Win</a>
            </div>
        <?php endif; ?>
    </div>

    <!-- Withdrawal History -->
    <div class="content-box">
        <h2 class="section-title">📋 Withdrawal History</h2>
        
        <?php
        $withdrawal_history = mysqli_query($conn, "
            SELECT * FROM withdrawal_requests 
            WHERE user_id=$user_id 
            ORDER BY created_at DESC 
            LIMIT 10
        ");
        
        if($withdrawal_history && mysqli_num_rows($withdrawal_history) > 0):
        ?>
            <table class="table withdrawal-history-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>Status</th>
                        <th>Processed</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = mysqli_fetch_assoc($withdrawal_history)): ?>
                        <tr>
                            <td><?= date('M j, Y H:i', strtotime($row['created_at'])) ?></td>
                            <td style="font-weight:700;color:#ffd700;">₹<?= number_format($row['amount'], 2) ?></td>
                            <td><?= ucfirst(str_replace('_', ' ', $row['method'])) ?></td>
                            <td>
                                <span class="status <?= $row['status'] ?>">
                                    <?= ucfirst($row['status']) ?>
                                </span>
                            </td>
                            <td>
                                <?= $row['processed_at'] ? date('M j, Y', strtotime($row['processed_at'])) : '-' ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="empty-state">
                <div class="empty-state-icon">🏧</div>
                <div class="empty-state-title">No Withdrawal History</div>
                <div class="empty-state-text">Your withdrawal requests will appear here</div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Withdrawal Info -->
    <!--<div class="content-box">-->
    <!--    <h2 class="section-title">ℹ️ Withdrawal Rules & Information</h2>-->
        
    <!--    <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;">-->
    <!--        <div class="card">-->
    <!--            <h3 style="color:#e74c3c;margin-bottom:10px;">🎯 Winning Amount Only</h3>-->
    <!--            <p>You can only withdraw money from your winning amount, not from recharged amount.</p>-->
    <!--        </div>-->
            
    <!--        <div class="card">-->
    <!--            <h3 style="color:#f39c12;margin-bottom:10px;">💰 Minimum ₹100</h3>-->
    <!--            <p>Minimum winning amount of ₹100 required to make any withdrawal request.</p>-->
    <!--        </div>-->
            
    <!--        <div class="card">-->
    <!--            <h3 style="color:#e74c3c;margin-bottom:10px;">⏰ Processing Time</h3>-->
    <!--            <p>Withdrawals are processed within 24-48 hours on business days after verification.</p>-->
    <!--        </div>-->
            
    <!--        <div class="card">-->
    <!--            <h3 style="color:#3498db;margin-bottom:10px;">🔒 Secure Process</h3>-->
    <!--            <p>All withdrawals are manually verified for security before processing.</p>-->
    <!--        </div>-->
            
    <!--        <div class="card">-->
    <!--            <h3 style="color:#27ae60;margin-bottom:10px;">🏦 Bank Transfer</h3>-->
    <!--            <p>For bank transfers, provide complete and accurate bank account details.</p>-->
    <!--        </div>-->
            
    <!--        <div class="card">-->
    <!--            <h3 style="color:#9b59b6;margin-bottom:10px;">📞 Support</h3>-->
    <!--            <p>Contact support for any issues with your withdrawal requests.</p>-->
    <!--        </div>-->
    <!--    </div>-->
        
    <!--    <div style="margin-top:25px;padding:20px;background:rgba(255,193,7,0.2);border-radius:15px;border:1px solid #ffc107;">-->
    <!--        <h3 style="color:#ffc107;margin-bottom:15px;">📋 How to Increase Winning Amount:</h3>-->
    <!--        <ul style="color:#fff;line-height:1.8;margin-left:20px;">-->
    <!--            <li>Play color prediction games and win</li>-->
    <!--            <li>Each winning bet adds to your winning amount</li>-->
    <!--            <li>Winning amount is separate from recharge amount</li>-->
    <!--            <li>Only winning amount can be withdrawn</li>-->
    <!--        </ul>-->
    <!--    </div>-->
    <!--</div>-->
</div>

<script>
function updateAccountFields(method) {
    const bankFields = document.getElementById('bankFields');
    const otherAccountField = document.getElementById('otherAccountField');
    const label = document.getElementById('account_label');
    const textarea = document.getElementById('account_details');
    const help = document.getElementById('account_help');
    
    // Hide all fields first
    bankFields.style.display = 'none';
    otherAccountField.style.display = 'none';
    
    // Clear required attributes
    const bankInputs = bankFields.querySelectorAll('input');
    bankInputs.forEach(input => input.removeAttribute('required'));
    textarea.removeAttribute('required');
    
    switch(method) {
        case 'bank_transfer':
            bankFields.style.display = 'block';
            // Make bank fields required
            bankInputs.forEach(input => input.setAttribute('required', 'required'));
            break;
            
        case 'upi':
            otherAccountField.style.display = 'block';
            label.textContent = 'UPI ID';
            textarea.placeholder = 'Enter your UPI ID (e.g., yourname@paytm)';
            help.textContent = 'Provide your valid UPI ID';
            textarea.setAttribute('required', 'required');
            break;
            
        case 'paytm':
            otherAccountField.style.display = 'block';
            label.textContent = 'Paytm Mobile Number';
            textarea.placeholder = 'Enter your Paytm registered mobile number';
            help.textContent = 'Provide your Paytm registered mobile number';
            textarea.setAttribute('required', 'required');
            break;
            
        case 'phonepe':
            otherAccountField.style.display = 'block';
            label.textContent = 'PhonePe Mobile Number';
            textarea.placeholder = 'Enter your PhonePe registered mobile number';
            help.textContent = 'Provide your PhonePe registered mobile number';
            textarea.setAttribute('required', 'required');
            break;
    }
}

// Auto-uppercase IFSC code
document.addEventListener('DOMContentLoaded', function() {
    const ifscInput = document.querySelector('input[name="ifsc_code"]');
    if(ifscInput) {
        ifscInput.addEventListener('input', function() {
            this.value = this.value.toUpperCase();
        });
    }
});
</script>

<?php include("includes/footer.php"); ?>