<?php
$page_title = "Recharge Wallet";
include("includes/header.php");

// Handle recharge request
if(isset($_POST['recharge_request'])) {
    $amount = (float)$_POST['amount'];
    $method = mysqli_real_escape_string($conn, $_POST['method']);
    
    if($amount >= 10) {
        // Get user mobile number (stored in email column)
        $user_data = mysqli_fetch_assoc(mysqli_query($conn, "SELECT email FROM users WHERE id=$user_id"));
        $mobile = $user_data['email'];
        
        // Generate unique transaction ID
        $txn_id = "TXN" . time() . rand(1000, 9999);
        
        // User token (you can customize this)
        $user_token = "USER_" . $user_id . "_" . md5($mobile);
        
        // Original amount (no bonus calculation here)
        $amount_numeric = $amount;
        
        // Cloudflare Worker API URL
        $api_url = "https://worki1.swatantranews2.workers.dev/";
        
        // ध्यान दो: यहाँ हम original amount भेज रहे हैं, bonus नहीं
        $payload = http_build_query([
            "customer_mobile" => $mobile,
            "user_token"      => "2585813402611df7245b2b88da612d4b",
            "amount"          => $amount_numeric, // original only
            "order_id"        => $txn_id,
            "redirect_url"    => "https://playvipking.com/successful.php",
            "remark1"         => "",
            "remark2"         => ""
        ]);
        
        $ch = curl_init($api_url);
        curl_setopt_array($ch, [
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => $payload,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CONNECTTIMEOUT => 15,
            CURLOPT_TIMEOUT        => 30,
            CURLOPT_HTTPHEADER     => ["Content-Type: application/x-www-form-urlencoded"],
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        
        $response = curl_exec($ch);
        $curl_error = curl_error($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        // Log full response for debugging
        error_log("=== PAYMENT API DEBUG ===");
        error_log("API URL: " . $api_url);
        error_log("HTTP Code: " . $http_code);
        error_log("Curl Error: " . $curl_error);
        error_log("Raw Response: " . $response);
        error_log("========================");
        
        // Handle API response
        if($curl_error) {
            $error_msg = "Connection error: " . $curl_error;
        } elseif($http_code != 200) {
            $error_msg = "API error: HTTP " . $http_code . " - Response: " . substr($response, 0, 200);
        } else {
            // Try to parse response as JSON
            $response_data = json_decode($response, true);
            
            // Check if response is valid JSON
            if(json_last_error() !== JSON_ERROR_NONE) {
                // Not JSON, maybe it's direct URL or HTML
                error_log("JSON Parse Error: " . json_last_error_msg());
                
                // Check if response looks like a URL
                if(filter_var($response, FILTER_VALIDATE_URL)) {
                    // Save transaction to database
                    mysqli_query($conn, "
                        INSERT INTO recharge_requests (user_id, amount, method, status, txn_id, created_at) 
                        VALUES ($user_id, $amount, '$method', 'pending', '$txn_id', NOW())
                    ");
                    
                    // Direct URL redirect
                    header("Location: " . $response);
                    exit;
                } else {
                    // Show raw response for debugging
                    $error_msg = "Invalid API response format. Raw response: <br><pre>" . htmlspecialchars(substr($response, 0, 500)) . "</pre>";
                }
            } elseif($response_data && isset($response_data['result']['payment_url'])) {
                // ✅ CORRECT FORMAT: result.payment_url (Your API format)
                // Save transaction to database
                mysqli_query($conn, "
                    INSERT INTO recharge_requests (user_id, amount, method, status, txn_id, created_at) 
                    VALUES ($user_id, $amount, '$method', 'pending', '$txn_id', NOW())
                ");
                
                // Redirect to payment URL
                header("Location: " . $response_data['result']['payment_url']);
                exit;
            } elseif($response_data && isset($response_data['payment_url'])) {
                // Alternative: Direct payment_url
                mysqli_query($conn, "
                    INSERT INTO recharge_requests (user_id, amount, method, status, txn_id, created_at) 
                    VALUES ($user_id, $amount, '$method', 'pending', '$txn_id', NOW())
                ");
                
                header("Location: " . $response_data['payment_url']);
                exit;
            } elseif($response_data && isset($response_data['url'])) {
                // Alternative: url key
                mysqli_query($conn, "
                    INSERT INTO recharge_requests (user_id, amount, method, status, txn_id, created_at) 
                    VALUES ($user_id, $amount, '$method', 'pending', '$txn_id', NOW())
                ");
                
                header("Location: " . $response_data['url']);
                exit;
            } elseif($response_data && isset($response_data['data']['payment_url'])) {
                // Alternative: data.payment_url
                mysqli_query($conn, "
                    INSERT INTO recharge_requests (user_id, amount, method, status, txn_id, created_at) 
                    VALUES ($user_id, $amount, '$method', 'pending', '$txn_id', NOW())
                ");
                
                header("Location: " . $response_data['data']['payment_url']);
                exit;
            } else {
                // Show full response structure for debugging
                $error_msg = "Payment gateway error. API Response: <br><pre>" . htmlspecialchars(print_r($response_data, true)) . "</pre><br>Raw: <pre>" . htmlspecialchars(substr($response, 0, 500)) . "</pre>";
            }
        }
    } else {
        $error_msg = "Minimum recharge amount is ₹10";
    }
}

// Create recharge_requests table if not exists
mysqli_query($conn, "
    CREATE TABLE IF NOT EXISTS recharge_requests (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        amount DECIMAL(10,2) NOT NULL,
        method VARCHAR(50) NOT NULL,
        status ENUM('pending','approved','completed','failed') DEFAULT 'pending',
        txn_id VARCHAR(100) DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id)
    )
");
?>

<div class="container">
    <?php if(isset($success_msg)): ?>
        <div class="card" style="background:rgba(39,174,96,0.2);border-color:#27ae60;">
            <p style="color:#27ae60;font-weight:600;">✅ <?= $success_msg ?></p>
        </div>
    <?php endif; ?>
    
    <?php if(isset($error_msg)): ?>
        <div class="card" style="background:rgba(231,76,60,0.2);border-color:#e74c3c;">
            <p style="color:#e74c3c;font-weight:600;">❌ <?= $error_msg ?></p>
        </div>
    <?php endif; ?>

    <!-- Current Balance -->
    <div class="content-box">
        <h2 class="section-title">💰 Current Balance</h2>
        <div style="text-align:center;padding:20px;">
            <div style="font-size:48px;font-weight:700;color:#ffd700;text-shadow:0 2px 10px rgba(255,215,0,0.3);">
                ₹<?= number_format($user['wallet'], 2) ?>
            </div>
            <p style="opacity:0.8;margin-top:10px;">Available for betting</p>
        </div>
    </div>

    <!-- Recharge Form -->
    <div class="content-box">
        <h2 class="section-title">💳 Add Money to Wallet</h2>
        
        <form method="POST">
            <div class="form-group">
                <label class="form-label">Recharge Amount</label>
                <input type="number" name="amount" class="form-input" placeholder="Enter amount (Min: ₹10)" min="10" step="0.01" required>
            </div>
            
            <div class="form-group">
                <label class="form-label">Payment Method</label>
                <select name="method" class="form-input" required>
                    <option value="">Select Payment Method</option>
                    <option value="upi">UPI Payment</option>
                    <option value="netbanking">Net Banking</option>
                    <option value="card">Credit/Debit Card</option>
                    <option value="wallet">Digital Wallet</option>
                </select>
            </div>
            
            <!-- Quick Amount Buttons -->
            <div style="margin:20px 0;">
                <p class="form-label">Quick Select:</p>
                <div style="display:flex;gap:10px;flex-wrap:wrap;">
                    <button type="button" class="btn btn-secondary" onclick="setAmount(100)">₹100</button>
                    <button type="button" class="btn btn-secondary" onclick="setAmount(500)">₹500</button>
                    <button type="button" class="btn btn-secondary" onclick="setAmount(1000)">₹1000</button>
                    <button type="button" class="btn btn-secondary" onclick="setAmount(2000)">₹2000</button>
                    <button type="button" class="btn btn-secondary" onclick="setAmount(5000)">₹5000</button>
                </div>
            </div>
            
            <button type="submit" name="recharge_request" class="btn" style="width:100%;justify-content:center;">
                💰 Proceed to Payment
            </button>
        </form>
    </div>

    <!-- Recharge History -->
    <div class="content-box">
        <h2 class="section-title">📋 Recent Recharge History</h2>
        
        <?php
        $recharge_history = mysqli_query($conn, "
            SELECT * FROM recharge_requests 
            WHERE user_id=$user_id 
            ORDER BY created_at DESC 
            LIMIT 10
        ");
        
        if($recharge_history && mysqli_num_rows($recharge_history) > 0):
        ?>
            <table class="table recharge-history-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = mysqli_fetch_assoc($recharge_history)): ?>
                        <tr>
                            <td><?= date('M j, Y H:i', strtotime($row['created_at'])) ?></td>
                            <td style="font-weight:700;color:#ffd700;">₹<?= number_format($row['amount'], 2) ?></td>
                            <td><?= ucfirst($row['method']) ?></td>
                            <td>
                                <span class="status <?= $row['status'] ?>">
                                    <?= ucfirst($row['status']) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="empty-state">
                <div class="empty-state-icon">💳</div>
                <div class="empty-state-title">No Recharge History</div>
                <div class="empty-state-text">Your recharge transactions will appear here</div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Payment Info -->
    <!--<div class="content-box">-->
    <!--    <h2 class="section-title">ℹ️ Payment Information</h2>-->
        
    <!--    <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;">-->
    <!--        <div class="card">-->
    <!--            <h3 style="color:#27ae60;margin-bottom:10px;">✅ Instant Processing</h3>-->
    <!--            <p>Most payments are processed instantly and credited to your wallet immediately.</p>-->
    <!--        </div>-->
            
    <!--        <div class="card">-->
    <!--            <h3 style="color:#3498db;margin-bottom:10px;">🔒 Secure Payments</h3>-->
    <!--            <p>All transactions are secured with bank-grade encryption and security protocols.</p>-->
    <!--        </div>-->
            
    <!--        <div class="card">-->
    <!--            <h3 style="color:#f39c12;margin-bottom:10px;">💰 Minimum Amount</h3>-->
    <!--            <p>Minimum recharge amount is ₹10. No maximum limit on recharge amounts.</p>-->
    <!--        </div>-->
            
    <!--        <div class="card">-->
    <!--            <h3 style="color:#9b59b6;margin-bottom:10px;">📞 Support</h3>-->
    <!--            <p>Contact support if your payment is not credited within 24 hours.</p>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
</div>

<script>
function setAmount(amount) {
    document.querySelector('input[name="amount"]').value = amount;
}
</script>

<?php include("includes/footer.php"); ?>
