<?php
$page_title = "My Profile";
include("includes/header.php");

// Handle profile update
if(isset($_POST['update_profile'])) {
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $mobile = mysqli_real_escape_string($conn, $_POST['mobile']);
    
    // Validate mobile number
    if(!preg_match('/^[0-9]{10}$/', $mobile)){
        $error_msg = "Please enter a valid 10-digit mobile number";
    } else {
        // Check if mobile number already exists (excluding current user)
        $check = mysqli_query($conn, "SELECT id FROM users WHERE email='$mobile' AND id != $user_id");
        if(mysqli_num_rows($check) > 0) {
            $error_msg = "Mobile number already registered with another account";
        } else {
            // Update user profile (store mobile in email column)
            $update = mysqli_query($conn, "UPDATE users SET name='$name', email='$mobile' WHERE id=$user_id");
            
            if($update) {
                $success_msg = "Profile updated successfully!";
                $user['name'] = $name;
                $user['email'] = $mobile;
            } else {
                $error_msg = "Failed to update profile!";
            }
        }
    }
}

// Handle password change
if(isset($_POST['change_password'])) {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];
    
    if($new_password === $confirm_password) {
        if($current_password === $user['password']) { // Simple check
            $update_pwd = mysqli_query($conn, "UPDATE users SET password='$new_password' WHERE id=$user_id");
            if($update_pwd) {
                $success_msg = "Password changed successfully!";
            } else {
                $error_msg = "Failed to change password!";
            }
        } else {
            $error_msg = "Current password is incorrect!";
        }
    } else {
        $error_msg = "New passwords don't match!";
    }
}
?>

<div class="container">
    <?php if(isset($success_msg)): ?>
        <div class="card" style="background:rgba(39,174,96,0.2);border-color:#27ae60;">
            <p style="color:#27ae60;font-weight:600;">✅ <?= $success_msg ?></p>
        </div>
    <?php endif; ?>
    
    <?php if(isset($error_msg)): ?>
        <div class="card" style="background:rgba(231,76,60,0.2);border-color:#e74c3c;">
            <p style="color:#e74c3c;font-weight:600;">❌ <?= $error_msg ?></p>
        </div>
    <?php endif; ?>

    <!-- Profile Information -->
    <div class="content-box">
        <h2 class="section-title">👤 Profile Information</h2>
        
        <form method="POST">
            <div class="form-group">
                <label class="form-label">Full Name</label>
                <input type="text" name="name" class="form-input" value="<?= htmlspecialchars($user['name']) ?>" required>
            </div>
            
            <div class="form-group">
                <label class="form-label">Mobile Number</label>
                <input type="tel" name="mobile" class="form-input" 
                       value="<?= htmlspecialchars($user['email']) ?>" 
                       pattern="[0-9]{10}" maxlength="10" required>
                <small style="color:rgba(255,255,255,0.7);">Enter 10-digit mobile number</small>
            </div>
            
            <div class="form-group">
                <label class="form-label">User ID</label>
                <input type="text" class="form-input" value="<?= $user['id'] ?>" readonly style="opacity:0.7;">
            </div>
            
            <div class="form-group">
                <label class="form-label">Member Since</label>
                <input type="text" class="form-input" value="<?= date('M j, Y', strtotime($user['created_at'])) ?>" readonly style="opacity:0.7;">
            </div>
            
            <button type="submit" name="update_profile" class="btn">
                💾 Update Profile
            </button>
        </form>
    </div>

    <!-- Change Password -->
    <div class="content-box">
        <h2 class="section-title">🔒 Change Password</h2>
        
        <form method="POST">
            <div class="form-group">
                <label class="form-label">Current Password</label>
                <input type="password" name="current_password" class="form-input" required>
            </div>
            
            <div class="form-group">
                <label class="form-label">New Password</label>
                <input type="password" name="new_password" class="form-input" required>
            </div>
            
            <div class="form-group">
                <label class="form-label">Confirm New Password</label>
                <input type="password" name="confirm_password" class="form-input" required>
            </div>
            
            <button type="submit" name="change_password" class="btn">
                🔑 Change Password
            </button>
        </form>
    </div>

    <!-- Account Stats -->
    <div class="content-box">
        <h2 class="section-title">📊 Account Statistics</h2>
        
        <?php
        $stats = mysqli_fetch_assoc(mysqli_query($conn, "
            SELECT 
                COUNT(*) as total_bets,
                SUM(CASE WHEN status='win' THEN 1 ELSE 0 END) as total_wins,
                SUM(CASE WHEN status='loss' THEN 1 ELSE 0 END) as total_losses,
                SUM(amount) as total_wagered,
                SUM(win_amount) as total_winnings
            FROM bets WHERE user_id=$user_id
        "));
        
        // Handle null values from SQL
        $total_bets = $stats['total_bets'] ?? 0;
        $total_wins = $stats['total_wins'] ?? 0;
        $total_losses = $stats['total_losses'] ?? 0;
        $total_wagered = $stats['total_wagered'] ?? 0;
        $total_winnings = $stats['total_winnings'] ?? 0;
        
        $win_rate = $total_bets > 0 ? round(($total_wins / $total_bets) * 100, 1) : 0;
        ?>
        
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:20px;">
            <div class="card">
                <h3 style="color:#ffd700;margin-bottom:10px;">🎯 Total Bets</h3>
                <p style="font-size:24px;font-weight:700;"><?= number_format($total_bets) ?></p>
            </div>
            
            <div class="card">
                <h3 style="color:#27ae60;margin-bottom:10px;">✅ Wins</h3>
                <p style="font-size:24px;font-weight:700;color:#27ae60;"><?= number_format($total_wins) ?></p>
            </div>
            
            <div class="card">
                <h3 style="color:#e74c3c;margin-bottom:10px;">❌ Losses</h3>
                <p style="font-size:24px;font-weight:700;color:#e74c3c;"><?= number_format($total_losses) ?></p>
            </div>
            
            <div class="card">
                <h3 style="color:#3498db;margin-bottom:10px;">📈 Win Rate</h3>
                <p style="font-size:24px;font-weight:700;color:#3498db;"><?= $win_rate ?>%</p>
            </div>
            
            <div class="card">
                <h3 style="color:#9b59b6;margin-bottom:10px;">💰 Total Wagered</h3>
                <p style="font-size:20px;font-weight:700;color:#9b59b6;">₹<?= number_format($total_wagered, 2) ?></p>
            </div>
            
            <div class="card">
                <h3 style="color:#f39c12;margin-bottom:10px;">🏆 Total Winnings</h3>
                <p style="font-size:20px;font-weight:700;color:#f39c12;">₹<?= number_format($total_winnings, 2) ?></p>
            </div>
        </div>
    </div>
</div>

<?php include("includes/footer.php"); ?>