<?php
include("../config/db.php");
include("../config/session_user.php");

// Prevent caching
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

// Agar already login hai to dashboard bhej do
if(isset($_SESSION['user_id'])){
    header("Location: dashboard.php");
    exit;
}

$msg = "";

// Check for logout message
if(isset($_GET['logout'])){
    $msg = "<span style='color:green;'>✅ Successfully logged out!</span>";
}

if(isset($_POST['login'])){
    $mobile   = mysqli_real_escape_string($conn, $_POST['mobile']);
    $password = mysqli_real_escape_string($conn, $_POST['password']);

    // Validate mobile number format
    if(!preg_match('/^[0-9]{10}$/', $mobile)){
        $msg = "<span style='color:red;'>Please enter a valid 10-digit mobile number</span>";
    } else {
        // Search by mobile number (stored in email column)
        $query = mysqli_query($conn,
            "SELECT * FROM users WHERE email='$mobile' AND password='$password'"
        );

        if(mysqli_num_rows($query) == 1){
            $row = mysqli_fetch_assoc($query);

            // Set session
            $_SESSION['user_id']   = $row['id'];
            $_SESSION['user_name'] = $row['name'];
            
            // Set permanent cookies (1 year)
            setcookie('user_id_permanent', $row['id'], time() + (86400 * 365), '/');
            setcookie('user_name_permanent', $row['name'], time() + (86400 * 365), '/');

            header("Location: dashboard.php");
            exit;
        } else {
            $msg = "<span style='color:red;'>Invalid mobile number or password</span>";
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Login</title>
    <style>
        body{font-family:Arial;background:#f2f2f2;text-align:center;margin:0;padding:20px;}
        .box{margin-top:80px;background:#fff;padding:25px;display:inline-block;border-radius:10px;max-width:400px;width:100%;box-sizing:border-box;}
        input,button{margin:8px;padding:10px;width:250px;max-width:100%;box-sizing:border-box;}
        button{background:#007bff;color:#fff;border:none;border-radius:5px;cursor:pointer;}
        button:hover{background:#0056b3;}
        .msg{color:red;}
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            body{padding:10px;}
            .box{margin-top:20px;padding:20px;width:95%;}
            input,button{width:100%;font-size:16px;padding:12px;margin:5px 0;}
            h2{font-size:24px;}
        }
        
        @media (max-width: 480px) {
            .box{margin-top:10px;padding:15px;}
            input,button{padding:14px;font-size:16px;}
            h2{font-size:20px;}
        }
    </style>
</head>
<body>

<div class="box">
    <h2>User Login</h2>

    <form method="post">
        <input type="tel" name="mobile" placeholder="Mobile Number (10 digits)" pattern="[0-9]{10}" maxlength="10" required><br>
        <input type="password" name="password" placeholder="Password" required><br>
        <button name="login">Login</button>
    </form>

    <div class="msg"><?php echo $msg; ?></div>

    <p>New user? <a href="register.php">Register</a></p>
    <p><a href="../index.php">Home</a></p>
</div>

</body>
</html>
