<?php

include("../config/db.php");
include("../config/session_user.php");

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}



/* LATEST 6 RESULTS */
// $results = mysqli_query($conn,"
//     SELECT winning_color 
//     FROM games 
//     WHERE status='completed'
//       AND winning_color IS NOT NULL
//     ORDER BY id DESC
//     LIMIT 6
// ");




$user_id = (int)$_SESSION['user_id'];

/* ================= ONE SOURCE OF TRUTH ================= */
function getRunningGameId($conn){
    $g = mysqli_fetch_assoc(mysqli_query($conn,"
        SELECT id FROM games 
        WHERE status='running' 
        ORDER BY id DESC 
        LIMIT 1
    "));
    if(!$g){
        mysqli_query($conn,"INSERT INTO games(status,created_at) VALUES('running',NOW())");
        return mysqli_insert_id($conn);
    }
    return (int)$g['id'];
}

$user = mysqli_fetch_assoc(mysqli_query($conn,"SELECT wallet FROM users WHERE id=$user_id"));

/* ================= GET LATEST RESULTS WITH TIMING ================= */
// Get latest 10 completed games with their winning colors and timing
$recent_results = mysqli_query($conn, "
    SELECT winning_color, completed_at, id,
           TIMESTAMPDIFF(MINUTE, completed_at, NOW()) as minutes_diff,
           TIMESTAMPDIFF(SECOND, completed_at, NOW()) as seconds_diff
    FROM games 
    WHERE status='completed' 
      AND winning_color IS NOT NULL 
      AND winning_color != ''
    ORDER BY completed_at DESC 
    LIMIT 10
");

$history_results = [];
if($recent_results && mysqli_num_rows($recent_results) > 0){
    while($result = mysqli_fetch_assoc($recent_results)){
        $color = trim($result['winning_color']);
        if(!empty($color)){
            // Calculate time ago using database calculation
            $minutes = (int)$result['minutes_diff'];
            $seconds = (int)$result['seconds_diff'];
            
            if($seconds < 60) {
                $time_ago = 'Just now';
            } else if($minutes < 60) {
                $time_ago = $minutes . 'm ago';
            } else if($minutes < 1440) { // less than 24 hours
                $hours = floor($minutes / 60);
                $remaining_mins = $minutes % 60;
                if($remaining_mins > 0) {
                    $time_ago = $hours . 'h ' . $remaining_mins . 'm ago';
                } else {
                    $time_ago = $hours . 'h ago';
                }
            } else {
                $days = floor($minutes / 1440);
                $time_ago = $days . 'd ago';
            }
            
            $history_results[] = [
                'id' => $result['id'],
                'color' => $color,
                'time' => $result['completed_at'],
                'time_ago' => $time_ago,
                'minutes_diff' => $minutes,
                'seconds_diff' => $seconds
            ];
        }
    }
}

// Debug: Check what we have in database
$total_games = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as total FROM games"));
$completed_games = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as completed FROM games WHERE status='completed'"));
$completed_with_winner = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as with_winner FROM games WHERE status='completed' AND winning_color IS NOT NULL AND winning_color != ''"));

// Get recent game results

// If no results, create some test data with varied timing
if(empty($history_results)) {
    error_log("No results found, creating test data...");
    
    $test_colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];
    
    // Create 10 test completed games with different times
    for($i = 0; $i < 10; $i++) {
        $winner = $test_colors[array_rand($test_colors)];
        $minutes_ago = ($i + 1) * 15; // 15, 30, 45, 60, 75... minutes ago
        
        mysqli_query($conn, "
            INSERT INTO games (status, winning_color, created_at, completed_at) 
            VALUES (
                'completed', 
                '$winner', 
                NOW() - INTERVAL $minutes_ago MINUTE, 
                NOW() - INTERVAL $minutes_ago MINUTE
            )
        ");
    }
    
    // Re-fetch results after creating test data with proper calculation
    $recent_results = mysqli_query($conn, "
        SELECT winning_color, completed_at, id,
               TIMESTAMPDIFF(MINUTE, completed_at, NOW()) as minutes_diff,
               TIMESTAMPDIFF(SECOND, completed_at, NOW()) as seconds_diff
        FROM games 
        WHERE status='completed' 
          AND winning_color IS NOT NULL 
          AND winning_color != ''
        ORDER BY completed_at DESC 
        LIMIT 10
    ");
    
    $history_results = [];
    if($recent_results && mysqli_num_rows($recent_results) > 0){
        while($result = mysqli_fetch_assoc($recent_results)){
            $color = trim($result['winning_color']);
            if(!empty($color)){
                // Calculate time ago using database calculation
                $minutes = (int)$result['minutes_diff'];
                $seconds = (int)$result['seconds_diff'];
                
                if($seconds < 60) {
                    $time_ago = 'Just now';
                } else if($minutes < 60) {
                    $time_ago = $minutes . 'm ago';
                } else if($minutes < 1440) {
                    $hours = floor($minutes / 60);
                    $remaining_mins = $minutes % 60;
                    if($remaining_mins > 0) {
                        $time_ago = $hours . 'h ' . $remaining_mins . 'm ago';
                    } else {
                        $time_ago = $hours . 'h ago';
                    }
                } else {
                    $days = floor($minutes / 1440);
                    $time_ago = $days . 'd ago';
                }
                
                $history_results[] = [
                    'id' => $result['id'],
                    'color' => $color,
                    'time' => $result['completed_at'],
                    'time_ago' => $time_ago,
                    'minutes_diff' => $minutes,
                    'seconds_diff' => $seconds
                ];
            }
        }
    }
    
    // Test data created
}

// Get the very latest result for popup (if within last 5 minutes)
$latest_popup_result = null;
if(!empty($history_results)) {
    $latest = $history_results[0];
    $time_diff = time() - strtotime($latest['time']);
    
    // Show popup if result is within last 5 minutes (300 seconds)
    if($time_diff <= 300) {
        $latest_popup_result = $latest;
    }
}

// Function to calculate time ago
function time_elapsed_string($datetime) {
    $time = time() - strtotime($datetime);
    
    // Debug logging
    error_log("Time calculation: datetime=$datetime, current_time=" . time() . ", past_time=" . strtotime($datetime) . ", diff=$time seconds");
    
    if ($time < 60) return 'Just now';
    if ($time < 3600) return floor($time/60) . 'm ago';
    if ($time < 86400) return floor($time/3600) . 'h ago';
    if ($time < 2592000) return floor($time/86400) . 'd ago';
    
    return date('M j', strtotime($datetime));
}

// Display results
?>
<!DOCTYPE html>
<html>
<head>
<title>User Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    color: #fff;
    overflow-x: hidden;
}

/* ANIMATED BACKGROUND */
body::before {
    content: '';
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: 
        radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.3) 0%, transparent 50%),
        radial-gradient(circle at 40% 40%, rgba(120, 219, 255, 0.2) 0%, transparent 50%);
    z-index: -1;
    animation: backgroundShift 20s ease-in-out infinite;
}

@keyframes backgroundShift {
    0%, 100% { transform: translateX(0) translateY(0); }
    25% { transform: translateX(-20px) translateY(-10px); }
    50% { transform: translateX(10px) translateY(-20px); }
    75% { transform: translateX(-10px) translateY(10px); }
}

/* TOP BAR */
.topbar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px 25px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-bottom: 1px solid rgba(255, 255, 255, 0.2);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
}

.uid {
    font-size: 14px;
    opacity: 0.9;
    display: flex;
    align-items: center;
    gap: 8px;
}

.balance {
    font-size: 24px;
    font-weight: 700;
    color: #ffd700;
    text-shadow: 0 2px 10px rgba(255, 215, 0, 0.3);
    display: flex;
    align-items: center;
    gap: 8px;
}

/* MENU GRID */
.menu {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 20px;
    padding: 30px 25px;
    max-width: 1200px;
    margin: 0 auto;
}

.card {
    background: rgba(255, 255, 255, 0.15);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 25px 20px;
    text-align: center;
    cursor: pointer;
    transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    border: 1px solid rgba(255, 255, 255, 0.2);
    position: relative;
    overflow: hidden;
}

.card::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}

.card:hover::before {
    left: 100%;
}

.card:hover {
    transform: translateY(-8px) scale(1.02);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
    border-color: rgba(255, 255, 255, 0.4);
}

.card span {
    font-size: 40px;
    display: block;
    margin-bottom: 12px;
    filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.3));
}

.card p {
    margin: 0;
    font-size: 16px;
    font-weight: 600;
    opacity: 0.9;
}

/* RESULTS SECTION */
.section {
    margin: 25px;
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 25px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
}

.section h3 {
    margin: 0 0 20px;
    color: #fff;
    font-size: 20px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 10px;
}

.results {
    display: flex;
    gap: 15px;
    flex-wrap: wrap;
    align-items: center;
}

.result-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 8px;
    padding: 15px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 15px;
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: all 0.3s ease;
    min-width: 100px;
}

.result-item:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
}

.ball {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 12px;
    text-transform: uppercase;
    color: #fff;
    text-shadow: 0 1px 3px rgba(0, 0, 0, 0.5);
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
    animation: pulse 2s ease-in-out infinite;
}

.time-info {
    font-size: 11px;
    opacity: 0.8;
    text-align: center;
    color: #fff;
    font-weight: 500;
}

/* COLORS */
.red { background: linear-gradient(135deg, #ff6b6b, #ee5a52); }
.green { background: linear-gradient(135deg, #51cf66, #40c057); }
.yellow { background: linear-gradient(135deg, #ffd43b, #fab005); color: #000; }
.blue { background: linear-gradient(135deg, #339af0, #228be6); }
.purple { background: linear-gradient(135deg, #b197fc, #9775fa); }
.orange { background: linear-gradient(135deg, #ff922b, #fd7e14); }
.pink { background: linear-gradient(135deg, #f783ac, #e64980); }
.cyan { background: linear-gradient(135deg, #3bc9db, #22b8cf); }

/* HELP CARD STYLING */
.card.help {
    background: linear-gradient(135deg, #17a2b8, #138496);
    border: 2px solid rgba(23, 162, 184, 0.3);
}
.card.help:hover {
    background: linear-gradient(135deg, #138496, #117a8b);
    transform: translateY(-5px);
}

/* ANIMATIONS */
@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

@keyframes slideIn {
    0% {
        opacity: 0;
        transform: translateX(-30px) scale(0.8);
    }
    100% {
        opacity: 1;
        transform: translateX(0) scale(1);
    }
}

@keyframes slideOut {
    0% {
        opacity: 1;
        transform: translateX(0) scale(1);
    }
    100% {
        opacity: 0;
        transform: translateX(30px) scale(0.8);
    }
}

.result-item.new-result {
    animation: slideIn 0.6s ease;
}

.result-item.removing {
    animation: slideOut 0.6s ease;
}

/* LOGOUT BUTTON */
.logout {
    display: block;
    margin: 25px;
    padding: 18px;
    text-align: center;
    background: linear-gradient(135deg, #ff6b6b, #ee5a52);
    color: #fff;
    border-radius: 15px;
    text-decoration: none;
    font-weight: 700;
    font-size: 16px;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
}

.logout:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(255, 107, 107, 0.4);
}

/* MOBILE RESPONSIVE */
@media (max-width: 768px) {
    .topbar {
        padding: 15px 20px;
    }
    
    .balance {
        font-size: 20px;
    }
    
    .menu {
        grid-template-columns: repeat(2, 1fr);
        gap: 15px;
        padding: 20px;
    }
    
    .card {
        padding: 20px 15px;
    }
    
    .card span {
        font-size: 32px;
    }
    
    .card p {
        font-size: 14px;
    }
    
    .section {
        margin: 15px;
        padding: 20px;
    }
    
    .results {
        gap: 10px;
    }
    
    .result-item {
        min-width: 80px;
        padding: 12px;
    }
    
    .ball {
        width: 40px;
        height: 40px;
        font-size: 10px;
    }
}

@media (max-width: 480px) {
    .menu {
        grid-template-columns: 1fr 1fr;
        gap: 12px;
        padding: 15px;
    }
    
    .card {
        padding: 15px 10px;
    }
    
    .card span {
        font-size: 28px;
    }
    
    .card p {
        font-size: 12px;
    }
    
    .section h3 {
        font-size: 18px;
    }
    
    .result-item {
        min-width: 70px;
        padding: 10px;
    }
    
    .ball {
        width: 35px;
        height: 35px;
        font-size: 9px;
    }
    
    .time-info {
        font-size: 10px;
    }
}

/* NO RESULTS MESSAGE */
.no-results {
    text-align: center;
    padding: 30px;
    color: rgba(255, 255, 255, 0.7);
    font-size: 16px;
    font-style: italic;
}

/* LOADING ANIMATION */
.loading {
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-radius: 50%;
    border-top-color: #fff;
    animation: spin 1s ease-in-out infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* LATEST RESULT POPUP */
.latest-result-popup {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.8);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    backdrop-filter: blur(10px);
}

.popup-content {
    background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), rgba(255, 255, 255, 0.1));
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 30px;
    text-align: center;
    border: 1px solid rgba(255, 255, 255, 0.3);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
    max-width: 400px;
    width: 90%;
    animation: popupSlideIn 0.5s ease;
}

@keyframes popupSlideIn {
    0% {
        opacity: 0;
        transform: translateY(-50px) scale(0.8);
    }
    100% {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.popup-title {
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 20px;
    color: #ffd700;
    text-shadow: 0 2px 10px rgba(255, 215, 0, 0.3);
}

.popup-result {
    margin: 20px 0;
}

.popup-ball {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    font-size: 16px;
    text-transform: uppercase;
    color: #fff;
    text-shadow: 0 2px 5px rgba(0, 0, 0, 0.5);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
    margin: 0 auto 15px;
    animation: popupPulse 2s ease-in-out infinite;
}

@keyframes popupPulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

.popup-time {
    font-size: 14px;
    opacity: 0.8;
    margin-bottom: 20px;
}

.popup-close {
    background: linear-gradient(135deg, #ffd700, #ffb700);
    color: #000;
    border: none;
    padding: 12px 25px;
    border-radius: 10px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 14px;
}

.popup-close:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 215, 0, 0.4);
}

/* Mobile popup adjustments */
@media (max-width: 480px) {
    .popup-content {
        padding: 20px;
        margin: 10px;
    }
    
    .popup-title {
        font-size: 20px;
    }
    
    .popup-ball {
        width: 60px;
        height: 60px;
        font-size: 14px;
    }
}

/* LOADING ANIMATION */
.loading {
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 3px solid rgba(255, 255, 255, 0.3);
    border-radius: 50%;
    border-top-color: #fff;
    animation: spin 1s ease-in-out infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
</style>
</head>

<body>

<!-- TOP BAR -->
<div class="topbar">
 <div class="uid">👤 User ID: <?= $user_id ?></div>
 <div class="balance">₹ <?= $user['wallet'] ?></div>
</div>

<!-- MENU -->
<div class="menu">

 <div class="card play" onclick="go('game.php')">
 <span>🎮</span>
 <p>Play Game</p>
</div>


<div class="card recharge" onclick="go('recharge.php')">
 <span>💳</span><p>Recharge</p>
</div>

<div class="card withdraw" onclick="go('withdraw.php')">
 <span>🏧</span><p>Withdraw</p>
</div>

<div class="card profile" onclick="go('profile.php')">
 <span>👤</span><p>Profile</p>
</div>

<div class="card notice" onclick="go('notice.php')">
 <span>📢</span><p>Notice</p>
</div>

<div class="card game" onclick="go('game_history.php')">
 <span>📊</span><p>Game History</p>
</div>

<div class="card result" onclick="go('result_history.php')">
 <span>🏆</span><p>Result History</p>
</div>

<div class="card wallet" onclick="go('wallet_history.php')">
 <span>💼</span><p>Wallet History</p>
</div>

<div class="card help" onclick="openWhatsAppHelp()">
 <span>❓</span><p>Need Help</p>
</div>


</div>

<!-- LAST RESULTS -->
<!-- LATEST RESULTS BOX -->
<div class="section">
  <h3>🎯 Latest 10 Results</h3>
  
  <div class="results" id="resultsContainer">
    <?php if(!empty($history_results)): ?>
      <?php foreach($history_results as $result): ?>
        <div class="result-item" data-time="<?= $result['time'] ?>" data-id="<?= $result['id'] ?>">
          <div class="ball <?= strtolower($result['color']) ?>">
            <?= strtoupper($result['color']) ?>
          </div>
          <div class="time-info">
            <?= $result['time_ago'] ?>
          </div>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <div class="no-results">
        <div class="loading"></div>
        <p>Loading results...</p>
      </div>
    <?php endif; ?>
  </div>
</div>


<!-- LOGOUT -->
<a href="logout.php" class="logout">🚪 Logout</a>

<!-- LATEST RESULT POPUP -->
<?php if($latest_popup_result): ?>
<div class="latest-result-popup" id="latestResultPopup">
  <div class="popup-content">
    <div class="popup-title">🎉 Latest Result!</div>
    <div class="popup-result">
      <div class="popup-ball <?= strtolower($latest_popup_result['color']) ?>">
        <?= strtoupper($latest_popup_result['color']) ?>
      </div>
      <div class="popup-time">
        Result came <?= $latest_popup_result['time_ago'] ?>
      </div>
    </div>
    <button class="popup-close" onclick="closeLatestPopup()">Got it!</button>
  </div>
</div>
<?php endif; ?>

<script>
function go(url){
 window.location.href = url;
}

// Add new result to history with animation and timing
function addResultToHistory(color, timeAgo = 'Just now') {
 const resultsContainer = document.getElementById('resultsContainer');
 
 // Ensure color is a string
 const colorStr = (color || '').toString();
 const colorLower = colorStr.toLowerCase();
 const colorUpper = colorStr.toUpperCase();
 
 if(!colorStr) {
  console.log('⚠️ Invalid color provided to addResultToHistory');
  return;
 }
 
 // Create new result item
 const newItem = document.createElement('div');
 newItem.className = 'result-item new-result';
 newItem.innerHTML = `
  <div class="ball ${colorLower}">
   ${colorUpper}
  </div>
  <div class="time-info">${timeAgo}</div>
 `;
 
 // Remove "no results" message if present
 const noResults = resultsContainer.querySelector('.no-results');
 if(noResults) {
  resultsContainer.innerHTML = '';
 }
 
 // Add to beginning of results
 resultsContainer.insertBefore(newItem, resultsContainer.firstChild);
 
 // Remove new-result class after animation
 setTimeout(() => {
  newItem.classList.remove('new-result');
 }, 600);
 
 // Remove oldest result if more than 10
 const items = resultsContainer.querySelectorAll('.result-item');
 if(items.length > 10) {
  const oldestItem = items[items.length - 1];
  oldestItem.classList.add('removing');
  setTimeout(() => {
   if(oldestItem.parentNode) {
    oldestItem.parentNode.removeChild(oldestItem);
   }
  }, 600);
 }
}

// Function to update full results display with timing
function updateFullResults(results) {
 const resultsContainer = document.getElementById('resultsContainer');
 
 console.log('🔄 Updating results display with', results ? results.length : 'null', 'items');
 console.log('📊 Results data:', results);
 
 // Clear existing results
 resultsContainer.innerHTML = '';
 
 if(results && Array.isArray(results) && results.length > 0) {
  results.forEach((result, index) => {
   console.log(`📍 Processing result ${index + 1}:`, result);
   
   // Multiple safety checks for color
   let color = '';
   let colorUpper = '';
   
   if(result && typeof result === 'object') {
    if(typeof result.color === 'string') {
     color = result.color.toLowerCase();
     colorUpper = result.color.toUpperCase();
    } else if(result.color !== null && result.color !== undefined) {
     color = String(result.color).toLowerCase();
     colorUpper = String(result.color).toUpperCase();
    }
   }
   
   const timeAgo = (result && result.time_ago) ? result.time_ago : 'Recently';
   
   console.log(`📍 Result ${index + 1}: color="${color}", colorUpper="${colorUpper}", timeAgo="${timeAgo}"`);
   
   if(color && colorUpper) {
    const item = document.createElement('div');
    item.className = 'result-item';
    item.setAttribute('data-time', (result && result.completed_at) ? result.completed_at : '');
    item.innerHTML = `
     <div class="ball ${color}">
      ${colorUpper}
     </div>
     <div class="time-info">${timeAgo}</div>
    `;
    resultsContainer.appendChild(item);
   } else {
    console.log('⚠️ Skipping invalid result:', result);
   }
  });
  
  console.log('✅ Results display updated successfully');
 } else {
  console.log('⚠️ No valid results to display');
  resultsContainer.innerHTML = `
   <div class="no-results">
    <div class="loading"></div>
    <p>No results available</p>
   </div>
  `;
 }
}

// Function to calculate time ago in JavaScript
function timeAgo(dateString) {
 const now = new Date();
 const past = new Date(dateString);
 const diffInSeconds = Math.floor((now - past) / 1000);
 
 console.log('Time calculation:', {
  now: now.toISOString(),
  past: past.toISOString(),
  diffInSeconds: diffInSeconds
 });
 
 if (diffInSeconds < 60) return 'Just now';
 if (diffInSeconds < 3600) return Math.floor(diffInSeconds / 60) + 'm ago';
 if (diffInSeconds < 86400) return Math.floor(diffInSeconds / 3600) + 'h ago';
 if (diffInSeconds < 2592000) return Math.floor(diffInSeconds / 86400) + 'd ago';
 
 return past.toLocaleDateString();
}

// Latest result popup functions
function showLatestPopup() {
 const popup = document.getElementById('latestResultPopup');
 if(popup) {
  popup.style.display = 'flex';
 }
}

function closeLatestPopup() {
 const popup = document.getElementById('latestResultPopup');
 if(popup) {
  popup.style.display = 'none';
  // Store in localStorage that user has seen this result
  localStorage.setItem('lastSeenResult', Date.now());
 }
}

// Test API function
function testAPI() {
 console.log('🧪 Testing API directly...');
 
 fetch('get_latest_results.php')
 .then(r => r.text())
 .then(text => {
  console.log('🧪 Raw API Response:', text);
  alert('API Response (check console for details):\n' + text.substring(0, 200) + '...');
 })
 .catch(e => {
  console.log('🧪 API Test Error:', e);
  alert('API Test Failed: ' + e.message);
 });
}

// Simplified dashboard - removed auto-refresh functionality

// Function to update time displays
function updateTimeDisplays() {
 const items = document.querySelectorAll('.result-item[data-time]');
 console.log(`🕐 Updating time displays for ${items.length} items`);
 
 items.forEach((item, index) => {
  const timeStr = item.getAttribute('data-time');
  if(timeStr) {
   const timeInfo = item.querySelector('.time-info');
   if(timeInfo) {
    const newTimeAgo = timeAgo(timeStr);
    console.log(`Item ${index}: ${timeStr} → ${newTimeAgo}`);
    timeInfo.textContent = newTimeAgo;
   }
  }
 });
}

// Function to update full results display
function updateFullResults(results) {
 const resultsContainer = document.getElementById('resultsContainer');
 
 // Clear existing results
 resultsContainer.innerHTML = '';
 
 if(results.length > 0) {
  results.forEach(color => {
   const ball = document.createElement('div');
   ball.className = `ball ${color.toLowerCase()}`;
   ball.textContent = color.toUpperCase();
   resultsContainer.appendChild(ball);
  });
 } else {
  resultsContainer.innerHTML = '<span style="color:#64748b;">No results yet</span>';
 }
}

// Load initial results when page loads
document.addEventListener('DOMContentLoaded', function() {
 console.log('🚀 Dashboard loaded, initializing...');
 
 // Show popup if exists
 const popup = document.getElementById('latestResultPopup');
 if(popup) {
  setTimeout(() => {
   showLatestPopup();
  }, 1000);
 }
 
 // Count initial PHP results
 const initialResults = document.querySelectorAll('.result-item').length;
 console.log(`📊 Initial PHP results: ${initialResults}`);
 lastResultCount = initialResults;
 
 // Keep PHP results stable - no auto-refresh
 console.log('✅ Keeping PHP results stable, auto-refresh disabled');
 
 // Start updating time displays every minute for live timing
 setInterval(updateTimeDisplays, 60000);
 
 console.log('✅ Dashboard initialization complete - Stable results with live timing');
});

// WhatsApp Help Function - Android WebView Integration
function openWhatsAppHelp() {
    const phoneNumber = "919876543210";
    const message = "Hello! I need help with PlayVipKing app.";
    
    try {
        // Check if Android interface is available (WebView)
        if (typeof Android !== 'undefined') {
            // Check if WhatsApp is installed
            if (Android.isWhatsAppInstalled && Android.isWhatsAppInstalled()) {
                // Open WhatsApp with message
                if (Android.openWhatsAppWithMessage) {
                    Android.openWhatsAppWithMessage(phoneNumber, message);
                } else if (Android.openWhatsAppChat) {
                    Android.openWhatsAppChat(phoneNumber);
                }
                return;
            }
        }
        
        // Fallback for web browsers or if Android interface not available
        const whatsappUrl = `https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`;
        
        // Try to open in same window first (for WebView)
        window.location.href = whatsappUrl;
        
        // Fallback: open in new tab after short delay (for browsers)
        setTimeout(() => {
            window.open(whatsappUrl, '_blank');
        }, 1000);
        
    } catch (error) {
        console.log('WhatsApp open error:', error);
        
        // Final fallback: direct WhatsApp web link
        const fallbackUrl = `https://wa.me/${phoneNumber}`;
        window.open(fallbackUrl, '_blank');
    }
}

// Help Modal Functions (keeping as backup)
function showHelpModal() {
    document.getElementById('helpModal').style.display = 'flex';
}

function closeHelpModal() {
    document.getElementById('helpModal').style.display = 'none';
}

// Close modal when clicking outside
window.onclick = function(event) {
    const modal = document.getElementById('helpModal');
    if (event.target == modal) {
        closeHelpModal();
    }
}

</script>

<!-- Help Modal -->
<div id="helpModal" style="display:none;position:fixed;z-index:1000;left:0;top:0;width:100%;height:100%;background-color:rgba(0,0,0,0.8);align-items:center;justify-content:center;">
    <div style="background:linear-gradient(135deg, rgba(255,255,255,0.2), rgba(255,255,255,0.1));backdrop-filter:blur(20px);border-radius:20px;padding:30px;width:90%;max-width:500px;color:#fff;position:relative;">
        <button onclick="closeHelpModal()" style="position:absolute;top:15px;right:20px;background:none;border:none;color:#fff;font-size:24px;cursor:pointer;padding:5px;">&times;</button>
        
        <h2 style="color:#ffd700;margin-bottom:20px;text-align:center;">❓ Need Help?</h2>
        
        <div style="margin-bottom:25px;">
            <h3 style="color:#17a2b8;margin-bottom:15px;">📞 Contact Support</h3>
            <div style="background:rgba(255,255,255,0.1);padding:15px;border-radius:10px;margin-bottom:15px;">
                <p><strong>📱 WhatsApp:</strong> <a href="https://wa.me/919876543210" target="_blank" style="color:#25d366;text-decoration:none;">+91 98765 43210</a></p>
                <p><strong>📧 Email:</strong> <a href="mailto:support@playvipking.com" style="color:#17a2b8;text-decoration:none;">support@playvipking.com</a></p>
                <p><strong>🕐 Support Hours:</strong> 24/7 Available</p>
            </div>
        </div>
        
        <div style="margin-bottom:25px;">
            <h3 style="color:#28a745;margin-bottom:15px;">❓ Common Questions</h3>
            <div style="background:rgba(255,255,255,0.1);padding:15px;border-radius:10px;">
                <p><strong>Q: How to add money to wallet?</strong><br>
                A: Go to Recharge → Select amount → Choose payment method</p>
                <hr style="border:1px solid rgba(255,255,255,0.2);margin:10px 0;">
                <p><strong>Q: How to withdraw money?</strong><br>
                A: Go to Withdraw → Enter amount → Provide bank details</p>
                <hr style="border:1px solid rgba(255,255,255,0.2);margin:10px 0;">
                <p><strong>Q: How does the game work?</strong><br>
                A: Select color → Choose amount → Place bet → Win 7x if correct!</p>
            </div>
        </div>
        
        <div style="text-align:center;">
            <button onclick="closeHelpModal()" style="background:linear-gradient(135deg,#ffd700,#ffb700);color:#000;border:none;padding:12px 25px;border-radius:10px;font-weight:bold;cursor:pointer;font-size:16px;">Got It!</button>
        </div>
    </div>
</div>

</body>
</html>
