<?php
include("config/db.php");

echo "<h2>Testing Results System</h2>";

// Check current games
echo "<h3>Current Games:</h3>";
$games = mysqli_query($conn, "SELECT * FROM games ORDER BY id DESC LIMIT 5");
while($game = mysqli_fetch_assoc($games)) {
    echo "Game ID: {$game['id']}, Status: {$game['status']}, Winning Color: {$game['winning_color']}, Created: {$game['created_at']}, Completed: {$game['completed_at']}<br>";
}

// Create a test completed game
echo "<h3>Creating Test Completed Game:</h3>";
$colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];
$test_winner = $colors[array_rand($colors)];

$result = mysqli_query($conn, "
    INSERT INTO games (status, winning_color, created_at, completed_at) 
    VALUES ('completed', '$test_winner', NOW() - INTERVAL 1 MINUTE, NOW())
");

if($result) {
    echo "✅ Test game created with winner: $test_winner<br>";
} else {
    echo "❌ Failed to create test game: " . mysqli_error($conn) . "<br>";
}

// Check latest results
echo "<h3>Latest 6 Results:</h3>";
$recent = mysqli_query($conn, "
    SELECT winning_color, completed_at 
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL AND winning_color != ''
    ORDER BY completed_at DESC 
    LIMIT 6
");

if(mysqli_num_rows($recent) > 0) {
    while($result = mysqli_fetch_assoc($recent)) {
        echo "Winner: {$result['winning_color']}, Completed: {$result['completed_at']}<br>";
    }
} else {
    echo "No completed games found<br>";
}

// Test the API endpoint
echo "<h3>Testing API Endpoint:</h3>";
$api_url = "http://localhost/user/get_latest_results.php";
$api_response = file_get_contents($api_url);
echo "API Response: <pre>$api_response</pre>";
?>