<?php
include("config/db.php");

echo "<h2>🔧 Database Setup</h2>";

// Create users table
$users_table = "
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    wallet DECIMAL(10,2) DEFAULT 0.00,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";

if(mysqli_query($conn, $users_table)){
    echo "<p>✅ Users table created/verified</p>";
} else {
    echo "<p>❌ Error creating users table: " . mysqli_error($conn) . "</p>";
}

// Create games table
$games_table = "
CREATE TABLE IF NOT EXISTS games (
    id INT AUTO_INCREMENT PRIMARY KEY,
    status ENUM('running', 'completed') DEFAULT 'running',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    completed_at TIMESTAMP NULL
)";

if(mysqli_query($conn, $games_table)){
    echo "<p>✅ Games table created/verified</p>";
    
    // Add winning_color column if it doesn't exist
    $add_column = mysqli_query($conn, "ALTER TABLE games ADD COLUMN winning_color VARCHAR(20) NULL");
    if($add_column){
        echo "<p>✅ Added winning_color column to games table</p>";
    } else {
        // Column might already exist, check error
        if(strpos(mysqli_error($conn), "Duplicate column") === false){
            echo "<p>⚠️ Warning: " . mysqli_error($conn) . "</p>";
        } else {
            echo "<p>✅ winning_color column already exists</p>";
        }
    }
} else {
    echo "<p>❌ Error creating games table: " . mysqli_error($conn) . "</p>";
}

// Create bets table
$bets_table = "
CREATE TABLE IF NOT EXISTS bets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    game_id INT NOT NULL,
    color VARCHAR(20) NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    status ENUM('pending', 'win', 'loss') DEFAULT 'pending',
    win_amount DECIMAL(10,2) DEFAULT 0.00,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (game_id) REFERENCES games(id)
)";

if(mysqli_query($conn, $bets_table)){
    echo "<p>✅ Bets table created/verified</p>";
} else {
    echo "<p>❌ Error creating bets table: " . mysqli_error($conn) . "</p>";
}

// Create game_history table (for admin panel)
$history_table = "
CREATE TABLE IF NOT EXISTS game_history (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    bet_amount DECIMAL(10,2) NOT NULL,
    user_color VARCHAR(20) NOT NULL,
    result_color VARCHAR(20) NOT NULL,
    result ENUM('Win', 'Lose') NOT NULL,
    bet_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id)
)";

if(mysqli_query($conn, $history_table)){
    echo "<p>✅ Game history table created/verified</p>";
} else {
    echo "<p>❌ Error creating game history table: " . mysqli_error($conn) . "</p>";
}

// Create admin table
$admin_table = "
CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";

if(mysqli_query($conn, $admin_table)){
    echo "<p>✅ Admins table created/verified</p>";
    
    // Insert default admin if not exists
    $check_admin = mysqli_query($conn, "SELECT id FROM admins WHERE username='admin'");
    if(mysqli_num_rows($check_admin) == 0){
        $default_admin = mysqli_query($conn, "INSERT INTO admins (username, password) VALUES ('admin', 'admin123')");
        if($default_admin){
            echo "<p>✅ Default admin created (username: admin, password: admin123)</p>";
        }
    }
} else {
    echo "<p>❌ Error creating admins table: " . mysqli_error($conn) . "</p>";
}

// Insert a test game if no games exist
$check_games = mysqli_query($conn, "SELECT id FROM games WHERE status='running'");
if(mysqli_num_rows($check_games) == 0){
    $test_game = mysqli_query($conn, "INSERT INTO games (status, created_at) VALUES ('running', NOW())");
    if($test_game){
        echo "<p>✅ Initial game created</p>";
    }
}

echo "<hr>";
echo "<h3>🎯 Setup Complete!</h3>";
echo "<p><a href='index.php'>🏠 Go to Home</a></p>";
echo "<p><a href='test_game.php'>🧪 Test Game Logic</a></p>";
?>