<?php
include("config/db.php");

echo "<h2>🔧 Fixing Wallet Calculation Mismatch</h2>";

// Add columns if not exist
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");

// Get all users
$users = mysqli_query($conn, "SELECT * FROM users");

echo "<h3>Checking and fixing wallet calculations:</h3>";

while($user = mysqli_fetch_assoc($users)) {
    $user_id = $user['id'];
    
    echo "<div style='background:#f8f9fa;padding:15px;margin:10px 0;border-radius:8px;border-left:4px solid #007bff;'>";
    echo "<h4>👤 {$user['name']} (ID: $user_id)</h4>";
    
    // Current values from database
    echo "<p><strong>Current Database Values:</strong></p>";
    echo "<p>💰 Wallet: ₹" . number_format($user['wallet'], 2) . "</p>";
    echo "<p>🎯 Winning Amount: ₹" . number_format($user['winning_amount'], 2) . "</p>";
    echo "<p>💳 Recharge Amount: ₹" . number_format($user['recharge_amount'], 2) . "</p>";
    
    $current_calculation = $user['recharge_amount'] + $user['winning_amount'];
    echo "<p>🧮 Current Calculation: ₹" . number_format($user['recharge_amount'], 2) . " + ₹" . number_format($user['winning_amount'], 2) . " = ₹" . number_format($current_calculation, 2) . "</p>";
    
    if(abs($user['wallet'] - $current_calculation) > 0.01) {
        echo "<p style='color:#e74c3c;'><strong>❌ MISMATCH DETECTED!</strong></p>";
        
        // Calculate correct values from transactions
        
        // 1. Total winnings from bets
        $winnings = mysqli_fetch_assoc(mysqli_query($conn, "
            SELECT COALESCE(SUM(win_amount), 0) as total_winnings 
            FROM bets 
            WHERE user_id = $user_id AND status = 'win'
        "));
        $total_winnings = $winnings['total_winnings'];
        
        // 2. Total approved recharges
        $recharges = mysqli_fetch_assoc(mysqli_query($conn, "
            SELECT COALESCE(SUM(amount), 0) as total_recharges 
            FROM recharge_requests 
            WHERE user_id = $user_id AND status = 'approved'
        "));
        $total_recharges = $recharges['total_recharges'];
        
        // 3. Total approved withdrawals
        $withdrawals = mysqli_fetch_assoc(mysqli_query($conn, "
            SELECT COALESCE(SUM(amount), 0) as total_withdrawals 
            FROM withdrawal_requests 
            WHERE user_id = $user_id AND status = 'approved'
        "));
        $total_withdrawals = $withdrawals['total_withdrawals'];
        
        // 4. Calculate correct amounts
        $correct_winning_amount = max(0, $total_winnings - $total_withdrawals);
        $correct_recharge_amount = $total_recharges;
        $correct_wallet = $correct_recharge_amount + $correct_winning_amount;
        
        echo "<p><strong>Calculated from Transactions:</strong></p>";
        echo "<p>🎯 Total Winnings from Bets: ₹" . number_format($total_winnings, 2) . "</p>";
        echo "<p>💳 Total Approved Recharges: ₹" . number_format($total_recharges, 2) . "</p>";
        echo "<p>🏧 Total Approved Withdrawals: ₹" . number_format($total_withdrawals, 2) . "</p>";
        echo "<p><strong>Correct Values Should Be:</strong></p>";
        echo "<p>🎯 Winning Amount: ₹" . number_format($correct_winning_amount, 2) . "</p>";
        echo "<p>💳 Recharge Amount: ₹" . number_format($correct_recharge_amount, 2) . "</p>";
        echo "<p>💰 Total Wallet: ₹" . number_format($correct_wallet, 2) . "</p>";
        
        // Update with correct values
        mysqli_query($conn, "
            UPDATE users 
            SET wallet = $correct_wallet,
                winning_amount = $correct_winning_amount,
                recharge_amount = $correct_recharge_amount
            WHERE id = $user_id
        ");
        
        echo "<p style='color:#27ae60;'><strong>✅ FIXED! Updated to correct values.</strong></p>";
        
    } else {
        echo "<p style='color:#27ae60;'><strong>✅ Already Correct</strong></p>";
    }
    
    echo "</div>";
}

echo "<br><h3>✅ All wallet calculations have been fixed!</h3>";

// Verify all users now have correct calculations
echo "<h3>Verification - All Users After Fix:</h3>";

$verification = mysqli_query($conn, "SELECT * FROM users");

while($user = mysqli_fetch_assoc($verification)) {
    $calculated = $user['recharge_amount'] + $user['winning_amount'];
    $status = abs($user['wallet'] - $calculated) <= 0.01 ? "✅" : "❌";
    
    echo "<p>👤 <strong>{$user['name']}</strong>: ";
    echo "Wallet: ₹" . number_format($user['wallet'], 2) . " = ";
    echo "Recharge: ₹" . number_format($user['recharge_amount'], 2) . " + ";
    echo "Winning: ₹" . number_format($user['winning_amount'], 2) . " ";
    echo "= ₹" . number_format($calculated, 2) . " $status</p>";
}

// Show final summary
$summary = mysqli_query($conn, "
    SELECT 
        COUNT(*) as total_users,
        SUM(wallet) as total_wallet,
        SUM(winning_amount) as total_winnings,
        SUM(recharge_amount) as total_recharge
    FROM users
");

$stats = mysqli_fetch_assoc($summary);

echo "<div style='background:#e8f5e8;padding:20px;border-radius:10px;margin:20px 0;border:2px solid #28a745;'>";
echo "<h3>📊 Final Summary:</h3>";
echo "<p><strong>Total Users:</strong> " . $stats['total_users'] . "</p>";
echo "<p><strong>Total Wallet Amount:</strong> ₹" . number_format($stats['total_wallet'], 2) . "</p>";
echo "<p><strong>Total Winning Amount:</strong> ₹" . number_format($stats['total_winnings'], 2) . "</p>";
echo "<p><strong>Total Recharge Amount:</strong> ₹" . number_format($stats['total_recharge'], 2) . "</p>";
echo "<p><strong>Verification:</strong> ₹" . number_format($stats['total_wallet'], 2) . " = ₹" . number_format($stats['total_recharge'] + $stats['total_winnings'], 2);
echo " " . (abs($stats['total_wallet'] - ($stats['total_recharge'] + $stats['total_winnings'])) <= 0.01 ? "✅ BALANCED" : "❌ STILL MISMATCH") . "</p>";
echo "</div>";

echo "<br><a href='user/withdraw.php' target='_blank' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>🏧 Test Withdrawal Page</a>";
?>