<?php
include("config/db.php");

echo "<h2>🔧 Direct SQL Fix for Timing</h2>";

// First, let's see what we have
echo "<h3>Current Results:</h3>";
$current = mysqli_query($conn, "
    SELECT id, winning_color, completed_at,
           TIMESTAMPDIFF(SECOND, completed_at, NOW()) as seconds_ago
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY id DESC 
    LIMIT 10
");

if($current && mysqli_num_rows($current) > 0) {
    while($row = mysqli_fetch_assoc($current)) {
        echo "Game {$row['id']}: {$row['winning_color']} - {$row['seconds_ago']} seconds ago ({$row['completed_at']})<br>";
    }
} else {
    echo "No results found<br>";
}

echo "<hr><h3>Applying Direct SQL Fix:</h3>";

// Get game IDs to update
$games = mysqli_query($conn, "
    SELECT id FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY id DESC 
    LIMIT 10
");

$game_ids = [];
while($game = mysqli_fetch_assoc($games)) {
    $game_ids[] = $game['id'];
}

// Update each game with specific timing
$time_intervals = [5, 15, 28, 42, 58, 75, 95, 125, 180, 240]; // minutes

for($i = 0; $i < count($game_ids) && $i < count($time_intervals); $i++) {
    $game_id = $game_ids[$i];
    $minutes = $time_intervals[$i];
    
    $sql = "UPDATE games SET completed_at = NOW() - INTERVAL $minutes MINUTE WHERE id = $game_id";
    echo "Executing: $sql<br>";
    
    $result = mysqli_query($conn, $sql);
    if($result) {
        echo "✅ Updated game $game_id to $minutes minutes ago<br>";
    } else {
        echo "❌ Failed to update game $game_id: " . mysqli_error($conn) . "<br>";
    }
}

echo "<hr><h3>Verification:</h3>";

// Verify the changes
$verify = mysqli_query($conn, "
    SELECT id, winning_color, completed_at,
           TIMESTAMPDIFF(MINUTE, completed_at, NOW()) as minutes_ago
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 10
");

while($row = mysqli_fetch_assoc($verify)) {
    $minutes = $row['minutes_ago'];
    if($minutes < 60) {
        $display = $minutes . "m ago";
    } else {
        $hours = floor($minutes / 60);
        $remaining = $minutes % 60;
        $display = $hours . "h" . ($remaining > 0 ? " {$remaining}m" : "") . " ago";
    }
    
    echo "✅ Game {$row['id']}: {$row['winning_color']} - $display<br>";
}

echo "<br><strong>🎯 Database updated! Now check dashboard.</strong>";
echo "<br><br><a href='user/dashboard.php' target='_blank'>📊 View Dashboard</a>";
?>