<?php
include("../config/db.php");
include("../config/session_admin.php");



$dateQS = isset($_GET['date']) && $_GET['date'] != ""
    ? "?date=".$_GET['date']
    : "";



if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

$history = [];
$mobile = "";

if(isset($_POST['search'])){
    $mobile = mysqli_real_escape_string($conn, $_POST['mobile']);
    
    // Debug: Show what we're searching for
    echo "<p style='color:blue;'>🔍 Searching for mobile: <b>$mobile</b></p>";
    
    // user find by mobile (stored in email column) - no validation
    $u = mysqli_query($conn,"
        SELECT id, email 
        FROM users 
        WHERE email='$mobile'
    ");
    $user = mysqli_fetch_assoc($u);

    if($user){
        $uid = $user['id'];
        echo "<p style='color:green;'>✅ User found! ID: <b>$uid</b></p>";

        // recharge history from recharge_requests table
        $q = mysqli_query($conn,"
            SELECT amount, status, created_at, method, txn_id
            FROM recharge_requests 
            WHERE user_id=$uid 
            ORDER BY id DESC
        ");

        $total_records = mysqli_num_rows($q);
        echo "<p style='color:blue;'>📊 Total recharge records found: <b>$total_records</b></p>";

        while($row = mysqli_fetch_assoc($q)){
            $history[] = $row;
        }
    } else {
        $error_msg = "No user found with mobile number: $mobile";
        
        // Debug: Show all users for reference
        $all_users = mysqli_query($conn, "SELECT id, email FROM users LIMIT 5");
        echo "<p style='color:orange;'>📋 Sample users in database:</p><ul>";
        while($sample = mysqli_fetch_assoc($all_users)){
            echo "<li>ID: {$sample['id']}, Mobile: {$sample['email']}</li>";
        }
        echo "</ul>";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Recharge History</title>
<style>
body{font-family:Arial;background:#f4f6f8}
.box{
    width:800px;
    background:#fff;
    padding:20px;
    margin:30px auto;
    border-radius:8px;
    box-shadow:0 2px 6px rgba(0,0,0,.2);
}
input,button{
    padding:8px;
}
table{
    width:100%;
    border-collapse:collapse;
    margin-top:15px;
}
table th, table td{
    border:1px solid #ccc;
    padding:8px;
    text-align:center;
}
th{background:#eee}
.back{margin-top:10px;display:inline-block}
</style>
</head>
<body>

<div class="box">
    <h2>📜 Recharge History (User-wise)</h2>

    <!-- 🔍 SEARCH FORM -->
    <form method="post">
        <label>User Mobile Number :</label>
        <input type="text" name="mobile" required placeholder="Enter mobile number" maxlength="15">
        <button type="submit" name="search">Search</button>
    </form>

    <?php if(isset($error_msg)){ ?>
        <p style="color:red;"><b><?php echo $error_msg; ?></b></p>
    <?php } ?>

    <?php if(isset($_POST['search'])){ ?>

        <?php if(empty($history)){ ?>
            <p><b>No recharge history found.</b></p>
        <?php }else{ ?>

        <table>
            <tr>
                <th>#</th>
                <th>Amount</th>
                <th>Method</th>
                <th>Status</th>
                <th>Txn ID</th>
                <th>Date & Time</th>
            </tr>

            <?php $i=1; foreach($history as $h){ ?>
            <tr>
                <td><?php echo $i++; ?></td>
                <td>₹ <?php echo number_format($h['amount'], 2); ?></td>
                <td><?php echo ucfirst($h['method'] ?? 'N/A'); ?></td>
                <td>
                    <?php 
                    $status = $h['status'];
                    $color = '';
                    if($status == 'approved') $color = 'color:green;font-weight:bold;';
                    elseif($status == 'rejected') $color = 'color:red;font-weight:bold;';
                    elseif($status == 'pending') $color = 'color:orange;font-weight:bold;';
                    echo "<span style='$color'>" . ucfirst($status) . "</span>";
                    ?>
                </td>
                <td><?php echo $h['txn_id'] ?? 'N/A'; ?></td>
                <td><?php echo date("d-m-Y h:i A", strtotime($h['created_at'])); ?></td>
            </tr>
            <?php } ?>

        </table>

        <?php } ?>
    <?php } ?>

    <!-- <a class="back" href="dashboard.php">⬅ Back to Dashboard</a> -->


    <a href="dashboard.php<?php echo $dateQS; ?>">
⬅ Back to Dashboard
</a>

</div>

</body>
</html>
