<?php
include("../config/db.php");
include("../config/session_admin.php");


// Admin login check
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}

// Create notices table if not exists
mysqli_query($conn, "
    CREATE TABLE IF NOT EXISTS notices (
        id INT AUTO_INCREMENT PRIMARY KEY,
        title VARCHAR(255) NOT NULL,
        content TEXT NOT NULL,
        type ENUM('info','warning','success','error') DEFAULT 'info',
        is_active BOOLEAN DEFAULT TRUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )
");

// Handle form submissions
if(isset($_POST['action'])) {
    $action = $_POST['action'];
    
    if($action == 'add') {
        $title = mysqli_real_escape_string($conn, $_POST['title']);
        $content = mysqli_real_escape_string($conn, $_POST['content']);
        $type = mysqli_real_escape_string($conn, $_POST['type']);
        
        $insert = mysqli_query($conn, "
            INSERT INTO notices (title, content, type, is_active) 
            VALUES ('$title', '$content', '$type', TRUE)
        ");
        
        if($insert) {
            $success_msg = "Notice added successfully!";
        } else {
            $error_msg = "Failed to add notice!";
        }
    }
    
    if($action == 'edit') {
        $id = (int)$_POST['id'];
        $title = mysqli_real_escape_string($conn, $_POST['title']);
        $content = mysqli_real_escape_string($conn, $_POST['content']);
        $type = mysqli_real_escape_string($conn, $_POST['type']);
        
        $update = mysqli_query($conn, "
            UPDATE notices 
            SET title='$title', content='$content', type='$type', updated_at=NOW() 
            WHERE id=$id
        ");
        
        if($update) {
            $success_msg = "Notice updated successfully!";
        } else {
            $error_msg = "Failed to update notice!";
        }
    }
}

// Handle toggle active/inactive
if(isset($_GET['toggle']) && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $toggle = mysqli_query($conn, "
        UPDATE notices 
        SET is_active = NOT is_active 
        WHERE id = $id
    ");
    
    if($toggle) {
        $success_msg = "Notice status updated!";
    }
}

// Handle delete
if(isset($_GET['delete']) && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $delete = mysqli_query($conn, "DELETE FROM notices WHERE id = $id");
    
    if($delete) {
        $success_msg = "Notice deleted successfully!";
    }
}

// Get notice for editing
$edit_notice = null;
if(isset($_GET['edit']) && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $edit_result = mysqli_query($conn, "SELECT * FROM notices WHERE id = $id");
    if($edit_result && mysqli_num_rows($edit_result) > 0) {
        $edit_notice = mysqli_fetch_assoc($edit_result);
    }
}

// Get all notices
$notices = mysqli_query($conn, "
    SELECT * FROM notices 
    ORDER BY created_at DESC
");
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="mobile-responsive.css">
<title>Manage Notices</title>
<style>
body{font-family:Arial;background:#f4f6f8;margin:0;padding:20px}
.container{max-width:1200px;margin:0 auto}
.box{
    background:#fff;
    padding:25px;
    border-radius:10px;
    box-shadow:0 2px 10px rgba(0,0,0,.1);
    margin-bottom:25px;
}
.form-group{margin-bottom:20px}
.form-label{display:block;margin-bottom:8px;font-weight:600;color:#333}
.form-input{
    width:100%;
    padding:12px;
    border:1px solid #ddd;
    border-radius:8px;
    font-size:14px;
    box-sizing:border-box;
}
.form-input:focus{outline:none;border-color:#007bff;box-shadow:0 0 0 3px rgba(0,123,255,.1)}
.btn{
    padding:10px 20px;
    border:none;
    border-radius:6px;
    cursor:pointer;
    font-weight:600;
    text-decoration:none;
    display:inline-block;
    margin-right:10px;
    margin-bottom:10px;
}
.btn-primary{background:#007bff;color:#fff}
.btn-success{background:#28a745;color:#fff}
.btn-warning{background:#ffc107;color:#000}
.btn-danger{background:#dc3545;color:#fff}
.btn-secondary{background:#6c757d;color:#fff}
.btn:hover{opacity:0.9;transform:translateY(-1px)}
table{width:100%;border-collapse:collapse;margin-top:15px}
th,td{padding:12px;text-align:left;border-bottom:1px solid #ddd}
th{background:#f8f9fa;font-weight:600}
tr:hover{background:#f8f9fa}
.status-badge{
    padding:4px 8px;
    border-radius:12px;
    font-size:12px;
    font-weight:600;
}
.status-active{background:#d4edda;color:#155724}
.status-inactive{background:#f8d7da;color:#721c24}
.notice-type{
    padding:4px 8px;
    border-radius:12px;
    font-size:12px;
    font-weight:600;
    color:#fff;
}
.type-info{background:#17a2b8}
.type-success{background:#28a745}
.type-warning{background:#ffc107;color:#000}
.type-error{background:#dc3545}
.alert{
    padding:15px;
    border-radius:8px;
    margin-bottom:20px;
}
.alert-success{background:#d4edda;color:#155724;border:1px solid #c3e6cb}
.alert-error{background:#f8d7da;color:#721c24;border:1px solid #f5c6cb}
.header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:30px;
}
.back-link{
    color:#007bff;
    text-decoration:none;
    font-weight:600;
}
.back-link:hover{text-decoration:underline}
</style>
</head>
<body>

<div class="container">
    <div class="header">
        <h1>📢 Manage Notices</h1>
        <a href="dashboard.php" class="back-link">⬅ Back to Dashboard</a>
    </div>

    <?php if(isset($success_msg)): ?>
        <div class="alert alert-success">✅ <?= $success_msg ?></div>
    <?php endif; ?>
    
    <?php if(isset($error_msg)): ?>
        <div class="alert alert-error">❌ <?= $error_msg ?></div>
    <?php endif; ?>

    <!-- Add/Edit Notice Form -->
    <div class="box">
        <h2><?= $edit_notice ? '✏️ Edit Notice' : '➕ Add New Notice' ?></h2>
        
        <form method="POST">
            <input type="hidden" name="action" value="<?= $edit_notice ? 'edit' : 'add' ?>">
            <?php if($edit_notice): ?>
                <input type="hidden" name="id" value="<?= $edit_notice['id'] ?>">
            <?php endif; ?>
            
            <div class="form-group">
                <label class="form-label">Notice Title</label>
                <input type="text" name="title" class="form-input" 
                       value="<?= $edit_notice ? htmlspecialchars($edit_notice['title']) : '' ?>" 
                       placeholder="Enter notice title" required>
            </div>
            
            <div class="form-group">
                <label class="form-label">Notice Content</label>
                <textarea name="content" class="form-input" rows="5" 
                          placeholder="Enter notice content" required><?= $edit_notice ? htmlspecialchars($edit_notice['content']) : '' ?></textarea>
            </div>
            
            <div class="form-group">
                <label class="form-label">Notice Type</label>
                <select name="type" class="form-input" required>
                    <option value="info" <?= ($edit_notice && $edit_notice['type'] == 'info') ? 'selected' : '' ?>>ℹ️ Information</option>
                    <option value="success" <?= ($edit_notice && $edit_notice['type'] == 'success') ? 'selected' : '' ?>>✅ Success</option>
                    <option value="warning" <?= ($edit_notice && $edit_notice['type'] == 'warning') ? 'selected' : '' ?>>⚠️ Warning</option>
                    <option value="error" <?= ($edit_notice && $edit_notice['type'] == 'error') ? 'selected' : '' ?>>❌ Error</option>
                </select>
            </div>
            
            <button type="submit" class="btn btn-primary">
                <?= $edit_notice ? '💾 Update Notice' : '➕ Add Notice' ?>
            </button>
            
            <?php if($edit_notice): ?>
                <a href="notices.php" class="btn btn-secondary">❌ Cancel</a>
            <?php endif; ?>
        </form>
    </div>

    <!-- Notices List -->
    <div class="box">
        <h2>📋 All Notices</h2>
        
        <?php if($notices && mysqli_num_rows($notices) > 0): ?>
            <table class="notices-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($notice = mysqli_fetch_assoc($notices)): ?>
                        <tr>
                            <td><?= $notice['id'] ?></td>
                            <td>
                                <strong><?= htmlspecialchars($notice['title']) ?></strong>
                                <br>
                                <small style="color:#666;">
                                    <?= strlen($notice['content']) > 100 ? 
                                        htmlspecialchars(substr($notice['content'], 0, 100)) . '...' : 
                                        htmlspecialchars($notice['content']) ?>
                                </small>
                            </td>
                            <td>
                                <span class="notice-type type-<?= $notice['type'] ?>">
                                    <?= ucfirst($notice['type']) ?>
                                </span>
                            </td>
                            <td>
                                <span class="status-badge <?= $notice['is_active'] ? 'status-active' : 'status-inactive' ?>">
                                    <?= $notice['is_active'] ? 'Active' : 'Inactive' ?>
                                </span>
                            </td>
                            <td><?= date('M j, Y H:i', strtotime($notice['created_at'])) ?></td>
                            <td>
                                <a href="?edit=1&id=<?= $notice['id'] ?>" class="btn btn-warning">✏️ Edit</a>
                                <a href="?toggle=1&id=<?= $notice['id'] ?>" class="btn <?= $notice['is_active'] ? 'btn-secondary' : 'btn-success' ?>">
                                    <?= $notice['is_active'] ? '🔒 Deactivate' : '🔓 Activate' ?>
                                </a>
                                <a href="?delete=1&id=<?= $notice['id'] ?>" class="btn btn-danger" 
                                   onclick="return confirm('Are you sure you want to delete this notice?')">
                                   🗑️ Delete
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div style="text-align:center;padding:40px;color:#666;">
                <h3>📢 No Notices Found</h3>
                <p>Create your first notice using the form above.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Quick Actions -->
    <div class="box">
        <h2>🚀 Quick Actions</h2>
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;">
            <div style="padding:20px;background:#e3f2fd;border-radius:10px;text-align:center;">
                <h3 style="color:#1976d2;margin-bottom:10px;">📊 View User Side</h3>
                <p style="margin-bottom:15px;">See how notices appear to users</p>
                <a href="../user/notice.php" target="_blank" class="btn btn-primary">👁️ Preview</a>
            </div>
            
            <div style="padding:20px;background:#f3e5f5;border-radius:10px;text-align:center;">
                <h3 style="color:#7b1fa2;margin-bottom:10px;">📝 Quick Templates</h3>
                <p style="margin-bottom:15px;">Use pre-made notice templates</p>
                <button class="btn btn-secondary" onclick="useTemplate('maintenance')">🔧 Maintenance</button>
                <button class="btn btn-secondary" onclick="useTemplate('update')">🆕 Update</button>
            </div>
        </div>
    </div>
</div>

<script>
function useTemplate(type) {
    const titleInput = document.querySelector('input[name="title"]');
    const contentInput = document.querySelector('textarea[name="content"]');
    const typeSelect = document.querySelector('select[name="type"]');
    
    if(type === 'maintenance') {
        titleInput.value = 'Scheduled Maintenance';
        contentInput.value = 'We will be performing scheduled maintenance on [DATE] from [START TIME] to [END TIME]. During this time, the platform will be temporarily unavailable. We apologize for any inconvenience caused.';
        typeSelect.value = 'warning';
    } else if(type === 'update') {
        titleInput.value = 'Platform Update';
        contentInput.value = 'We have released a new update with improved features and bug fixes. Please refresh your browser to get the latest version. Thank you for your patience.';
        typeSelect.value = 'success';
    }
}
</script>

</body>
</html>