<?php
include("../config/db.php");
include("../config/session_admin.php");


// ❌ yaha session_start() nahi (db.php me already hai)
if(!isset($_SESSION['admin_id'])){
    header("Location: login.php");
    exit;
}




// 📅 DEFAULT = TODAY DASHBOARD
if(isset($_GET['date']) && $_GET['date'] != ""){
    // admin ne manually date select ki
    $date = mysqli_real_escape_string($conn, $_GET['date']);
}else{
    // koi date select nahi → today
    $date = date("Y-m-d");
}

// ✅ SAME DATE CONDITION FOR ALL BOXES
$dateCondition = " AND created_at BETWEEN '$date 00:00:00' AND '$date 23:59:59' ";



// 📅 DATE CONDITION (PURE DASHBOARD KE LIYE)
// $dateCondition = "";

// if(isset($_GET['date']) && $_GET['date'] != ""){
//     $date = mysqli_real_escape_string($conn, $_GET['date']);
//     $dateCondition = " AND created_at BETWEEN '$date 00:00:00' AND '$date 23:59:59' ";
// }



// 📅 DATE FILTER LOGIC
// $filterDate = "";
// if(isset($_GET['date']) && $_GET['date'] != ""){
//     $date = mysqli_real_escape_string($conn, $_GET['date']);
//     $filterDate = " AND DATE(created_at) = '$date' ";
// }




/* ================= SAFE SUM FUNCTION ================= */
function getSum($conn, $sql){
    $q = mysqli_query($conn, $sql);
    if(!$q) return 0;
    $r = mysqli_fetch_assoc($q);
    return $r && $r['total'] ? (int)$r['total'] : 0;
}

/* ================= OLD STATS (SAME AS BEFORE) ================= */




/* ================= DASHBOARD TOTALS (DATE-WISE) ================= */

// ✅ Total Users (date-wise registration)
$total_users = getSum($conn,"
    SELECT COUNT(*) AS total
    FROM users
    WHERE 1 $dateCondition
");

// ✅ Total Wallet Balance (current only – correct logic)
$total_wallet = getSum($conn,"
    SELECT SUM(wallet) AS total
    FROM users
");

// ✅ Total Recharge (date-wise)
// $total_recharge = getSum($conn,"
//     SELECT SUM(amount) AS total
//     FROM recharges
//     WHERE status='success' $dateCondition
// ");




// 🔹 Admin Direct Recharge (date-wise)
$admin_recharge = getSum($conn,"
    SELECT SUM(amount) AS total
    FROM recharges
    WHERE status='success' $dateCondition
");

// 🔹 User Recharge Request (Approved, date-wise)
$request_recharge = getSum($conn,"
    SELECT SUM(amount) AS total
    FROM recharge_requests
    WHERE status='approved' $dateCondition
");

// 🔹 FINAL TOTAL RECHARGE (Dashboard box)
$total_recharge = $admin_recharge + $request_recharge;




// ✅ Total Withdrawal (date-wise)
$total_withdrawal = getSum($conn,"
    SELECT SUM(amount) AS total
    FROM withdrawals
    WHERE status='approved' $dateCondition
");

// ✅ Total Winning Amount (date-wise, win_amount based)
$total_winning_amount = getSum($conn,"
    SELECT SUM(win_amount) AS total
    FROM bets
    WHERE win_amount > 0 $dateCondition
");

// ✅ Total Bet Amount (date-wise)
$total_bet_amount = getSum($conn,"
    SELECT SUM(amount) AS total
    FROM bets
    WHERE 1 $dateCondition
");

// ✅ Company Profit (date-wise)
$company_profit =
    $total_recharge
  - $total_withdrawal
  - $total_winning_amount;

/* ================= COLOR WISE TOTAL BET (DATE-WISE) ================= */

$colors = ['red','green','yellow','blue','purple','orange','pink','cyan'];
$color_bets = [];

foreach($colors as $c){
    $color_bets[$c] = getSum($conn,"
        SELECT SUM(amount) AS total
        FROM bets
        WHERE color='$c' $dateCondition
    ");
}


?>




<!DOCTYPE html>
<html>
<head>
    <title>Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="mobile-responsive.css">
    <style>
        body{font-family:Arial;background:#f4f6f8;}
        .header{
            background:#222;color:#fff;padding:15px;
        }
        .container{padding:20px;}
        .card{
            display:inline-block;
            background:#fff;
            padding:20px;
            margin:10px;
            border-radius:8px;
            width:220px;
            box-shadow:0 2px 6px rgba(0,0,0,.1);
            vertical-align:top;
        }
        .green{color:#28a745;}
        .red{color:#dc3545;}
        a{
            display:inline-block;
            margin:10px;
            padding:10px 15px;
            background:#007bff;
            color:#fff;
            text-decoration:none;
            border-radius:5px;
        }
        .logout{background:#dc3545;}



.menu{
    background:#111;
    padding:12px;
}
.menu a{
    color:#fff;
    margin-right:15px;
    text-decoration:none;
    font-weight:bold;
}
.menu a:hover{
    text-decoration:underline;
}







    </style>
</head>






<body>

<!-- <div class="menu">
    <a href="dashboard.php">🏠 Dashboard</a>
    <a href="admin_recharge.php">💳 Recharge</a>
    <a href="recharge_history.php">📜 Recharge History</a> 
    <a href="recharge_requests.php">📥 Recharge Requests</a>
    <a href="withdrawal_requests.php">🏧 Withdrawal Requests</a>
    <a href="logout.php">🚪 Logout</a>
</div>
 -->






<div class="header">
    <h2>👑 Admin Dashboard</h2>
    <p>Welcome, <?php echo $_SESSION['admin_username']; ?></p>
</div>





<form method="get" style="margin:15px 0;">
    <label><b>Select Date:</b></label>
    <input type="date" name="date" value="<?php echo $_GET['date'] ?? ''; ?>">
    <button type="submit">Search</button>
    <a href="dashboard.php">Reset</a>
</form>





<div class="container">

    <!-- ✅ OLD CARDS (UNCHANGED) -->
    <div class="card">
        <h3>Total Users</h3>
        <p><?php echo $total_users; ?></p>
    </div>

    <div class="card">
        <h3>Total Wallet Balance</h3>
        <p>₹ <?php echo $total_wallet; ?></p>
    </div>

    <!-- ✅ NEW CARDS (ADDED) -->
    <div class="card">
        <h3>Total Recharge</h3>
        <p class="green">₹ <?php echo $total_recharge; ?></p>
    </div>

    <div class="card">
        <h3>Total Withdrawal</h3>
        <p class="red">₹ <?php echo $total_withdrawal; ?></p>
    </div>

    <!-- <div class="card">
        <h3>Total Winning</h3>
        <p>₹ <?php echo $total_winning; ?></p>
    </div> -->

    <div class="card">
        <h3>Company Profit</h3>
        <p><b>₹ <?php echo $company_profit; ?></b></p>
    </div>


    <div class="card">
    <h3>Total Winning Amount</h3>
    <p>₹ <?php echo $total_winning_amount; ?></p>
</div>


<!-- 🆕 TOTAL BET AMOUNT -->
<div class="card">
    <h3>Total Bet Amount</h3>
    <p>₹ <?php echo $total_bet_amount; ?></p>
</div>




<!-- 🎨 COLOR WISE TOTAL BET -->
<div class="card">
    <h3 style="color:red">Red Bet</h3>
    <p>₹ <?php echo $color_bets['red']; ?></p>
</div>

<div class="card">
    <h3 style="color:green">Green Bet</h3>
    <p>₹ <?php echo $color_bets['green']; ?></p>
</div>

<div class="card">
    <h3 style="color:gold">Yellow Bet</h3>
    <p>₹ <?php echo $color_bets['yellow']; ?></p>
</div>

<div class="card">
    <h3 style="color:blue">Blue Bet</h3>
    <p>₹ <?php echo $color_bets['blue']; ?></p>
</div>

<div class="card">
    <h3 style="color:purple">Purple Bet</h3>
    <p>₹ <?php echo $color_bets['purple']; ?></p>
</div>

<div class="card">
    <h3 style="color:orange">Orange Bet</h3>
    <p>₹ <?php echo $color_bets['orange']; ?></p>
</div>

<div class="card">
    <h3 style="color:deeppink">Pink Bet</h3>
    <p>₹ <?php echo $color_bets['pink']; ?></p>
</div>

<div class="card">
    <h3 style="color:teal">Cyan Bet</h3>
    <p>₹ <?php echo $color_bets['cyan']; ?></p>
</div>




    <br><br>

    <!-- ✅ OLD LINKS (UNCHANGED) -->
<!--    <a href="users.php">👥 Manage Users</a>
<a href="game_history.php">📜 Game History</a>
<a href="admin_recharge.php">💳 Admin Recharge</a>
<a href="recharge_history.php">📜 Recharge History</a>
<a href="bet_history.php">🎮 Bet History</a>
<a href="winning_history.php">🏆 Winning History</a>
<a href="withdrawal_history.php">📜 Withdrawal History</a>
<a href="withdrawal_requests.php">🏧 Withdrawal Requests</a> -->


<!-- <a href="logout.php" class="logout">🚪 Logout</a> -->



<?php
$qs = isset($_GET['date']) && $_GET['date'] != "" 
    ? "?date=".$_GET['date'] 
    : "";
?>

<a href="users.php<?php echo $qs; ?>">👥 Manage Users</a>
<a href="notices.php">📢 Manage Notices</a>
<a href="manage_results.php">🎮 Manage Results</a>
<a href="game_history.php<?php echo $qs; ?>">📜 Game History</a>
<a href="admin_recharge.php<?php echo $qs; ?>">💳 Admin Recharge</a>
<a href="recharge_history.php<?php echo $qs; ?>">📜 Recharge History</a>
<a href="bet_history.php<?php echo $qs; ?>">🎮 Bet History</a>
<a href="winning_history.php<?php echo $qs; ?>">🏆 Winning History</a>
<a href="withdrawal_history.php<?php echo $qs; ?>">📜 Withdrawal History</a>
<a href="withdrawal_requests.php<?php echo $qs; ?>">🏧 Withdrawal Requests</a>
<a href="recharge_requests.php<?php echo $qs; ?>">💳 Recharge Requests</a>


<a href="logout.php" class="logout">🚪 Logout</a>




</div>

</body>
</html>
