<?php
include("config/db.php");

echo "<h2>Adding More Test Results</h2>";

$colors = ['red', 'green', 'yellow', 'blue', 'purple', 'orange', 'pink', 'cyan'];

// Add 15 test results to ensure we have enough
for($i = 0; $i < 15; $i++) {
    $winner = $colors[array_rand($colors)];
    $minutes_ago = ($i + 1) * 8; // 8, 16, 24... minutes ago
    
    $result = mysqli_query($conn, "
        INSERT INTO games (status, winning_color, created_at, completed_at) 
        VALUES (
            'completed', 
            '$winner', 
            NOW() - INTERVAL $minutes_ago MINUTE, 
            NOW() - INTERVAL " . ($minutes_ago - 3) . " MINUTE
        )
    ");
    
    if($result) {
        echo "✅ Added result $i: $winner (" . $minutes_ago . "m ago)<br>";
    } else {
        echo "❌ Failed: " . mysqli_error($conn) . "<br>";
    }
}

echo "<h3>Verification - Latest 10 Results:</h3>";
$check = mysqli_query($conn, "
    SELECT id, winning_color, completed_at 
    FROM games 
    WHERE status='completed' AND winning_color IS NOT NULL 
    ORDER BY completed_at DESC 
    LIMIT 10
");

$count = 0;
while($row = mysqli_fetch_assoc($check)) {
    $count++;
    $time_ago = floor((time() - strtotime($row['completed_at'])) / 60);
    echo "$count. Game {$row['id']}: <strong>{$row['winning_color']}</strong> ({$time_ago}m ago) - {$row['completed_at']}<br>";
}

echo "<br><strong>Total completed games: </strong>";
$total = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM games WHERE status='completed' AND winning_color IS NOT NULL"));
echo $total['count'];

echo "<br><br><a href='user/dashboard.php' target='_blank'>🎯 Open Dashboard</a>";
echo "<br><a href='user/get_latest_results.php' target='_blank'>📊 Test API</a>";
?>