<?php
include("../config/db.php");

// Login check
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

if(!isset($_POST['play'])){
    header("Location: play.php");
    exit;
}

$user_id    = $_SESSION['user_id'];
$user_color = $_POST['color'];
$bet        = (int)$_POST['bet'];

// User wallet fetch
$data = mysqli_query($conn, "SELECT wallet FROM users WHERE id=$user_id");
$user = mysqli_fetch_assoc($data);

// Wallet validation
if($bet <= 0){
    header("Location: play.php?error=Invalid bet amount");
    exit;
}

if($bet > $user['wallet']){
    header("Location: play.php?error=Insufficient wallet balance");
    exit;
}

// Colours
$colors = ["Red","Green","Blue"];
$result_color = $colors[array_rand($colors)];

// Win / Lose logic
$result = "Lose";

if($user_color === $result_color){
    $result = "Win";
    $new_wallet = $user['wallet'] + $bet;
} else {
    $new_wallet = $user['wallet'] - $bet;
}

// Update wallet
mysqli_query($conn,
    "UPDATE users SET wallet=$new_wallet WHERE id=$user_id"
);

// Insert history
mysqli_query($conn,
"INSERT INTO game_history(user_id,bet_amount,user_color,result_color,result)
 VALUES($user_id,$bet,'$user_color','$result_color','$result')"
);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Game Result</title>
    <style>
        body{font-family:Arial;background:#f2f2f2;text-align:center;}
        .box{margin-top:70px;background:#fff;padding:30px;display:inline-block;border-radius:10px;}
        .win{color:green;font-size:26px;}
        .lose{color:red;font-size:26px;}
    </style>
</head>
<body>

<div class="box">
    <h2>🎯 Game Result</h2>

    <p>Your Colour: <b><?php echo $user_color; ?></b></p>
    <p>Result Colour: <b><?php echo $result_color; ?></b></p>

    <?php if($result=="Win"){ ?>
        <div class="win">🎉 YOU WIN</div>
    <?php } else { ?>
        <div class="lose">❌ YOU LOSE</div>
    <?php } ?>

    <p>Bet Amount: ₹<?php echo $bet; ?></p>
    <p>Updated Wallet: ₹<?php echo $new_wallet; ?></p>

    <br>
    <a href="play.php">Play Again</a> |
    <a href="dashboard.php">Dashboard</a>
</div>

</body>
</html>
