<?php
include("../config/db.php");
include("../config/session_user.php");

// Agar user already login hai to dashboard bhej do
if(isset($_SESSION['user_id'])){
    header("Location: dashboard.php");
    exit;
}

$msg = "";

if(isset($_POST['register'])){
    $name     = mysqli_real_escape_string($conn, $_POST['name']);
    $mobile   = mysqli_real_escape_string($conn, $_POST['mobile']);
    $password = mysqli_real_escape_string($conn, $_POST['password']);

    // Validate mobile number (10 digits)
    if(!preg_match('/^[0-9]{10}$/', $mobile)){
        $msg = "Please enter a valid 10-digit mobile number";
    } else {
        // Mobile number already exist check (stored in email column)
        $check = mysqli_query($conn, "SELECT id FROM users WHERE email='$mobile'");
        if(mysqli_num_rows($check) > 0){
            $msg = "Mobile number already registered";
        } else {
            // Store mobile number in email column
            $insert = mysqli_query($conn,
            "INSERT INTO users(name,email,password,wallet)
             VALUES('$name','$mobile','$password',0)");

            if($insert) {
                // Get the new user ID
                $new_user_id = mysqli_insert_id($conn);
                
                // Automatically log in the user
                $_SESSION['user_id'] = $new_user_id;
                $_SESSION['user_name'] = $name;
                
                // Set permanent cookies (1 year)
                setcookie('user_id_permanent', $new_user_id, time() + (86400 * 365), '/');
                setcookie('user_name_permanent', $name, time() + (86400 * 365), '/');
                
                // Redirect to dashboard
                header("Location: dashboard.php");
                exit;
            } else {
                $msg = "Registration failed! Please try again.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Register</title>
    <style>
        body{font-family:Arial;background:#f2f2f2;text-align:center;margin:0;padding:20px;}
        .box{margin-top:80px;background:#fff;padding:25px;display:inline-block;border-radius:10px;max-width:400px;width:100%;box-sizing:border-box;}
        input,button{margin:8px;padding:10px;width:250px;max-width:100%;box-sizing:border-box;}
        button{background:green;color:#fff;border:none;border-radius:5px;cursor:pointer;}
        button:hover{background:#006600;}
        .msg{color:red;}
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            body{padding:10px;}
            .box{margin-top:20px;padding:20px;width:95%;}
            input,button{width:100%;font-size:16px;padding:12px;margin:5px 0;}
            h2{font-size:24px;}
        }
        
        @media (max-width: 480px) {
            .box{margin-top:10px;padding:15px;}
            input,button{padding:14px;font-size:16px;}
            h2{font-size:20px;}
        }
    </style>
</head>
<body>

<div class="box">
    <h2>User Register</h2>

    <form method="post">
        <input type="text" name="name" placeholder="Full Name" required><br>
        <input type="tel" name="mobile" placeholder="Mobile Number (10 digits)" pattern="[0-9]{10}" maxlength="10" required><br>
        <input type="password" name="password" placeholder="Password" required><br>
        <button name="register">Register</button>
    </form>

    <div class="msg"><?php echo $msg; ?></div>

    <p>Already have account? <a href="login.php">Login</a></p>
    <p><a href="../index.php">Home</a></p>
</div>

</body>
</html>
