<?php
session_start();
include("../config/db.php");

// JSON header
header('Content-Type: application/json');

// Login check
if(!isset($_SESSION['user_id'])){
    echo json_encode([
        "status" => "error",
        "msg" => "Please login first"
    ]);
    exit;
}

$user_id = $_SESSION['user_id'];
$game_id = isset($_POST['game_id']) ? intval($_POST['game_id']) : 0;
$color   = isset($_POST['color']) ? trim($_POST['color']) : '';
$amount  = isset($_POST['amount']) ? intval($_POST['amount']) : 0;

$allowed_colors = ['red','green','violet'];

// Validation
if($game_id <= 0 || $amount <= 0 || !in_array($color,$allowed_colors)){
    echo json_encode([
        "status" => "error",
        "msg" => "Invalid bet data"
    ]);
    exit;
}

// User wallet check
$user_q = mysqli_query($conn,"SELECT wallet FROM users WHERE id=$user_id");
$user   = mysqli_fetch_assoc($user_q);

if(!$user){
    echo json_encode([
        "status" => "error",
        "msg" => "User not found"
    ]);
    exit;
}

if($user['wallet'] < $amount){
    echo json_encode([
        "status" => "error",
        "msg" => "Insufficient balance"
    ]);
    exit;
}

$new_balance = $user['wallet'] - $amount;

// Transaction start
mysqli_begin_transaction($conn);

try{
    $q1 = mysqli_query($conn,"UPDATE users SET wallet=$new_balance WHERE id=$user_id");
    $q2 = mysqli_query($conn,"INSERT INTO bets (user_id,game_id,color,amount) VALUES ($user_id,$game_id,'$color',$amount)");
    $q3 = mysqli_query($conn,"INSERT INTO transactions (user_id,type,amount,balance_after,note) VALUES ($user_id,'bet',$amount,$new_balance,'Bet placed')");

    if(!$q1 || !$q2 || !$q3){
        throw new Exception("DB Error");
    }

    mysqli_commit($conn);

    echo json_encode([
        "status" => "success",
        "msg" => "Bet placed successfully"
    ]);
    exit;

}catch(Exception $e){
    mysqli_rollback($conn);
    echo json_encode([
        "status" => "error",
        "msg" => "Something went wrong"
    ]);
    exit;
}
