<?php
$page_title = "Notices & Announcements";
include("includes/header.php");

// Create notices table if not exists
mysqli_query($conn, "
    CREATE TABLE IF NOT EXISTS notices (
        id INT AUTO_INCREMENT PRIMARY KEY,
        title VARCHAR(255) NOT NULL,
        content TEXT NOT NULL,
        type ENUM('info','warning','success','error') DEFAULT 'info',
        is_active BOOLEAN DEFAULT TRUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )
");

// Get all active notices
$notices = mysqli_query($conn, "
    SELECT * FROM notices 
    WHERE is_active = TRUE 
    ORDER BY created_at DESC
");
?>

<div class="container">
    <!-- Important Notice Banner -->
    <div class="content-box" style="background:rgba(255,193,7,0.2);border-color:#ffc107;">
        <h2 style="color:#ffc107;margin-bottom:15px;">📢 Important Announcements</h2>
        <p style="font-size:16px;line-height:1.6;">
            Stay updated with the latest news, updates, and important information about our platform. 
            Make sure to read all notices carefully to avoid any inconvenience.
        </p>
    </div>

    <!-- Notices List -->
    <div class="content-box">
        <h2 class="section-title">📋 All Notices</h2>
        
        <?php if($notices && mysqli_num_rows($notices) > 0): ?>
            <?php while($notice = mysqli_fetch_assoc($notices)): ?>
                <div class="card" style="margin-bottom:20px;border-left:4px solid <?= getNoticeColor($notice['type']) ?>;">
                    <div style="display:flex;justify-content:space-between;align-items:flex-start;margin-bottom:10px;">
                        <h3 style="color:<?= getNoticeColor($notice['type']) ?>;margin:0;font-size:18px;">
                            <?= getNoticeIcon($notice['type']) ?> <?= htmlspecialchars($notice['title']) ?>
                        </h3>
                        <span style="font-size:12px;opacity:0.7;white-space:nowrap;margin-left:15px;">
                            <?= date('M j, Y', strtotime($notice['created_at'])) ?>
                        </span>
                    </div>
                    <p style="margin:0;line-height:1.6;opacity:0.9;">
                        <?= nl2br(htmlspecialchars($notice['content'])) ?>
                    </p>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="empty-state">
                <div class="empty-state-icon">📢</div>
                <div class="empty-state-title">No Notices Available</div>
                <div class="empty-state-text">There are currently no active notices or announcements</div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Contact Information -->
    <div class="content-box">
        <h2 class="section-title">📞 Need Help?</h2>
        
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;">
            <div class="card">
                <h3 style="color:#27ae60;margin-bottom:10px;">💬 Live Chat</h3>
                <p>Get instant support through our live chat feature available 24/7.</p>
                <button class="btn btn-secondary" style="margin-top:10px;">Start Chat</button>
            </div>
            
            <div class="card">
                <h3 style="color:#3498db;margin-bottom:10px;">📧 Email Support</h3>
                <p>Send us your queries at support@colorprediction.com for detailed assistance.</p>
                <a href="mailto:support@colorprediction.com" class="btn btn-secondary" style="margin-top:10px;">Send Email</a>
            </div>
            
            <div class="card">
                <h3 style="color:#f39c12;margin-bottom:10px;">📱 WhatsApp</h3>
                <p>Connect with us on WhatsApp for quick support and updates.</p>
                <button class="btn btn-secondary" style="margin-top:10px;">+91 98765 43210</button>
            </div>
            
            <div class="card">
                <h3 style="color:#9b59b6;margin-bottom:10px;">❓ FAQ</h3>
                <p>Check our frequently asked questions for quick answers to common queries.</p>
                <button class="btn btn-secondary" style="margin-top:10px;">View FAQ</button>
            </div>
        </div>
    </div>

    <!-- Platform Rules -->
    <div class="content-box">
        <h2 class="section-title">📜 Platform Rules</h2>
        
        <div class="card">
            <h3 style="color:#e74c3c;margin-bottom:15px;">⚠️ Important Rules & Guidelines</h3>
            <ul style="line-height:1.8;padding-left:20px;">
                <li>Minimum age requirement: 18 years</li>
                <li>One account per person/device</li>
                <li>Minimum bet amount: ₹10</li>
                <li>Minimum withdrawal: ₹100</li>
                <li>Maximum withdrawal per day: ₹50,000</li>
                <li>Withdrawal processing: 24-48 hours</li>
                <li>Account verification required for withdrawals</li>
                <li>Responsible gaming practices encouraged</li>
                <li>Any suspicious activity will result in account suspension</li>
                <li>Platform reserves the right to modify rules with prior notice</li>
            </ul>
        </div>
    </div>
</div>

<?php
function getNoticeColor($type) {
    switch($type) {
        case 'success': return '#27ae60';
        case 'warning': return '#f39c12';
        case 'error': return '#e74c3c';
        case 'info':
        default: return '#3498db';
    }
}

function getNoticeIcon($type) {
    switch($type) {
        case 'success': return '✅';
        case 'warning': return '⚠️';
        case 'error': return '❌';
        case 'info':
        default: return 'ℹ️';
    }
}

include("includes/footer.php");
?>