<?php
include("../config/db.php");
include("../config/session_user.php");

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$user_id = (int)$_SESSION['user_id'];
$user = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM users WHERE id=$user_id"));
?>
<!DOCTYPE html>
<html>
<head>
<title><?= $page_title ?? 'User Panel' ?> - Color Prediction</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    color: #fff;
}

/* ANIMATED BACKGROUND */
body::before {
    content: '';
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: 
        radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.3) 0%, transparent 50%),
        radial-gradient(circle at 40% 40%, rgba(120, 219, 255, 0.2) 0%, transparent 50%);
    z-index: -1;
    animation: backgroundShift 20s ease-in-out infinite;
}

@keyframes backgroundShift {
    0%, 100% { transform: translateX(0) translateY(0); }
    25% { transform: translateX(-20px) translateY(-10px); }
    50% { transform: translateX(10px) translateY(-20px); }
    75% { transform: translateX(-10px) translateY(10px); }
}

/* HEADER */
.header {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-bottom: 1px solid rgba(255, 255, 255, 0.2);
    padding: 15px 25px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
}

.header-left {
    display: flex;
    align-items: center;
    gap: 15px;
}

.back-btn {
    background: rgba(255, 255, 255, 0.2);
    border: none;
    color: #fff;
    padding: 8px 15px;
    border-radius: 10px;
    cursor: pointer;
    font-size: 14px;
    font-weight: 600;
    transition: all 0.3s ease;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 5px;
}

.back-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: translateY(-1px);
}

.page-title {
    font-size: 24px;
    font-weight: 700;
    color: #fff;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.user-info {
    text-align: right;
}

.user-name {
    font-size: 16px;
    font-weight: 600;
    color: #fff;
}

.user-balance {
    font-size: 20px;
    font-weight: 700;
    color: #ffd700;
    text-shadow: 0 2px 10px rgba(255, 215, 0, 0.3);
}

/* MAIN CONTAINER */
.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 25px;
}

.content-box {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(20px);
    border-radius: 20px;
    padding: 30px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    margin-bottom: 25px;
}

.section-title {
    font-size: 28px;
    font-weight: 700;
    color: #fff;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
}

/* CARDS */
.card {
    background: rgba(255, 255, 255, 0.15);
    backdrop-filter: blur(20px);
    border-radius: 15px;
    padding: 20px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: all 0.3s ease;
    margin-bottom: 15px;
}

.card:hover {
    transform: translateY(-3px);
    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
    border-color: rgba(255, 255, 255, 0.4);
}

/* BUTTONS */
.btn {
    background: linear-gradient(135deg, #ffd700, #ffb700);
    color: #000;
    border: none;
    padding: 12px 25px;
    border-radius: 10px;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 215, 0, 0.4);
}

.btn-secondary {
    background: rgba(255, 255, 255, 0.2);
    color: #fff;
}

.btn-secondary:hover {
    background: rgba(255, 255, 255, 0.3);
}

/* TABLE */
.table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

.table th,
.table td {
    padding: 15px;
    text-align: left;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.table th {
    background: rgba(255, 255, 255, 0.1);
    font-weight: 700;
    color: #ffd700;
}

.table tr:hover {
    background: rgba(255, 255, 255, 0.05);
}

/* STATUS BADGES */
.status {
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.status.win {
    background: rgba(39, 174, 96, 0.3);
    color: #27ae60;
    border: 1px solid #27ae60;
}

.status.loss {
    background: rgba(231, 76, 60, 0.3);
    color: #e74c3c;
    border: 1px solid #e74c3c;
}

.status.pending {
    background: rgba(255, 193, 7, 0.3);
    color: #ffc107;
    border: 1px solid #ffc107;
}

/* MOBILE RESPONSIVE - MINIMAL CHANGES ONLY */
@media (max-width: 768px) {
    .container {
        padding: 10px;
    }
    
    .content-box {
        padding: 12px;
        margin-bottom: 15px;
    }
    
    .table {
        font-size: 11px;
    }
    
    .table th, .table td {
        padding: 6px 4px;
        font-size: 10px;
    }
    
    .btn {
        padding: 8px 12px;
        font-size: 12px;
    }
    
    .form-input {
        font-size: 16px; /* Prevent zoom on iOS */
    }
}
    
    /* Specific table data labels for user pages - NOT USED IN NORMAL TABLE MODE */
    .game-history-table td:nth-child(1):before { content: "Date: "; }
    .game-history-table td:nth-child(2):before { content: "Game ID: "; }
    .game-history-table td:nth-child(3):before { content: "My Color: "; }
    .game-history-table td:nth-child(4):before { content: "Winning Color: "; }
    .game-history-table td:nth-child(5):before { content: "Bet Amount: "; }
    .game-history-table td:nth-child(6):before { content: "Win Amount: "; }
    .game-history-table td:nth-child(7):before { content: "Status: "; }
    
    .recharge-history-table td:nth-child(1):before { content: "Date: "; }
    .recharge-history-table td:nth-child(2):before { content: "Amount: "; }
    .recharge-history-table td:nth-child(3):before { content: "Method: "; }
    .recharge-history-table td:nth-child(4):before { content: "Status: "; }
    
    .withdrawal-history-table td:nth-child(1):before { content: "Date: "; }
    .withdrawal-history-table td:nth-child(2):before { content: "Amount: "; }
    .withdrawal-history-table td:nth-child(3):before { content: "Method: "; }
    .withdrawal-history-table td:nth-child(4):before { content: "Status: "; }
    .withdrawal-history-table td:nth-child(5):before { content: "Processed: "; }
    
    .result-history-table td:nth-child(1):before { content: "Time: "; }
    .result-history-table td:nth-child(2):before { content: "Winning Color: "; }
    .result-history-table td:nth-child(3):before { content: "Total Bets: "; }
    .result-history-table td:nth-child(4):before { content: "Winners: "; }
    .result-history-table td:nth-child(5):before { content: "Total Wagered: "; }
    .result-history-table td:nth-child(6):before { content: "Total Winnings: "; }
    .result-history-table td:nth-child(7):before { content: "House Edge: "; }
    
    .wallet-history-table td:nth-child(1):before { content: "Time: "; }
    .wallet-history-table td:nth-child(2):before { content: "Amount: "; }
    .wallet-history-table td:nth-child(3):before { content: "Method: "; }
    .wallet-history-table td:nth-child(4):before { content: "Status: "; }
    .wallet-history-table td:nth-child(5):before { content: "Win Amount: "; }
    
    /* For betting history in wallet_history.php (5 columns) */
    .wallet-history-table.betting-table td:nth-child(1):before { content: "Time: "; }
    .wallet-history-table.betting-table td:nth-child(2):before { content: "Bets Count: "; }
    .wallet-history-table.betting-table td:nth-child(3):before { content: "Total Bet: "; }
    .wallet-history-table.betting-table td:nth-child(4):before { content: "Result: "; }
    .wallet-history-table.betting-table td:nth-child(5):before { content: "Win Amount: "; }
}

@media (max-width: 480px) {
    .container {
        padding: 8px;
    }
    
    .content-box {
        padding: 10px;
        margin-bottom: 12px;
    }
    
    .table {
        font-size: 9px;
    }
    
    .table th, .table td {
        padding: 4px 2px;
        font-size: 8px;
    }
    
    .btn {
        padding: 6px 10px;
        font-size: 11px;
    }
    
    .form-input {
        font-size: 16px; /* Prevent zoom on iOS */
    }
}

/* Touch-friendly improvements */
@media (max-width: 768px) {
    .card {
        min-height: 80px;
        touch-action: manipulation;
        -webkit-tap-highlight-color: rgba(255, 255, 255, 0.1);
    }
    
    .btn {
        min-height: 44px;
        touch-action: manipulation;
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0.1);
    }
    
    /* Prevent zoom on form inputs */
    input, select, textarea {
        font-size: 16px;
    }
    
    /* Better scrolling on mobile */
    .content-box {
        -webkit-overflow-scrolling: touch;
    }
}

/* FORM STYLES */
.form-group {
    margin-bottom: 20px;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #fff;
}

.form-input {
    width: 100%;
    padding: 12px 15px;
    border: 1px solid rgba(255, 255, 255, 0.3);
    border-radius: 10px;
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
    font-size: 16px;
    backdrop-filter: blur(10px);
}

.form-input:focus {
    outline: none;
    border-color: #ffd700;
    box-shadow: 0 0 0 3px rgba(255, 215, 0, 0.2);
}

.form-input::placeholder {
    color: rgba(255, 255, 255, 0.6);
}

/* SELECT DROPDOWN STYLING */
.form-input select {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
}

.form-input option {
    background: #2c3e50;
    color: #fff;
    padding: 10px;
}

.form-input option:hover {
    background: #34495e;
}

/* For better cross-browser support */
select.form-input {
    background: rgba(255, 255, 255, 0.1);
    color: #fff;
}

select.form-input option {
    background: #2c3e50;
    color: #fff;
    padding: 10px;
}

select.form-input option:hover,
select.form-input option:focus,
select.form-input option:checked {
    background: #34495e;
    color: #fff;
}

/* EMPTY STATE */
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: rgba(255, 255, 255, 0.7);
}

.empty-state-icon {
    font-size: 64px;
    margin-bottom: 20px;
    opacity: 0.5;
}

.empty-state-title {
    font-size: 24px;
    font-weight: 600;
    margin-bottom: 10px;
    color: #fff;
}

.empty-state-text {
    font-size: 16px;
    margin-bottom: 30px;
}
</style>
</head>
<body>

<div class="header">
    <div class="header-left">
        <a href="dashboard.php" class="back-btn">
            ⬅ Back to Dashboard
        </a>
        <h1 class="page-title"><?= $page_title ?? 'User Panel' ?></h1>
    </div>
    
    <div class="header-right">
        <div class="user-info">
            <div class="user-name">👤 <?= htmlspecialchars($user['name']) ?></div>
            <div class="user-balance">💰 ₹<?= number_format($user['wallet'], 2) ?></div>
        </div>
    </div>
</div>