<?php
$page_title = "Game History";
include("includes/header.php");

// Get selected date (default to today)
$selected_date = isset($_GET['date']) && !empty($_GET['date']) ? $_GET['date'] : date('Y-m-d');

// Validate date format
if(!preg_match('/^\d{4}-\d{2}-\d{2}$/', $selected_date)) {
    $selected_date = date('Y-m-d');
}

// Date range for query
$date_start = $selected_date . ' 00:00:00';
$date_end = $selected_date . ' 23:59:59';

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

// Get total count for selected date
$total_query = mysqli_query($conn, "
    SELECT COUNT(*) as total 
    FROM bets 
    WHERE user_id=$user_id 
    AND created_at BETWEEN '$date_start' AND '$date_end'
");
$total_bets = mysqli_fetch_assoc($total_query)['total'];
$total_pages = ceil($total_bets / $limit);

// Get bets with game info for selected date
$bets_query = mysqli_query($conn, "
    SELECT b.*, g.winning_color, g.completed_at as game_completed
    FROM bets b
    LEFT JOIN games g ON b.game_id = g.id
    WHERE b.user_id = $user_id
    AND b.created_at BETWEEN '$date_start' AND '$date_end'
    ORDER BY b.created_at DESC
    LIMIT $limit OFFSET $offset
");
?>

<div class="container">
    <!-- Stats Overview -->
    <div class="content-box">
        <h2 class="section-title">📊 Statistics for <?= date('M j, Y', strtotime($selected_date)) ?></h2>
        
        <?php
        $stats = mysqli_fetch_assoc(mysqli_query($conn, "
            SELECT 
                COUNT(*) as total_bets,
                SUM(CASE WHEN status='win' THEN 1 ELSE 0 END) as wins,
                SUM(CASE WHEN status='loss' THEN 1 ELSE 0 END) as losses,
                SUM(CASE WHEN status='pending' THEN 1 ELSE 0 END) as pending,
                SUM(amount) as total_wagered,
                SUM(win_amount) as total_winnings,
                AVG(amount) as avg_bet
            FROM bets 
            WHERE user_id=$user_id 
            AND created_at BETWEEN '$date_start' AND '$date_end'
        "));
        
        // Handle null values from SQL
        $total_bets = $stats['total_bets'] ?? 0;
        $wins = $stats['wins'] ?? 0;
        $losses = $stats['losses'] ?? 0;
        $pending = $stats['pending'] ?? 0;
        $total_wagered = $stats['total_wagered'] ?? 0;
        $total_winnings = $stats['total_winnings'] ?? 0;
        
        $win_rate = $total_bets > 0 ? round(($wins / $total_bets) * 100, 1) : 0;
        $profit_loss = $total_winnings - $total_wagered;
        ?>
        
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:20px;">
            <div class="card">
                <h3 style="color:#ffd700;margin-bottom:10px;">🎯 Total Bets</h3>
                <p style="font-size:24px;font-weight:700;"><?= number_format($total_bets) ?></p>
            </div>
            
            <div class="card">
                <h3 style="color:#27ae60;margin-bottom:10px;">✅ Wins</h3>
                <p style="font-size:24px;font-weight:700;color:#27ae60;"><?= number_format($wins) ?></p>
            </div>
            
            <div class="card">
                <h3 style="color:#e74c3c;margin-bottom:10px;">❌ Losses</h3>
                <p style="font-size:24px;font-weight:700;color:#e74c3c;"><?= number_format($losses) ?></p>
            </div>
            
            <div class="card">
                <h3 style="color:#f39c12;margin-bottom:10px;">⏳ Pending</h3>
                <p style="font-size:24px;font-weight:700;color:#f39c12;"><?= number_format($pending) ?></p>
            </div>
            
            <div class="card">
                <h3 style="color:#3498db;margin-bottom:10px;">📈 Win Rate</h3>
                <p style="font-size:24px;font-weight:700;color:#3498db;"><?= $win_rate ?>%</p>
            </div>
            
            <div class="card">
                <h3 style="color:<?= $profit_loss >= 0 ? '#27ae60' : '#e74c3c' ?>;margin-bottom:10px;">
                    <?= $profit_loss >= 0 ? '📈' : '📉' ?> P&L
                </h3>
                <p style="font-size:20px;font-weight:700;color:<?= $profit_loss >= 0 ? '#27ae60' : '#e74c3c' ?>;">
                    ₹<?= number_format($profit_loss, 2) ?>
                </p>
            </div>
        </div>
        
        <!-- Overall Statistics Link -->
        <div style="text-align:center;margin-top:20px;padding-top:20px;border-top:1px solid rgba(255,255,255,0.1);">
            <p style="opacity:0.8;margin-bottom:10px;">Want to see your overall performance?</p>
            <a href="overall_stats.php" class="btn btn-secondary">📈 View Overall Statistics</a>
        </div>
    </div>

    <!-- Betting History -->
    <div class="content-box">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;flex-wrap:wrap;gap:15px;">
            <h2 class="section-title">🎮 Betting History for <?= date('M j, Y', strtotime($selected_date)) ?></h2>
            
            <!-- Date Filter -->
            <form method="get" style="display:flex;align-items:center;gap:10px;">
                <input type="date" name="date" value="<?= $selected_date ?>" class="form-input" style="width:auto;min-width:150px;">
                <button type="submit" class="btn">📊 View History</button>
                <a href="?date=<?= date('Y-m-d') ?>" class="btn btn-secondary">📅 Today</a>
                <?php if(isset($_GET['page']) && $_GET['page'] > 1): ?>
                    <input type="hidden" name="page" value="1">
                <?php endif; ?>
            </form>
        </div>
        
        <?php if($bets_query && mysqli_num_rows($bets_query) > 0): ?>
            <table class="table game-history-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <!--<th>Game ID</th>-->
                        <th>My Color</th>
                        <th>Winning Color</th>
                        <th>Bet Amount</th>
                        <th>Win Amount</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($bet = mysqli_fetch_assoc($bets_query)): ?>
                        <tr>
                            <td><?= date('M j, Y H:i', strtotime($bet['created_at'])) ?></td>
                            <!--<td style="font-family:monospace;">#<?= $bet['game_id'] ?></td>-->
                            <td>
                                <span style="display:inline-block;width:20px;height:20px;border-radius:50%;background:<?= getColorCode($bet['color']) ?>;margin-right:8px;"></span>
                                <?= strtoupper($bet['color']) ?>
                            </td>
                            <td>
                                <?php if($bet['winning_color']): ?>
                                    <span style="display:inline-block;width:20px;height:20px;border-radius:50%;background:<?= getColorCode($bet['winning_color']) ?>;margin-right:8px;"></span>
                                    <?= strtoupper($bet['winning_color']) ?>
                                <?php else: ?>
                                    <span style="opacity:0.6;">-</span>
                                <?php endif; ?>
                            </td>
                            <td style="font-weight:700;">₹<?= number_format($bet['amount'], 2) ?></td>
                            <td style="font-weight:700;color:<?= $bet['win_amount'] > 0 ? '#27ae60' : '#666' ?>;">
                                ₹<?= number_format($bet['win_amount'], 2) ?>
                            </td>
                            <td>
                                <span class="status <?= $bet['status'] ?>">
                                    <?= ucfirst($bet['status']) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
            
            <!-- Pagination -->
            <?php if($total_pages > 1): ?>
                <div style="text-align:center;margin-top:30px;">
                    <?php for($i = 1; $i <= $total_pages; $i++): ?>
                        <a href="?page=<?= $i ?>&date=<?= $selected_date ?>" class="btn <?= $i == $page ? '' : 'btn-secondary' ?>" style="margin:0 5px;">
                            <?= $i ?>
                        </a>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>
            
        <?php else: ?>
            <div class="empty-state">
                <div class="empty-state-icon">🎮</div>
                <div class="empty-state-title">No Betting History</div>
                <div class="empty-state-text">
                    <?php if($selected_date == date('Y-m-d')): ?>
                        No bets placed today. Start playing games to see your betting history here
                    <?php else: ?>
                        No bets found for <?= date('M j, Y', strtotime($selected_date)) ?>
                    <?php endif; ?>
                </div>
                <div style="margin-top:20px;">
                    <a href="game.php" class="btn" style="margin-right:10px;">🎯 Play Now</a>
                    <a href="?date=<?= date('Y-m-d') ?>" class="btn btn-secondary">📅 View Today</a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
function getColorCode($color) {
    $colors = [
        'red' => '#ef4444',
        'green' => '#22c55e', 
        'yellow' => '#facc15',
        'blue' => '#3b82f6',
        'purple' => '#a855f7',
        'orange' => '#fb923c',
        'pink' => '#ec4899',
        'cyan' => '#06b6d4'
    ];
    return $colors[strtolower($color)] ?? '#666';
}

include("includes/footer.php");
?>