<?php
include("config/db.php");

echo "<h2>🧪 Testing Smart Deduction System</h2>";

// Add columns if not exist
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS recharge_amount DECIMAL(10,2) DEFAULT 0.00");
mysqli_query($conn, "ALTER TABLE users ADD COLUMN IF NOT EXISTS winning_amount DECIMAL(10,2) DEFAULT 0.00");

// Get a test user (assuming user ID 1 exists)
$test_user_id = 1;
$user = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM users WHERE id = $test_user_id"));

if(!$user) {
    echo "<p style='color:red;'>❌ Test user not found. Please ensure user ID 1 exists.</p>";
    exit;
}

echo "<h3>Current User Balance:</h3>";
echo "<div style='background:#f8f9fa;padding:15px;margin:10px 0;border-radius:8px;border-left:4px solid #007bff;'>";
echo "<p><strong>👤 User:</strong> {$user['name']} (ID: {$user['id']})</p>";
echo "<p><strong>💰 Total Wallet:</strong> ₹" . number_format($user['wallet'], 2) . "</p>";
echo "<p><strong>💳 Recharge Amount:</strong> ₹" . number_format($user['recharge_amount'], 2) . "</p>";
echo "<p><strong>🎯 Winning Amount:</strong> ₹" . number_format($user['winning_amount'], 2) . "</p>";
echo "</div>";

// Test different betting scenarios
$test_scenarios = [
    ['bet_amount' => 5, 'description' => 'Small bet (less than recharge)'],
    ['bet_amount' => 10, 'description' => 'Exact recharge amount'],
    ['bet_amount' => 15, 'description' => 'More than recharge, less than total'],
    ['bet_amount' => 20, 'description' => 'Your example: ₹20 bet'],
    ['bet_amount' => 50, 'description' => 'Large bet (uses both recharge and winning)']
];

echo "<h3>Smart Deduction Test Scenarios:</h3>";

foreach($test_scenarios as $scenario) {
    $bet_amount = $scenario['bet_amount'];
    $description = $scenario['description'];
    
    echo "<div style='background:#fff3cd;padding:15px;margin:10px 0;border-radius:8px;border-left:4px solid #ffc107;'>";
    echo "<h4>🎮 Scenario: {$description}</h4>";
    echo "<p><strong>Bet Amount:</strong> ₹{$bet_amount}</p>";
    
    // Calculate smart deduction
    $current_recharge = $user['recharge_amount'];
    $current_winning = $user['winning_amount'];
    $current_wallet = $user['wallet'];
    
    if($bet_amount > $current_wallet) {
        echo "<p style='color:#e74c3c;'><strong>❌ Insufficient Balance!</strong></p>";
        echo "<p>Need: ₹{$bet_amount}, Have: ₹" . number_format($current_wallet, 2) . "</p>";
    } else {
        // Smart deduction logic
        if($current_recharge >= $bet_amount) {
            // Can deduct everything from recharge
            $deduct_from_recharge = $bet_amount;
            $deduct_from_winning = 0;
        } else {
            // Deduct all recharge, rest from winning
            $deduct_from_recharge = $current_recharge;
            $deduct_from_winning = $bet_amount - $current_recharge;
        }
        
        $remaining_recharge = $current_recharge - $deduct_from_recharge;
        $remaining_winning = $current_winning - $deduct_from_winning;
        $remaining_wallet = $remaining_recharge + $remaining_winning;
        
        echo "<p><strong>💡 Smart Deduction Breakdown:</strong></p>";
        echo "<p>🔸 From Recharge: ₹{$deduct_from_recharge}</p>";
        echo "<p>🔸 From Winning: ₹{$deduct_from_winning}</p>";
        
        echo "<p><strong>📊 After Bet:</strong></p>";
        echo "<p>💳 Remaining Recharge: ₹" . number_format($remaining_recharge, 2) . "</p>";
        echo "<p>🎯 Remaining Winning: ₹" . number_format($remaining_winning, 2) . "</p>";
        echo "<p>💰 Total Wallet: ₹" . number_format($remaining_wallet, 2) . "</p>";
        
        if($deduct_from_recharge > 0 && $deduct_from_winning > 0) {
            echo "<p style='color:#28a745;'><strong>✅ Uses both recharge and winning money</strong></p>";
        } else if($deduct_from_recharge > 0) {
            echo "<p style='color:#17a2b8;'><strong>✅ Uses only recharge money</strong></p>";
        } else {
            echo "<p style='color:#ffc107;'><strong>✅ Uses only winning money</strong></p>";
        }
    }
    
    echo "</div>";
}

echo "<h3>🎯 Your Specific Example:</h3>";
echo "<div style='background:#d4edda;padding:15px;border-radius:8px;border:1px solid #c3e6cb;margin:20px 0;'>";
echo "<p><strong>Scenario:</strong> User has ₹10 recharge + ₹110 winning = ₹120 total</p>";
echo "<p><strong>User bets:</strong> ₹20</p>";
echo "<p><strong>Smart Deduction:</strong></p>";
echo "<ul>";
echo "<li>₹10 deducted from recharge amount (recharge becomes ₹0)</li>";
echo "<li>₹10 deducted from winning amount (winning becomes ₹100)</li>";
echo "<li>Total wallet becomes ₹100</li>";
echo "</ul>";
echo "<p style='color:#28a745;'><strong>✅ This is exactly how the system works!</strong></p>";
echo "</div>";

echo "<h3>🔧 How to Test:</h3>";
echo "<div style='background:#d1ecf1;padding:15px;border-radius:8px;border:1px solid #bee5eb;margin:20px 0;'>";
echo "<ol>";
echo "<li>Go to the game page</li>";
echo "<li>Place a bet for ₹20</li>";
echo "<li>Check the browser console for deduction_info in the response</li>";
echo "<li>Verify that recharge and winning amounts are deducted correctly</li>";
echo "</ol>";
echo "</div>";

echo "<br><a href='user/game.php' target='_blank' style='background:#28a745;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>🎮 Test in Game</a>";
?>