<?php
// Test file to verify mobile responsive tables with proper headings
$page_title = "Mobile Table Test";
include("user/includes/header.php");
?>

<div class="container">
    <div class="content-box">
        <h2 class="section-title">📱 Mobile Table Test</h2>
        <p>This page tests the mobile responsive tables with proper headings. Resize your browser or view on mobile to see the effect.</p>
        
        <h3>🎮 Game History Table Test</h3>
        <table class="table game-history-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Game ID</th>
                    <th>My Color</th>
                    <th>Winning Color</th>
                    <th>Bet Amount</th>
                    <th>Win Amount</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Jan 6, 2026 14:30</td>
                    <td>#12345</td>
                    <td>RED</td>
                    <td>GREEN</td>
                    <td>₹100.00</td>
                    <td>₹0.00</td>
                    <td><span class="status loss">Loss</span></td>
                </tr>
                <tr>
                    <td>Jan 6, 2026 14:25</td>
                    <td>#12344</td>
                    <td>BLUE</td>
                    <td>BLUE</td>
                    <td>₹50.00</td>
                    <td>₹100.00</td>
                    <td><span class="status win">Win</span></td>
                </tr>
            </tbody>
        </table>
        
        <h3>💳 Recharge History Table Test</h3>
        <table class="table recharge-history-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Jan 6, 2026 14:00</td>
                    <td>₹500.00</td>
                    <td>UPI</td>
                    <td><span class="status pending">Pending</span></td>
                </tr>
                <tr>
                    <td>Jan 6, 2026 13:30</td>
                    <td>₹1000.00</td>
                    <td>Bank Transfer</td>
                    <td><span class="status win">Approved</span></td>
                </tr>
            </tbody>
        </table>
        
        <h3>🏧 Withdrawal History Table Test</h3>
        <table class="table withdrawal-history-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Processed</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Jan 6, 2026 12:00</td>
                    <td>₹200.00</td>
                    <td>Paytm</td>
                    <td><span class="status pending">Pending</span></td>
                    <td>-</td>
                </tr>
                <tr>
                    <td>Jan 5, 2026 18:30</td>
                    <td>₹150.00</td>
                    <td>UPI</td>
                    <td><span class="status win">Approved</span></td>
                    <td>Jan 5, 2026</td>
                </tr>
            </tbody>
        </table>
        
        <h3>🏆 Result History Table Test</h3>
        <table class="table result-history-table">
            <thead>
                <tr>
                    <th>Game ID</th>
                    <th>Date & Time</th>
                    <th>Winning Color</th>
                    <th>Total Bets</th>
                    <th>Winners</th>
                    <th>Total Wagered</th>
                    <th>Total Winnings</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>#12345</td>
                    <td>Jan 6, 2026 14:30:00</td>
                    <td>GREEN</td>
                    <td>25</td>
                    <td>8</td>
                    <td>₹2,500.00</td>
                    <td>₹1,600.00</td>
                </tr>
                <tr>
                    <td>#12344</td>
                    <td>Jan 6, 2026 14:25:00</td>
                    <td>BLUE</td>
                    <td>18</td>
                    <td>5</td>
                    <td>₹1,800.00</td>
                    <td>₹1,000.00</td>
                </tr>
            </tbody>
        </table>
        
        <div style="margin-top:30px;padding:20px;background:rgba(39,174,96,0.2);border-radius:10px;border:1px solid #27ae60;">
            <h3 style="color:#27ae60;margin-bottom:15px;">✅ Mobile Responsive Features</h3>
            <ul style="color:#27ae60;text-align:left;">
                <li>✅ Tables convert to card layout on mobile</li>
                <li>✅ Each field shows proper label (Date:, Amount:, etc.)</li>
                <li>✅ Headers are hidden on mobile but data labels show</li>
                <li>✅ Touch-friendly spacing and sizing</li>
                <li>✅ Proper color coding for status badges</li>
                <li>✅ Responsive design works on all screen sizes</li>
            </ul>
        </div>
        
        <div style="margin-top:20px;text-align:center;">
            <a href="user/dashboard.php" class="btn">🏠 Back to Dashboard</a>
            <a href="user/game_history.php" class="btn btn-secondary">🎮 Real Game History</a>
        </div>
    </div>
</div>

<script>
// Show current screen width for testing
function updateScreenInfo() {
    const width = window.innerWidth;
    let deviceType = 'Desktop';
    if (width <= 480) {
        deviceType = 'Mobile (Small)';
    } else if (width <= 768) {
        deviceType = 'Mobile/Tablet';
    }
    
    console.log(`Screen Width: ${width}px - Device Type: ${deviceType}`);
}

updateScreenInfo();
window.addEventListener('resize', updateScreenInfo);
</script>

<?php include("user/includes/footer.php"); ?>