<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Colour Prediction Game</title>
    <style>
        body{
            font-family: Arial;
            background: #f2f2f2;
            text-align: center;
            margin: 0;
            padding: 20px;
        }
        .box{
            margin-top: 100px;
            background: #fff;
            padding: 30px;
            display: inline-block;
            border-radius: 10px;
            max-width: 400px;
            width: 100%;
            box-sizing: border-box;
        }
        a{
            display: block;
            margin: 15px 0;
            padding: 12px;
            background: green;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-size: 16px;
            transition: background 0.3s ease;
        }
        a:hover{
            background: #006600;
        }
        a.admin{
            background: #333;
        }
        a.admin:hover{
            background: #555;
        }
        
        /* Mobile Responsive */
        @media (max-width: 768px) {
            body{padding:10px;}
            .box{margin-top:20px;padding:25px;width:95%;}
            a{padding:15px;font-size:16px;margin:10px 0;}
            h2{font-size:24px;}
        }
        
        @media (max-width: 480px) {
            .box{margin-top:10px;padding:20px;}
            a{padding:18px;font-size:16px;}
            h2{font-size:20px;}
        }
    </style>
</head>
<body>

<div class="box">
    <h2>🎯 Colour Prediction Game</h2>

    <a href="user/register.php">User Register</a>
    <a href="user/login.php">User Login</a>

    <hr>

    <a href="admin/login.php" class="admin">Admin Login</a>
</div>

</body>
</html>
