<!DOCTYPE html>
<html>
<head>
<title>🎮 Game Manager - Auto Background Processing</title>
<style>
body {
    font-family: Arial, sans-serif;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    margin: 0;
    padding: 20px;
}
.container {
    max-width: 800px;
    margin: 0 auto;
    background: rgba(255,255,255,0.1);
    padding: 20px;
    border-radius: 15px;
    backdrop-filter: blur(10px);
}
.status {
    background: rgba(0,0,0,0.3);
    padding: 15px;
    border-radius: 10px;
    margin: 10px 0;
    font-family: monospace;
}
.controls {
    text-align: center;
    margin: 20px 0;
}
button {
    background: #ffd700;
    color: #000;
    border: none;
    padding: 10px 20px;
    border-radius: 8px;
    cursor: pointer;
    margin: 5px;
    font-weight: bold;
}
button:hover {
    background: #ffed4e;
}
.auto-status {
    text-align: center;
    font-size: 18px;
    margin: 20px 0;
}
.log {
    background: rgba(0,0,0,0.5);
    padding: 10px;
    border-radius: 8px;
    height: 200px;
    overflow-y: auto;
    font-family: monospace;
    font-size: 12px;
}
</style>
</head>
<body>

<div class="container">
    <h1>🎮 Game Manager</h1>
    <p>यह page games को automatically process करता है। इसे browser में खुला रखें।</p>
    
    <div class="auto-status" id="autoStatus">
        🔴 Auto Processing: OFF
    </div>
    
    <div class="controls">
        <button onclick="toggleAutoProcess()">🔄 Toggle Auto Processing</button>
        <button onclick="processNow()">⚡ Process Now</button>
        <button onclick="clearLog()">🗑️ Clear Log</button>
        <button onclick="openGame()">🎮 Open Game</button>
        <button onclick="openDashboard()">📊 Open Dashboard</button>
    </div>
    
    <div class="status" id="gameStatus">
        Loading game status...
    </div>
    
    <div class="log" id="logContainer">
        <div id="log">Game Manager Started...<br></div>
    </div>
</div>

<script>
let autoProcessing = false;
let autoInterval = null;
let logCount = 0;

function log(message) {
    const now = new Date().toLocaleTimeString();
    const logDiv = document.getElementById('log');
    logCount++;
    logDiv.innerHTML += `[${now}] ${message}<br>`;
    
    // Keep only last 50 log entries
    if(logCount > 50) {
        const lines = logDiv.innerHTML.split('<br>');
        logDiv.innerHTML = lines.slice(-50).join('<br>');
        logCount = 50;
    }
    
    // Auto scroll to bottom
    const container = document.getElementById('logContainer');
    container.scrollTop = container.scrollHeight;
}

function updateStatus(data) {
    const statusDiv = document.getElementById('gameStatus');
    
    if(data.current_game) {
        const remaining = data.remaining_seconds || 0;
        statusDiv.innerHTML = `
            🎯 <strong>Current Game:</strong> ${data.current_game}<br>
            ⏰ <strong>Time Remaining:</strong> ${remaining} seconds<br>
            📊 <strong>Status:</strong> ${data.message}
        `;
    } else {
        statusDiv.innerHTML = `
            🆕 <strong>Status:</strong> ${data.message}
        `;
    }
}

function processNow() {
    log('🔄 Manual processing triggered...');
    
    fetch('game_cron.php')
    .then(r => r.json())
    .then(data => {
        log(`✅ Process result: ${data.message}`);
        updateStatus(data);
        
        if(data.actions) {
            data.actions.forEach(action => {
                if(action === 'game_completed') {
                    log(`🏁 Game ${data.completed_game} completed! Winner: ${data.winner}`);
                    log(`👥 Winners: ${data.winners_count}, Payout: ₹${data.total_payout}`);
                    log(`🆕 New game started: ${data.new_game}`);
                } else if(action === 'game_created') {
                    log(`🆕 New game created: ${data.new_game}`);
                }
            });
        }
    })
    .catch(e => {
        log(`❌ Process failed: ${e.message}`);
    });
}

function toggleAutoProcess() {
    const statusDiv = document.getElementById('autoStatus');
    
    if(autoProcessing) {
        // Stop auto processing
        if(autoInterval) {
            clearInterval(autoInterval);
            autoInterval = null;
        }
        autoProcessing = false;
        statusDiv.innerHTML = '🔴 Auto Processing: OFF';
        log('🔴 Auto processing stopped');
    } else {
        // Start auto processing
        autoInterval = setInterval(processNow, 10000); // Every 10 seconds
        autoProcessing = true;
        statusDiv.innerHTML = '🟢 Auto Processing: ON (10s interval)';
        log('🟢 Auto processing started (10 second interval)');
        
        // Process immediately
        processNow();
    }
}

function clearLog() {
    document.getElementById('log').innerHTML = 'Log cleared...<br>';
    logCount = 1;
}

function openGame() {
    window.open('user/game.php', '_blank');
}

function openDashboard() {
    window.open('user/dashboard.php', '_blank');
}

// Auto-start processing when page loads
window.addEventListener('load', function() {
    log('🚀 Game Manager loaded');
    
    // Get initial status
    processNow();
    
    // Auto-start processing after 3 seconds
    setTimeout(() => {
        log('🔄 Auto-starting background processing...');
        toggleAutoProcess();
    }, 3000);
});

// Keep page alive - prevent browser from sleeping
setInterval(() => {
    // Ping to keep connection alive
    fetch('game_cron.php', {method: 'HEAD'}).catch(() => {});
}, 30000);

// Warn user before closing
window.addEventListener('beforeunload', function(e) {
    if(autoProcessing) {
        e.preventDefault();
        e.returnValue = 'Game processing is running. Are you sure you want to close?';
    }
});
</script>

</body>
</html>